/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators;

import com.hazelcast.sql.impl.calcite.validate.types.HazelcastOperandTypes;
import com.hazelcast.sql.impl.calcite.validate.types.ReplaceUnknownOperandTypeInference;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlLikeOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;

public class HazelcastSqlLikeOperator
extends SqlSpecialOperator {
    private static final int PRECEDENCE = 32;

    public HazelcastSqlLikeOperator() {
        super("LIKE", SqlKind.LIKE, 32, false, ReturnTypes.BOOLEAN_NULLABLE, (SqlOperandTypeInference)new ReplaceUnknownOperandTypeInference(SqlTypeName.VARCHAR), null);
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between((int)2, (int)3);
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        int operandCount = callBinding.getOperandCount();
        assert (operandCount == 2 || operandCount == 3);
        SqlSingleOperandTypeChecker operandTypeChecker = operandCount == 2 ? OperandTypes.STRING_SAME_SAME : OperandTypes.STRING_SAME_SAME_SAME;
        if (!(operandTypeChecker = HazelcastOperandTypes.notAny((SqlOperandTypeChecker)operandTypeChecker)).checkOperandTypes(callBinding, throwOnFailure)) {
            return false;
        }
        return SqlTypeUtil.isCharTypeComparable((SqlCallBinding)callBinding, (List)callBinding.operands(), (boolean)throwOnFailure);
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList("", "");
        call.operand(0).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        writer.sep(this.getName());
        call.operand(1).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        if (call.operandCount() == 3) {
            writer.sep("ESCAPE");
            call.operand(2).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        }
        writer.endList(frame);
    }

    public SqlSpecialOperator.ReduceResult reduceExpr(int opOrdinal, SqlSpecialOperator.TokenSequence list) {
        int end;
        SqlNode[] operands;
        SqlOperator op2;
        SqlNode exp0 = list.node(opOrdinal - 1);
        SqlOperator op = list.op(opOrdinal);
        assert (op instanceof SqlLikeOperator);
        SqlNode exp1 = SqlParserUtil.toTreeEx((SqlSpecialOperator.TokenSequence)list, (int)(opOrdinal + 1), (int)this.getRightPrec(), (SqlKind)SqlKind.ESCAPE);
        SqlNode exp2 = null;
        if (opOrdinal + 2 < list.size() && list.isOp(opOrdinal + 2) && (op2 = list.op(opOrdinal + 2)).getKind() == SqlKind.ESCAPE) {
            exp2 = SqlParserUtil.toTreeEx((SqlSpecialOperator.TokenSequence)list, (int)(opOrdinal + 3), (int)this.getRightPrec(), (SqlKind)SqlKind.ESCAPE);
        }
        if (exp2 != null) {
            operands = new SqlNode[]{exp0, exp1, exp2};
            end = opOrdinal + 4;
        } else {
            operands = new SqlNode[]{exp0, exp1};
            end = opOrdinal + 2;
        }
        SqlCall call = this.createCall(SqlParserPos.ZERO, operands);
        return new SqlSpecialOperator.ReduceResult((SqlSpecialOperator)this, opOrdinal - 1, end, (SqlNode)call);
    }
}

