/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jclouds;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.jclouds.ComputeServiceBuilder;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;

public class JCloudsDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final ILogger LOGGER = Logger.getLogger(JCloudsDiscoveryStrategy.class);
    private final ComputeServiceBuilder computeServiceBuilder;
    private final Map<String, Object> memberMetaData = new HashMap<String, Object>();

    public JCloudsDiscoveryStrategy(Map<String, Comparable> properties) {
        super(LOGGER, properties);
        this.computeServiceBuilder = new ComputeServiceBuilder(properties);
    }

    protected JCloudsDiscoveryStrategy(ComputeServiceBuilder computeServiceBuilder) {
        super(LOGGER, new HashMap());
        this.computeServiceBuilder = computeServiceBuilder;
    }

    public void start() {
        this.computeServiceBuilder.build();
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        ArrayList<DiscoveryNode> discoveryNodes = new ArrayList<DiscoveryNode>();
        try {
            Iterable<? extends NodeMetadata> nodes = this.computeServiceBuilder.getFilteredNodes();
            for (NodeMetadata nodeMetadata : nodes) {
                if (nodeMetadata.getStatus() != NodeMetadata.Status.RUNNING) continue;
                discoveryNodes.add(this.buildDiscoveredNode(nodeMetadata));
            }
            if (discoveryNodes.isEmpty()) {
                LOGGER.warning("No running nodes discovered in configured cloud provider.");
            } else {
                StringBuilder sb = new StringBuilder("Discovered the following nodes with public IPS:\n");
                for (DiscoveryNode node : discoveryNodes) {
                    sb.append("    ").append(node.getPublicAddress().toString()).append("\n");
                }
                LOGGER.finest(sb.toString());
            }
        }
        catch (Exception e) {
            throw new HazelcastException("Failed to get registered addresses", (Throwable)e);
        }
        return discoveryNodes;
    }

    public void destroy() {
        this.computeServiceBuilder.destroy();
    }

    public Map<String, Object> discoverLocalMetadata() {
        if (this.memberMetaData.size() == 0) {
            this.discoverNodes();
        }
        return this.memberMetaData;
    }

    private DiscoveryNode buildDiscoveredNode(NodeMetadata metadata) {
        Address privateAddressInstance = null;
        if (!metadata.getPrivateAddresses().isEmpty()) {
            InetAddress privateAddress = this.mapAddress((String)metadata.getPrivateAddresses().iterator().next());
            privateAddressInstance = new Address(privateAddress, this.computeServiceBuilder.getServicePort());
            if (privateAddress.getHostAddress().equals(this.getLocalHostAddress())) {
                this.fetchMemberMetaData(metadata);
            }
        }
        Address publicAddressInstance = null;
        if (!metadata.getPublicAddresses().isEmpty()) {
            InetAddress publicAddress = this.mapAddress((String)metadata.getPublicAddresses().iterator().next());
            publicAddressInstance = new Address(publicAddress, this.computeServiceBuilder.getServicePort());
            if (publicAddress.getHostAddress().equals(this.getLocalHostAddress())) {
                this.fetchMemberMetaData(metadata);
            }
        }
        return new SimpleDiscoveryNode(privateAddressInstance, publicAddressInstance);
    }

    private InetAddress mapAddress(String address) {
        if (address == null) {
            return null;
        }
        try {
            return InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            throw new InvalidConfigurationException("Address '" + address + "' could not be resolved");
        }
    }

    private void fetchMemberMetaData(NodeMetadata metadata) {
        for (Location location = metadata.getLocation(); location != null; location = location.getParent()) {
            String id = location.getId();
            if (!location.getScope().equals((Object)LocationScope.ZONE) || id == null) continue;
            this.memberMetaData.put("hazelcast.partition.group.zone", id);
        }
        this.memberMetaData.put("hazelcast.partition.group.host", metadata.getHostname());
    }

    public String getLocalHostAddress() {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr.getHostAddress();
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress.getHostAddress();
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress.getHostAddress();
        }
        catch (Exception e) {
            LOGGER.warning("Failed to determine Host address: " + e);
            return null;
        }
    }
}

