/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jca;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jca.HazelcastTransaction;
import com.hazelcast.jca.HzConnectionEvent;
import com.hazelcast.jca.JcaBase;
import com.hazelcast.jca.ManagedConnectionFactoryImpl;
import com.hazelcast.jca.ManagedConnectionImpl;
import com.hazelcast.transaction.TransactionContext;
import java.util.logging.Level;
import javax.resource.ResourceException;

public class HazelcastTransactionImpl
extends JcaBase
implements HazelcastTransaction {
    private final ManagedConnectionFactoryImpl factory;
    private final ManagedConnectionImpl connection;
    private volatile TransactionContext txContext;

    HazelcastTransactionImpl(ManagedConnectionFactoryImpl factory, ManagedConnectionImpl connection) {
        this.factory = factory;
        this.connection = connection;
        this.setLogWriter(factory.getLogWriter());
    }

    private HazelcastInstance getHazelcastInstance() {
        return this.connection.getHazelcastInstance();
    }

    private void fireConnectionEvent(int event) {
        this.connection.fireConnectionEvent(event);
    }

    public void begin() throws ResourceException {
        if (null == this.txContext) {
            this.factory.logHzConnectionEvent(this, HzConnectionEvent.TX_START);
            this.txContext = this.getHazelcastInstance().newTransactionContext();
            this.log(Level.FINEST, "begin");
            this.txContext.beginTransaction();
            this.fireConnectionEvent(2);
        } else {
            this.log(Level.INFO, "Ignoring duplicate TX begin event");
        }
    }

    public void commit() throws ResourceException {
        this.factory.logHzConnectionEvent(this, HzConnectionEvent.TX_COMPLETE);
        this.log(Level.FINEST, "commit");
        if (this.txContext == null) {
            throw new ResourceException("Invalid transaction context; commit operation invoked without an active transaction context");
        }
        this.txContext.commitTransaction();
        this.fireConnectionEvent(3);
        this.txContext = null;
    }

    public void rollback() throws ResourceException {
        this.factory.logHzConnectionEvent(this, HzConnectionEvent.TX_COMPLETE);
        this.log(Level.FINEST, "rollback");
        if (this.txContext == null) {
            throw new ResourceException("Invalid transaction context; rollback operation invoked without an active transaction context");
        }
        this.txContext.rollbackTransaction();
        this.fireConnectionEvent(4);
        this.txContext = null;
    }

    @Override
    public void reset() {
        this.log(Level.WARNING, "reset");
        this.txContext = null;
    }

    public TransactionContext getTxContext() {
        return this.txContext;
    }
}

