/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jca;

import com.hazelcast.jca.ConnectionFactoryImpl;
import com.hazelcast.jca.HazelcastConnectionFactory;
import com.hazelcast.jca.HzConnectionEvent;
import com.hazelcast.jca.JcaBase;
import com.hazelcast.jca.ManagedConnectionImpl;
import com.hazelcast.jca.ResourceAdapterImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.security.auth.Subject;

public class ManagedConnectionFactoryImpl
extends JcaBase
implements ManagedConnectionFactory,
ResourceAdapterAssociation {
    private static final long serialVersionUID = -4889598421534961926L;
    private static final AtomicInteger idGen = new AtomicInteger();
    private final transient int id = idGen.incrementAndGet();
    private ResourceAdapterImpl resourceAdapter;
    private Set<HzConnectionEvent> hzConnectionTracingEvents;
    private boolean connectionTracingDetail;

    public HazelcastConnectionFactory createConnectionFactory() throws ResourceException {
        return this.createConnectionFactory(null);
    }

    public HazelcastConnectionFactory createConnectionFactory(ConnectionManager cm) throws ResourceException {
        this.log(Level.FINEST, "createConnectionFactory cm: " + cm);
        this.logHzConnectionEvent(this, HzConnectionEvent.FACTORY_INIT);
        return new ConnectionFactoryImpl(this, cm);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        this.log(Level.FINEST, "createManagedConnection");
        return new ManagedConnectionImpl(cxRequestInfo, this);
    }

    public String getConnectionTracingEvents() {
        return this.hzConnectionTracingEvents.toString();
    }

    public void setConnectionTracingDetail(boolean connectionTracingDetail) {
        this.connectionTracingDetail = connectionTracingDetail;
    }

    public boolean isConnectionTracingDetail() {
        return this.connectionTracingDetail;
    }

    public ResourceAdapterImpl getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) throws ResourceException {
        assert (resourceAdapter != null);
        if (!(resourceAdapter instanceof ResourceAdapterImpl)) {
            throw new ResourceException(resourceAdapter + " is not the expected ResoruceAdapterImpl but " + resourceAdapter.getClass());
        }
        this.resourceAdapter = (ResourceAdapterImpl)resourceAdapter;
    }

    void logHzConnectionEvent(Object eventSource, HzConnectionEvent event) {
        if (this.hzConnectionTracingEvents.contains((Object)event)) {
            StringBuilder sb = new StringBuilder("HZ Connection Event <<");
            sb.append((Object)event).append(">> for ").append(eventSource);
            sb.append(" in thread [").append(Thread.currentThread().getName());
            sb.append("]");
            if (this.isConnectionTracingDetail()) {
                this.log(Level.INFO, sb.toString());
            } else {
                this.log(Level.INFO, sb.toString(), new Exception("Hz Connection Event Call Stack"));
            }
        }
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        this.log(Level.FINEST, "matchManagedConnections");
        if (null != connectionSet && !connectionSet.isEmpty()) {
            for (Object con : connectionSet) {
                if (con instanceof ManagedConnectionImpl) {
                    ManagedConnectionImpl conn = (ManagedConnectionImpl)con;
                    ConnectionRequestInfo otherCxRequestInfo = conn.getCxRequestInfo();
                    if (null != otherCxRequestInfo && !otherCxRequestInfo.equals((Object)cxRequestInfo)) continue;
                    return conn;
                }
                this.log(Level.WARNING, "Unexpected element in list: " + con);
            }
        }
        return null;
    }

    public void setConnectionTracingEvents(String tracingSpec) {
        if (null != tracingSpec && 0 < tracingSpec.length()) {
            ArrayList<HzConnectionEvent> traceEvents = new ArrayList<HzConnectionEvent>();
            for (String traceEventId : tracingSpec.split(",")) {
                traceEventId = traceEventId.trim();
                try {
                    HzConnectionEvent traceEvent = HzConnectionEvent.valueOf(traceEventId);
                    if (null == traceEvent) continue;
                    traceEvents.add(traceEvent);
                }
                catch (IllegalArgumentException iae) {
                    this.log(Level.WARNING, "Ignoring illegal token \"" + traceEventId + "\" from connection config-property " + "connectionTracingEvents, valid tokens are " + EnumSet.allOf(HzConnectionEvent.class));
                }
            }
            this.hzConnectionTracingEvents = EnumSet.copyOf(traceEvents);
        } else {
            this.hzConnectionTracingEvents = Collections.emptySet();
        }
    }

    public String toString() {
        return "hazelcast.ManagedConnectionFactoryImpl [" + this.id + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ManagedConnectionFactoryImpl other = (ManagedConnectionFactoryImpl)obj;
        return this.id == other.id;
    }
}

