/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jca;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.TransactionalList;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.core.TransactionalMultiMap;
import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.core.TransactionalSet;
import com.hazelcast.jca.HazelcastConnection;
import com.hazelcast.jca.HazelcastTransaction;
import com.hazelcast.jca.ManagedConnectionImpl;
import com.hazelcast.transaction.TransactionContext;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.ResultSetInfo;
import javax.security.auth.Subject;

public class HazelcastConnectionImpl
implements HazelcastConnection {
    final ManagedConnectionImpl managedConnection;
    private static AtomicInteger idGen = new AtomicInteger();
    private final int id;

    public HazelcastConnectionImpl(ManagedConnectionImpl managedConnectionImpl, Subject subject) {
        this.managedConnection = managedConnectionImpl;
        this.id = idGen.incrementAndGet();
    }

    public void close() throws ResourceException {
        this.managedConnection.log(Level.FINEST, "close");
        this.managedConnection.fireConnectionEvent(1, this);
    }

    public Interaction createInteraction() throws ResourceException {
        return null;
    }

    public ResultSetInfo getResultSetInfo() throws NotSupportedException {
        throw new NotSupportedException();
    }

    public HazelcastTransaction getLocalTransaction() throws ResourceException {
        this.managedConnection.log(Level.FINEST, "getLocalTransaction");
        return this.managedConnection.getLocalTransaction();
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        return this.managedConnection.getMetaData();
    }

    public String toString() {
        return "hazelcast.ConnectionImpl [" + this.id + "]";
    }

    private HazelcastInstance getHazelcastInstance() {
        return this.managedConnection.getHazelcastInstance();
    }

    @Override
    public <K, V> IMap<K, V> getMap(String name) {
        return this.getHazelcastInstance().getMap(name);
    }

    @Override
    public <E> IQueue<E> getQueue(String name) {
        return this.getHazelcastInstance().getQueue(name);
    }

    @Override
    public <E> ITopic<E> getTopic(String name) {
        return this.getHazelcastInstance().getTopic(name);
    }

    @Override
    public <E> ISet<E> getSet(String name) {
        return this.getHazelcastInstance().getSet(name);
    }

    @Override
    public <E> IList<E> getList(String name) {
        return this.getHazelcastInstance().getList(name);
    }

    @Override
    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return this.getHazelcastInstance().getMultiMap(name);
    }

    @Override
    public ExecutorService getExecutorService(String name) {
        return this.getHazelcastInstance().getExecutorService(name);
    }

    @Override
    public IAtomicLong getAtomicLong(String name) {
        return this.getHazelcastInstance().getAtomicLong(name);
    }

    @Override
    public ICountDownLatch getCountDownLatch(String name) {
        return this.getHazelcastInstance().getCountDownLatch(name);
    }

    @Override
    public ISemaphore getSemaphore(String name) {
        return this.getHazelcastInstance().getSemaphore(name);
    }

    @Override
    public <K, V> TransactionalMap<K, V> getTransactionalMap(String name) {
        TransactionContext txContext = this.managedConnection.getTx().getTxContext();
        if (txContext == null) {
            throw new IllegalStateException("Transaction is not active");
        }
        return txContext.getMap(name);
    }

    @Override
    public <E> TransactionalQueue<E> getTransactionalQueue(String name) {
        TransactionContext txContext = this.managedConnection.getTx().getTxContext();
        if (txContext == null) {
            throw new IllegalStateException("Transaction is not active");
        }
        return txContext.getQueue(name);
    }

    @Override
    public <K, V> TransactionalMultiMap<K, V> getTransactionalMultiMap(String name) {
        TransactionContext txContext = this.managedConnection.getTx().getTxContext();
        if (txContext == null) {
            throw new IllegalStateException("Transaction is not active");
        }
        return txContext.getMultiMap(name);
    }

    @Override
    public <E> TransactionalList<E> getTransactionalList(String name) {
        TransactionContext txContext = this.managedConnection.getTx().getTxContext();
        if (txContext == null) {
            throw new IllegalStateException("Transaction is not active");
        }
        return txContext.getList(name);
    }

    @Override
    public <E> TransactionalSet<E> getTransactionalSet(String name) {
        TransactionContext txContext = this.managedConnection.getTx().getTxContext();
        if (txContext == null) {
            throw new IllegalStateException("Transaction is not active");
        }
        return txContext.getSet(name);
    }
}

