/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.protocol.generator;

import com.hazelcast.client.protocol.generator.CodecModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;

public final class CodeGenerationUtils {
    public static final int BYTE_BIT_COUNT = 8;
    public static final String CODEC_PACKAGE = "com.hazelcast.client.impl.protocol.codec.";
    public static final String DATA_FULL_NAME = "com.hazelcast.nio.serialization.Data";
    private static final Map<String, String> JAVA_TO_CSHARP_TYPES = new HashMap<String, String>(){
        {
            this.put(CodeGenerationUtils.DATA_FULL_NAME, "IData");
            this.put("java.lang.String", "string");
            this.put("java.lang.Integer", "int");
            this.put("boolean", "bool");
            this.put("java.util.List", "IList");
            this.put("java.util.Set", "ISet");
            this.put("java.util.Collection", "ICollection");
            this.put("java.util.Map", "IDictionary");
            this.put("java.util.Map.Entry", "KeyValuePair");
            this.put("com.hazelcast.nio.Address", "Address");
            this.put("com.hazelcast.client.impl.client.DistributedObjectInfo", "DistributedObjectInfo");
            this.put("com.hazelcast.core.Member", "Core.IMember");
            this.put("com.hazelcast.cluster.client.MemberAttributeChange", "Hazelcast.Client.Request.Cluster.MemberAttributeChange");
            this.put("com.hazelcast.map.impl.SimpleEntryView", "Hazelcast.Map.SimpleEntryView");
        }
    };

    private CodeGenerationUtils() {
    }

    public static String capitalizeFirstLetter(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public static String getPackageNameFromQualifiedName(String qualifiedClassName) {
        return qualifiedClassName.substring(0, qualifiedClassName.lastIndexOf("."));
    }

    public static String mergeIds(short classId, short methodId) {
        return Integer.toHexString((classId << 8) + methodId);
    }

    public static String addHexPrefix(String s) {
        return s.length() == 3 ? "0x0" + s : "0x" + s;
    }

    public static String getArrayType(String type) {
        int end = type.indexOf("[]");
        return type.substring(0, end).trim();
    }

    public static String getGenericType(String type) {
        int beg = type.indexOf("<");
        int end = type.lastIndexOf(">");
        return type.substring(beg + 1, end).trim();
    }

    public static String getSimpleType(String type) {
        int beg = type.indexOf("<");
        return type.substring(0, beg);
    }

    public static String getFirstGenericParameterType(String type) {
        int beg = type.indexOf("<");
        int end = type.lastIndexOf(",");
        return type.substring(beg + 1, end).trim();
    }

    public static String getSecondGenericParameterType(String type) {
        int beg = type.indexOf(",");
        int end = type.lastIndexOf(">");
        return type.substring(beg + 1, end).trim();
    }

    public static boolean isPrimitive(String type) {
        return type.equals("int") || type.equals("long") || type.equals("short") || type.equals("byte") || type.equals("boolean");
    }

    public static boolean isGeneric(String type) {
        return type.contains("<");
    }

    public static String getTypeCategory(String type) {
        String t;
        int endIndex = type.indexOf(60);
        String string = t = endIndex > 0 ? type.substring(0, endIndex) : type;
        if (CodecModel.CUSTOM_CODEC_MAP.containsKey(t)) {
            return "CUSTOM";
        }
        if (t.equals("java.util.Map")) {
            return "MAP";
        }
        if (t.equals("java.util.List") || t.equals("java.util.Set") || t.equals("java.util.Collection")) {
            return "COLLECTION";
        }
        if (type.endsWith("[]")) {
            return "ARRAY";
        }
        return "OTHER";
    }

    public static String getTypeCodec(String type) {
        int endIndex = type.indexOf(60);
        String t = endIndex > 0 ? type.substring(0, endIndex) : type;
        TypeElement typeElement = CodecModel.CUSTOM_CODEC_MAP.get(t);
        return typeElement != null ? typeElement.toString() : "";
    }

    public static String getConvertedType(String type) {
        if (type.startsWith("java.util.List<") || type.startsWith("java.util.Set<") || type.startsWith("java.util.Collection<")) {
            return type.replaceAll("java.util.*<(.*)>", "java.util.Collection<$1>");
        }
        return type;
    }

    public static String getDescription(String parameterName, String commentString) {
        int start;
        String result = "";
        if (null != parameterName && null != commentString && (start = commentString.indexOf("@param")) >= 0) {
            String[] paramStrings;
            String paramString = commentString.substring(start);
            for (String parameterString : paramStrings = paramString.split("@param")) {
                String trimmedParameterString = parameterString.trim();
                if (trimmedParameterString.length() <= parameterName.length() || !trimmedParameterString.startsWith(parameterName)) continue;
                result = trimmedParameterString.substring(parameterName.length());
                int endIndex = result.indexOf(64);
                if (endIndex >= 0) {
                    result = result.substring(0, endIndex);
                }
                result = result.replace("\n", "<br>");
                result = result.trim();
                break;
            }
        }
        return result;
    }

    public static String getReturnDescription(String commentString) {
        String result = "";
        String RETURN_TAG = "@return";
        int returnTagStartIndex = commentString.indexOf("@return");
        if (returnTagStartIndex >= 0) {
            int descriptionStartIndex = returnTagStartIndex + "@return".length();
            int nextTagIndex = commentString.indexOf("@", descriptionStartIndex);
            result = nextTagIndex >= 0 ? commentString.substring(descriptionStartIndex, nextTagIndex) : commentString.substring(descriptionStartIndex);
            result = result.trim();
            result = result.replace("\n", "<br>");
        }
        return result;
    }

    public static String getOperationDescription(String commentString) {
        String result = "";
        int nextTagIndex = commentString.indexOf("@");
        if (nextTagIndex >= 0) {
            result = commentString.substring(0, nextTagIndex);
            result = result.trim();
        }
        result = result.replace("\n", "<br>");
        return result;
    }

    public static String getDistributedObjectName(String templateClassName) {
        int endIndex;
        String result = templateClassName;
        int startIndex = templateClassName.lastIndexOf(46);
        if (startIndex >= 0 && (endIndex = templateClassName.indexOf("CodecTemplate", startIndex)) > startIndex) {
            result = templateClassName.substring(startIndex + 1, endIndex);
        }
        return result;
    }

    private static List<String> getGenericTypeParameters(String parameters) {
        ArrayList<String> paramList = new ArrayList<String>();
        int balanced = 0;
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < parameters.length(); ++i) {
            char c = parameters.charAt(i);
            if (balanced == 0 && c == ',') {
                paramList.add(current.toString().trim());
                current = new StringBuilder();
                continue;
            }
            if (c == '<') {
                ++balanced;
            } else if (c == '>') {
                --balanced;
            }
            current.append(c);
        }
        paramList.add(current.toString());
        return paramList;
    }

    public static String getCSharpType(String type) {
        if (CodeGenerationUtils.isGeneric(type = type.trim())) {
            String simpleType = CodeGenerationUtils.getCSharpType(CodeGenerationUtils.getSimpleType(type));
            String genericParameters = CodeGenerationUtils.getGenericType(type);
            List<String> typeParameters = CodeGenerationUtils.getGenericTypeParameters(genericParameters);
            StringBuilder builder = new StringBuilder();
            builder.append(simpleType).append('<');
            Iterator<String> iterator = typeParameters.iterator();
            while (iterator.hasNext()) {
                builder.append(CodeGenerationUtils.getCSharpType(iterator.next()));
                if (!iterator.hasNext()) continue;
                builder.append(',');
            }
            builder.append(">");
            return builder.toString();
        }
        String convertedType = JAVA_TO_CSHARP_TYPES.get(type);
        return convertedType == null ? type : convertedType;
    }
}

