/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.impl.listener.AbstractClientListenerService;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.OutboundFrame;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.util.Clock;
import com.hazelcast.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ClientConnection
implements Connection {
    @Probe
    private final int connectionId;
    private final ILogger logger;
    private final AtomicInteger pendingPacketCount = new AtomicInteger(0);
    private final Channel channel;
    private final ClientConnectionManagerImpl connectionManager;
    private final LifecycleService lifecycleService;
    private final HazelcastClientInstanceImpl client;
    private final long startTime = System.currentTimeMillis();
    private volatile Address remoteEndpoint;
    private volatile boolean isHeartBeating = true;
    private volatile long lastHeartbeatRequestedMillis;
    private volatile long lastHeartbeatReceivedMillis;
    private volatile boolean isAuthenticatedAsOwner;
    @Probe(level=ProbeLevel.DEBUG)
    private final AtomicLong closedTime = new AtomicLong();
    private volatile Throwable closeCause;
    private volatile String closeReason;
    private int connectedServerVersion = -1;
    private String connectedServerVersionString;

    public ClientConnection(HazelcastClientInstanceImpl client, int connectionId, Channel channel) throws IOException {
        this.client = client;
        this.connectionManager = (ClientConnectionManagerImpl)client.getConnectionManager();
        this.lifecycleService = client.getLifecycleService();
        this.channel = channel;
        channel.attributeMap().put(ClientConnection.class, this);
        this.connectionId = connectionId;
        this.logger = client.getLoggingService().getLogger(ClientConnection.class);
    }

    public ClientConnection(HazelcastClientInstanceImpl client, int connectionId) throws IOException {
        this.client = client;
        this.connectionManager = (ClientConnectionManagerImpl)client.getConnectionManager();
        this.lifecycleService = client.getLifecycleService();
        this.connectionId = connectionId;
        this.channel = null;
        this.logger = client.getLoggingService().getLogger(ClientConnection.class);
    }

    public void incrementPendingPacketCount() {
        this.pendingPacketCount.incrementAndGet();
    }

    public void decrementPendingPacketCount() {
        this.pendingPacketCount.decrementAndGet();
    }

    public int getPendingPacketCount() {
        return this.pendingPacketCount.get();
    }

    public boolean write(OutboundFrame frame) {
        if (this.channel.write(frame)) {
            return true;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Connection is closed, dropping frame -> " + frame);
        }
        return false;
    }

    public Address getEndPoint() {
        return this.remoteEndpoint;
    }

    public boolean isAlive() {
        return this.closedTime.get() == 0L;
    }

    public long lastReadTimeMillis() {
        return this.channel.lastReadTimeMillis();
    }

    public long lastWriteTimeMillis() {
        return this.channel.lastWriteTimeMillis();
    }

    public void setType(ConnectionType type) {
    }

    public ConnectionType getType() {
        return ConnectionType.JAVA_CLIENT;
    }

    public boolean isClient() {
        return true;
    }

    public InetAddress getInetAddress() {
        return this.channel.socket().getInetAddress();
    }

    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this.channel.getRemoteSocketAddress();
    }

    public int getPort() {
        return this.channel.socket().getPort();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setRemoteEndpoint(Address remoteEndpoint) {
        this.remoteEndpoint = remoteEndpoint;
    }

    public InetSocketAddress getLocalSocketAddress() {
        return (InetSocketAddress)this.channel.getLocalSocketAddress();
    }

    public void close(String reason, Throwable cause) {
        if (!this.closedTime.compareAndSet(0L, System.currentTimeMillis())) {
            return;
        }
        this.closeCause = cause;
        this.closeReason = reason;
        this.logClose();
        try {
            this.innerClose();
        }
        catch (Exception e) {
            this.logger.warning("Exception while closing connection" + e.getMessage());
        }
        this.connectionManager.onClose(this);
        this.client.getMetricsRegistry().discardMetrics(new Object[]{this});
    }

    private void logClose() {
        String message = this.toString() + " closed. Reason: ";
        message = this.closeReason != null ? message + this.closeReason : (this.closeCause != null ? message + this.closeCause.getClass().getName() + "[" + this.closeCause.getMessage() + "]" : message + "Socket explicitly closed");
        if (this.lifecycleService.isRunning()) {
            if (this.closeCause == null || this.closeCause instanceof EOFException || this.closeCause instanceof CancelledKeyException) {
                this.logger.info(message);
            } else {
                this.logger.warning(message, this.closeCause);
            }
        } else if (this.closeCause == null) {
            this.logger.finest(message);
        } else {
            this.logger.finest(message, this.closeCause);
        }
    }

    protected void innerClose() throws IOException {
        this.channel.close();
    }

    public Throwable getCloseCause() {
        return this.closeCause;
    }

    public String getCloseReason() {
        if (this.closeReason == null) {
            return this.closeCause == null ? null : this.closeCause.getMessage();
        }
        return this.closeReason;
    }

    public void handleClientMessage(ClientMessage message) {
        ClientInvocationService invocationService = this.client.getInvocationService();
        this.incrementPendingPacketCount();
        if (message.isFlagSet((short)1)) {
            AbstractClientListenerService listenerService = (AbstractClientListenerService)this.client.getListenerService();
            listenerService.handleClientMessage(message, this);
        } else {
            invocationService.handleClientMessage(message, this);
        }
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="incremented in single thread")
    void onHeartbeatFailed() {
        this.isHeartBeating = false;
    }

    void onHeartbeatResumed() {
        this.isHeartBeating = true;
    }

    void onHeartbeatReceived() {
        this.lastHeartbeatReceivedMillis = Clock.currentTimeMillis();
    }

    void onHeartbeatRequested() {
        this.lastHeartbeatRequestedMillis = Clock.currentTimeMillis();
    }

    public boolean isHeartBeating() {
        return this.isAlive() && this.isHeartBeating;
    }

    public boolean isAuthenticatedAsOwner() {
        return this.isAuthenticatedAsOwner;
    }

    public void setIsAuthenticatedAsOwner() {
        this.isAuthenticatedAsOwner = true;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientConnection)) {
            return false;
        }
        ClientConnection that = (ClientConnection)o;
        return this.connectionId == that.connectionId;
    }

    public int hashCode() {
        return this.connectionId;
    }

    public String toString() {
        return "ClientConnection{alive=" + this.isAlive() + ", connectionId=" + this.connectionId + ", channel=" + this.channel + ", remoteEndpoint=" + this.remoteEndpoint + ", lastReadTime=" + StringUtil.timeToStringFriendly((long)this.lastReadTimeMillis()) + ", lastWriteTime=" + StringUtil.timeToStringFriendly((long)this.lastWriteTimeMillis()) + ", closedTime=" + StringUtil.timeToStringFriendly((long)this.closedTime.get()) + ", lastHeartbeatRequested=" + StringUtil.timeToStringFriendly((long)this.lastHeartbeatRequestedMillis) + ", lastHeartbeatReceived=" + StringUtil.timeToStringFriendly((long)this.lastHeartbeatReceivedMillis) + ", connected server version=" + this.connectedServerVersionString + '}';
    }

    public long getClosedTime() {
        return this.closedTime.get();
    }

    public void setConnectedServerVersion(String connectedServerVersion) {
        this.connectedServerVersionString = connectedServerVersion;
        this.connectedServerVersion = BuildInfo.calculateVersion((String)connectedServerVersion);
    }

    public int getConnectedServerVersion() {
        return this.connectedServerVersion;
    }

    public String getConnectedServerVersionString() {
        return this.connectedServerVersionString;
    }
}

