/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheCreateConfigCodec;
import com.hazelcast.client.impl.protocol.codec.CacheGetConfigCodec;
import com.hazelcast.client.impl.protocol.codec.CacheManagementConfigCodec;
import com.hazelcast.client.spi.impl.AbstractClientInvocationService;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.LegacyCacheConfig;
import com.hazelcast.core.Member;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.FutureUtil;
import com.hazelcast.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

final class ClientCacheHelper {
    private ClientCacheHelper() {
    }

    static <K, V> CacheConfig<K, V> getCacheConfig(HazelcastClientInstanceImpl client, String cacheName, String simpleCacheName) {
        ClientMessage request = CacheGetConfigCodec.encodeRequest((String)cacheName, (String)simpleCacheName);
        try {
            int partitionId = client.getClientPartitionService().getPartitionId(cacheName);
            ClientInvocation clientInvocation = new ClientInvocation(client, request, cacheName, partitionId);
            ClientInvocationFuture future = clientInvocation.invoke();
            ClientMessage responseMessage = (ClientMessage)future.get();
            SerializationService serializationService = client.getSerializationService();
            return ClientCacheHelper.deserializeCacheConfig(client, responseMessage, serializationService, clientInvocation);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private static <K, V> CacheConfig<K, V> deserializeCacheConfig(HazelcastClientInstanceImpl client, ClientMessage responseMessage, SerializationService serializationService, ClientInvocation clientInvocation) {
        boolean compatibilityEnabled;
        Data responseData = CacheGetConfigCodec.decodeResponse((ClientMessage)responseMessage).response;
        ClientConnection sendConnection = clientInvocation.getSendConnection();
        if (null != sendConnection && -1 == sendConnection.getConnectedServerVersion() && (compatibilityEnabled = client.getProperties().getBoolean(ClientProperty.COMPATIBILITY_3_6_SERVER_ENABLED))) {
            LegacyCacheConfig legacyConfig = (LegacyCacheConfig)serializationService.toObject((Object)responseData, LegacyCacheConfig.class);
            if (null == legacyConfig) {
                return null;
            }
            return legacyConfig.getConfigAndReset();
        }
        return (CacheConfig)serializationService.toObject((Object)responseData);
    }

    static <K, V> CacheConfig<K, V> createCacheConfig(HazelcastClientInstanceImpl client, CacheConfig<K, V> existingConfig, CacheConfig<K, V> newCacheConfig, boolean createAlsoOnOthers, boolean syncCreate) {
        try {
            String nameWithPrefix = newCacheConfig.getNameWithPrefix();
            int partitionId = client.getClientPartitionService().getPartitionId(nameWithPrefix);
            Object resolvedConfig = ClientCacheHelper.resolveCacheConfigWithRetry(client, newCacheConfig, partitionId);
            Data configData = client.getSerializationService().toData(resolvedConfig);
            ClientMessage request = CacheCreateConfigCodec.encodeRequest((Data)configData, (boolean)createAlsoOnOthers);
            ClientInvocation clientInvocation = new ClientInvocation(client, request, nameWithPrefix, partitionId);
            ClientInvocationFuture future = clientInvocation.invoke();
            if (syncCreate) {
                ClientMessage response = (ClientMessage)future.get();
                Data data = CacheCreateConfigCodec.decodeResponse((ClientMessage)response).response;
                return ClientCacheHelper.resolveCacheConfig(client, clientInvocation, data);
            }
            return existingConfig;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private static <K, V> CacheConfig<K, V> resolveCacheConfig(HazelcastClientInstanceImpl client, ClientInvocation clientInvocation, Data configData) {
        boolean compatibilityEnabled;
        ClientConnection sendConnection = clientInvocation.getSendConnection();
        if (null != sendConnection && -1 == sendConnection.getConnectedServerVersion() && (compatibilityEnabled = client.getProperties().getBoolean(ClientProperty.COMPATIBILITY_3_6_SERVER_ENABLED))) {
            LegacyCacheConfig legacyConfig = (LegacyCacheConfig)client.getSerializationService().toObject((Object)configData, LegacyCacheConfig.class);
            if (null == legacyConfig) {
                return null;
            }
            return legacyConfig.getConfigAndReset();
        }
        return (CacheConfig)client.getSerializationService().toObject((Object)configData);
    }

    private static <K, V> Object resolveCacheConfig(HazelcastClientInstanceImpl client, CacheConfig<K, V> newCacheConfig, int partitionId) throws IOException {
        boolean compatibilityEnabled;
        Address address = ClientCacheHelper.getSendAddress(client, partitionId);
        ClientConnection sendConnection = (ClientConnection)client.getConnectionManager().getOrConnect(address);
        if (-1 == sendConnection.getConnectedServerVersion() && (compatibilityEnabled = client.getProperties().getBoolean(ClientProperty.COMPATIBILITY_3_6_SERVER_ENABLED))) {
            return new LegacyCacheConfig(newCacheConfig);
        }
        return newCacheConfig;
    }

    private static Address getSendAddress(HazelcastClientInstanceImpl client, int partitionId) throws IOException {
        Address address;
        if (client.getClientConfig().getNetworkConfig().isSmartRouting()) {
            address = client.getClientPartitionService().getPartitionOwner(partitionId);
            if (address == null) {
                throw new IOException("Partition does not have an owner. partitionId: " + partitionId);
            }
        } else {
            address = client.getConnectionManager().getOwnerConnectionAddress();
            if (address == null) {
                throw new IOException("NonSmartClientInvocationService: Owner connection is not available.");
            }
        }
        return address;
    }

    private static <K, V> Object resolveCacheConfigWithRetry(HazelcastClientInstanceImpl client, CacheConfig<K, V> newCacheConfig, int partitionId) {
        AbstractClientInvocationService invocationService = (AbstractClientInvocationService)client.getInvocationService();
        long invocationRetryPauseMillis = invocationService.getInvocationRetryPauseMillis();
        long invocationTimeoutMillis = invocationService.getInvocationTimeoutMillis();
        long startMillis = System.currentTimeMillis();
        while (true) {
            try {
                return ClientCacheHelper.resolveCacheConfig(client, newCacheConfig, partitionId);
            }
            catch (Exception e) {
                Exception lastException = e;
                ClientCacheHelper.timeOutOrSleepBeforeNextTry(startMillis, invocationRetryPauseMillis, invocationTimeoutMillis, lastException);
                if (client.getLifecycleService().isRunning()) continue;
                throw new HazelcastClientNotActiveException("Client is shut down");
            }
            break;
        }
    }

    private static void sleepBeforeNextTry(long invocationRetryPauseMillis) {
        try {
            Thread.sleep(invocationRetryPauseMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private static void timeOutOrSleepBeforeNextTry(long startMillis, long invocationRetryPauseMillis, long invocationTimeoutMillis, Exception lastException) {
        boolean timedOut;
        long nowInMillis = System.currentTimeMillis();
        long elapsedMillis = nowInMillis - startMillis;
        boolean bl = timedOut = elapsedMillis > invocationTimeoutMillis;
        if (timedOut) {
            ClientCacheHelper.throwOperationTimeoutException(startMillis, nowInMillis, elapsedMillis, invocationTimeoutMillis, lastException);
        } else {
            ClientCacheHelper.sleepBeforeNextTry(invocationRetryPauseMillis);
        }
    }

    private static void throwOperationTimeoutException(long startMillis, long nowInMillis, long elapsedMillis, long invocationTimeoutMillis, Exception lastException) {
        throw new OperationTimeoutException("Creating cache config is timed out. Current time: " + StringUtil.timeToString((long)nowInMillis) + ",  Start time : " + StringUtil.timeToString((long)startMillis) + ",  Client invocation timeout : " + invocationTimeoutMillis + " ms,  Elapsed time : " + elapsedMillis + " ms. ", (Throwable)lastException);
    }

    static void enableStatisticManagementOnNodes(HazelcastClientInstanceImpl client, String cacheName, boolean statOrMan, boolean enabled) {
        Collection<Member> members = client.getClientClusterService().getMemberList();
        ArrayList<ClientInvocationFuture> futures = new ArrayList<ClientInvocationFuture>();
        for (Member member : members) {
            try {
                Address address = member.getAddress();
                ClientMessage request = CacheManagementConfigCodec.encodeRequest((String)cacheName, (boolean)statOrMan, (boolean)enabled, (Address)address);
                ClientInvocation clientInvocation = new ClientInvocation(client, request, cacheName, address);
                ClientInvocationFuture future = clientInvocation.invoke();
                futures.add(future);
            }
            catch (Exception e) {
                ExceptionUtil.sneakyThrow((Throwable)e);
            }
        }
        FutureUtil.waitWithDeadline(futures, (long)60L, (TimeUnit)TimeUnit.SECONDS);
    }
}

