/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.discovery;

import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import com.hazelcast.util.Preconditions;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;

public class DiscoveryAddressProvider
implements AddressProvider {
    private final ILogger logger;
    private final DiscoveryService discoveryService;

    public DiscoveryAddressProvider(DiscoveryService discoveryService, LoggingService loggingService) {
        this.discoveryService = discoveryService;
        this.logger = loggingService.getLogger(DiscoveryAddressProvider.class);
    }

    @Override
    public Collection<InetSocketAddress> loadAddresses() {
        Iterable discoveredNodes = (Iterable)Preconditions.checkNotNull((Object)this.discoveryService.discoverNodes(), (String)"Discovered nodes cannot be null!");
        ArrayList<InetSocketAddress> possibleMembers = new ArrayList<InetSocketAddress>();
        for (DiscoveryNode discoveryNode : discoveredNodes) {
            Address discoveredAddress = discoveryNode.getPrivateAddress();
            try {
                possibleMembers.add(discoveredAddress.getInetSocketAddress());
            }
            catch (UnknownHostException e) {
                this.logger.warning("Unresolvable host exception", (Throwable)e);
            }
        }
        return possibleMembers;
    }
}

