/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.CallIdSequence;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ClientInvocationServiceSupport;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.HazelcastOverloadException;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class ClientInvocation
implements Runnable {
    public static final long RETRY_WAIT_TIME_IN_SECONDS = 1L;
    private static final int UNASSIGNED_PARTITION = -1;
    private final ClientInvocationFuture clientInvocationFuture;
    private final ILogger logger;
    private final LifecycleService lifecycleService;
    private final ClientClusterService clientClusterService;
    private final ClientInvocationServiceSupport invocationService;
    private final ClientExecutionService executionService;
    private final ClientMessage clientMessage;
    private final CallIdSequence callIdSequence;
    private final Address address;
    private final int partitionId;
    private final Connection connection;
    private volatile ClientConnection sendConnection;
    private boolean bypassHeartbeatCheck;
    private long retryExpirationMillis;
    private EventHandler handler;

    protected ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, int partitionId, Address address, Connection connection) {
        this.clientClusterService = client.getClientClusterService();
        this.lifecycleService = client.getLifecycleService();
        this.invocationService = (ClientInvocationServiceSupport)client.getInvocationService();
        this.executionService = client.getClientExecutionService();
        this.clientMessage = clientMessage;
        this.partitionId = partitionId;
        this.address = address;
        this.connection = connection;
        this.retryExpirationMillis = System.currentTimeMillis() + this.invocationService.getInvocationTimeoutMillis();
        this.logger = this.invocationService.invocationLogger;
        this.callIdSequence = client.getCallIdSequence();
        this.clientInvocationFuture = new ClientInvocationFuture(this, (Executor)((Object)this.executionService), clientMessage, this.logger, this.callIdSequence);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage) {
        this(client, clientMessage, -1, null, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, int partitionId) {
        this(client, clientMessage, partitionId, null, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, Address address) {
        this(client, clientMessage, -1, address, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, Connection connection) {
        this(client, clientMessage, -1, null, connection);
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public ClientMessage getClientMessage() {
        return this.clientMessage;
    }

    public ClientInvocationFuture invoke() {
        assert (this.clientMessage != null);
        this.clientMessage.setCorrelationId(this.callIdSequence.next());
        this.invokeOnSelection();
        return this.clientInvocationFuture;
    }

    public ClientInvocationFuture invokeUrgent() {
        assert (this.clientMessage != null);
        this.clientMessage.setCorrelationId(this.callIdSequence.forceNext());
        this.invokeOnSelection();
        return this.clientInvocationFuture;
    }

    private void invokeOnSelection() {
        try {
            if (this.isBindToSingleConnection()) {
                this.invocationService.invokeOnConnection(this, (ClientConnection)this.connection);
            } else if (this.partitionId != -1) {
                this.invocationService.invokeOnPartitionOwner(this, this.partitionId);
            } else if (this.address != null) {
                this.invocationService.invokeOnTarget(this, this.address);
            } else {
                this.invocationService.invokeOnRandomTarget(this);
            }
        }
        catch (Exception e) {
            if (e instanceof HazelcastOverloadException) {
                throw (HazelcastOverloadException)e;
            }
            this.notifyException(e);
        }
    }

    @Override
    public void run() {
        this.retry();
    }

    private void retry() {
        this.clientMessage.setCorrelationId(this.callIdSequence.forceNext());
        this.callIdSequence.complete();
        try {
            this.invokeOnSelection();
        }
        catch (Throwable e) {
            this.clientInvocationFuture.complete(e);
        }
    }

    public void notify(ClientMessage clientMessage) {
        if (clientMessage == null) {
            throw new IllegalArgumentException("response can't be null");
        }
        this.clientInvocationFuture.complete(clientMessage);
    }

    public void notifyException(Throwable exception) {
        boolean retry;
        if (!this.lifecycleService.isRunning()) {
            this.clientInvocationFuture.complete(new HazelcastClientNotActiveException(exception.getMessage(), exception));
            return;
        }
        if (this.isNotAllowedToRetryOnSelection(exception)) {
            this.clientInvocationFuture.complete(exception);
            return;
        }
        boolean bl = retry = ClientInvocation.isRetrySafeException(exception) || this.invocationService.isRedoOperation() || exception instanceof TargetDisconnectedException && this.clientMessage.isRetryable();
        if (!retry) {
            this.clientInvocationFuture.complete(exception);
            return;
        }
        long remainingMillis = this.retryExpirationMillis - System.currentTimeMillis();
        if (remainingMillis < 0L) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Exception will not be retried because invocation timed out", exception);
            }
            this.clientInvocationFuture.complete(new OperationTimeoutException(this + " timed out by " + Math.abs(remainingMillis) + " ms"));
            return;
        }
        try {
            this.executionService.schedule(this, 1L, TimeUnit.SECONDS);
        }
        catch (RejectedExecutionException e) {
            this.clientInvocationFuture.complete(exception);
        }
    }

    private boolean isNotAllowedToRetryOnSelection(Throwable exception) {
        if (this.isBindToSingleConnection() && exception instanceof IOException) {
            return true;
        }
        if (this.address != null && exception instanceof TargetNotMemberException && this.clientClusterService.getMember(this.address) == null) {
            this.clientInvocationFuture.complete(exception);
            return true;
        }
        return false;
    }

    private boolean isBindToSingleConnection() {
        return this.connection != null;
    }

    public EventHandler getEventHandler() {
        return this.handler;
    }

    public void setEventHandler(EventHandler handler) {
        this.handler = handler;
    }

    public boolean shouldBypassHeartbeatCheck() {
        return this.bypassHeartbeatCheck;
    }

    public void setBypassHeartbeatCheck(boolean bypassHeartbeatCheck) {
        this.bypassHeartbeatCheck = bypassHeartbeatCheck;
    }

    public void setSendConnection(ClientConnection connection) {
        this.sendConnection = connection;
    }

    public ClientConnection getSendConnectionOrWait() throws InterruptedException {
        while (this.sendConnection == null && !this.clientInvocationFuture.isDone()) {
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        return this.sendConnection;
    }

    public ClientConnection getSendConnection() {
        return this.sendConnection;
    }

    public static boolean isRetrySafeException(Throwable t) {
        return t instanceof IOException || t instanceof HazelcastInstanceNotActiveException || t instanceof RetryableException;
    }

    public Executor getUserExecutor() {
        return this.executionService.getUserExecutor();
    }

    public String toString() {
        String target = this.isBindToSingleConnection() ? "connection " + this.connection : (this.partitionId != -1 ? "partition " + this.partitionId : (this.address != null ? "address " + this.address : "random"));
        return "ClientInvocation{clientMessageType=" + this.clientMessage.getMessageType() + ", target=" + target + ", sendConnection=" + this.sendConnection + '}';
    }
}

