/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.cache.impl.nearcache.NearCacheManager;
import com.hazelcast.client.ClientExtension;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.impl.ClientConnectionManagerFactory;
import com.hazelcast.client.impl.ClientICacheManager;
import com.hazelcast.client.impl.ClientLockReferenceIdGenerator;
import com.hazelcast.client.impl.ClientLoggingService;
import com.hazelcast.client.impl.DefaultClientExtension;
import com.hazelcast.client.impl.LifecycleServiceImpl;
import com.hazelcast.client.impl.client.DistributedObjectInfo;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientGetDistributedObjectsCodec;
import com.hazelcast.client.proxy.ClientClusterProxy;
import com.hazelcast.client.proxy.PartitionServiceProxy;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ClientTransactionManagerService;
import com.hazelcast.client.spi.ProxyManager;
import com.hazelcast.client.spi.impl.AwsAddressProvider;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ClientNonSmartInvocationServiceImpl;
import com.hazelcast.client.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.client.spi.impl.ClientSmartInvocationServiceImpl;
import com.hazelcast.client.spi.impl.ClientTransactionManagerServiceImpl;
import com.hazelcast.client.spi.impl.DefaultAddressProvider;
import com.hazelcast.client.spi.impl.discovery.DiscoveryAddressProvider;
import com.hazelcast.client.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.spi.impl.listener.ClientNonSmartListenerService;
import com.hazelcast.client.spi.impl.listener.ClientSmartListenerService;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.Config;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.PartitionService;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.internal.diagnostics.ConfigPropertiesPlugin;
import com.hazelcast.internal.diagnostics.Diagnostics;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.internal.diagnostics.MetricsPlugin;
import com.hazelcast.internal.diagnostics.SystemLogPlugin;
import com.hazelcast.internal.diagnostics.SystemPropertiesPlugin;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.impl.MetricsRegistryImpl;
import com.hazelcast.internal.metrics.metricsets.ClassLoadingMetricSet;
import com.hazelcast.internal.metrics.metricsets.FileMetricSet;
import com.hazelcast.internal.metrics.metricsets.GarbageCollectionMetricSet;
import com.hazelcast.internal.metrics.metricsets.OperatingSystemMetricSet;
import com.hazelcast.internal.metrics.metricsets.RuntimeMetricSet;
import com.hazelcast.internal.metrics.metricsets.ThreadMetricSet;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.ConnectionListenable;
import com.hazelcast.quorum.QuorumService;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.spi.discovery.impl.DefaultDiscoveryServiceProvider;
import com.hazelcast.spi.discovery.integration.DiscoveryMode;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import com.hazelcast.spi.discovery.integration.DiscoveryServiceProvider;
import com.hazelcast.spi.discovery.integration.DiscoveryServiceSettings;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ServiceLoader;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class HazelcastClientInstanceImpl
implements HazelcastInstance,
SerializationServiceSupport {
    private static final AtomicInteger CLIENT_ID = new AtomicInteger();
    private static final short PROTOCOL_VERSION = 1;
    private final HazelcastProperties properties;
    private final int id = CLIENT_ID.getAndIncrement();
    private final String instanceName;
    private final ClientConfig config;
    private final ThreadGroup threadGroup;
    private final LifecycleServiceImpl lifecycleService;
    private final ClientConnectionManager connectionManager;
    private final ClientClusterServiceImpl clusterService;
    private final ClientPartitionServiceImpl partitionService;
    private final ClientInvocationService invocationService;
    private final ClientExecutionServiceImpl executionService;
    private final ClientListenerServiceImpl listenerService;
    private final ClientTransactionManagerService transactionManager;
    private final NearCacheManager nearCacheManager;
    private final ProxyManager proxyManager;
    private final ConcurrentMap<String, Object> userContext;
    private final LoadBalancer loadBalancer;
    private final ClientExtension clientExtension;
    private final Credentials credentials;
    private final DiscoveryService discoveryService;
    private final LoggingService loggingService;
    private final MetricsRegistryImpl metricsRegistry;
    private final Diagnostics diagnostics;
    private final SerializationService serializationService;
    private final ClientICacheManager hazelcastCacheManager;
    private final ClientLockReferenceIdGenerator lockReferenceIdGenerator;

    public HazelcastClientInstanceImpl(ClientConfig config, ClientConnectionManagerFactory clientConnectionManagerFactory, AddressProvider externalAddressProvider) {
        this.config = config;
        this.instanceName = config.getInstanceName() != null ? config.getInstanceName() : "hz.client_" + this.id;
        GroupConfig groupConfig = config.getGroupConfig();
        String loggingType = config.getProperty(GroupProperty.LOGGING_TYPE.getName());
        this.loggingService = new ClientLoggingService(groupConfig.getName(), loggingType, BuildInfoProvider.getBuildInfo(), this.instanceName);
        this.clientExtension = this.createClientInitializer(config.getClassLoader());
        this.clientExtension.beforeStart(this);
        this.credentials = this.initCredentials(config);
        this.threadGroup = new ThreadGroup(this.instanceName);
        this.lifecycleService = new LifecycleServiceImpl(this);
        this.properties = new HazelcastProperties(config.getProperties());
        this.metricsRegistry = this.initMetricsRegistry();
        this.serializationService = this.clientExtension.createSerializationService((byte)-1);
        this.proxyManager = new ProxyManager(this);
        this.executionService = this.initExecutionService();
        this.loadBalancer = this.initLoadBalancer(config);
        this.transactionManager = new ClientTransactionManagerServiceImpl(this, this.loadBalancer);
        this.partitionService = new ClientPartitionServiceImpl(this);
        this.discoveryService = this.initDiscoveryService(config);
        this.connectionManager = clientConnectionManagerFactory.createConnectionManager(config, this, this.discoveryService);
        Collection<AddressProvider> addressProviders = this.createAddressProviders(externalAddressProvider);
        this.clusterService = new ClientClusterServiceImpl(this, addressProviders);
        this.invocationService = this.initInvocationService();
        this.listenerService = this.initListenerService();
        this.userContext = new ConcurrentHashMap<String, Object>();
        this.nearCacheManager = this.clientExtension.createNearCacheManager();
        this.diagnostics = this.initDiagnostics(config);
        this.proxyManager.init(config);
        this.hazelcastCacheManager = new ClientICacheManager(this);
        this.lockReferenceIdGenerator = new ClientLockReferenceIdGenerator();
    }

    private Diagnostics initDiagnostics(ClientConfig config) {
        String name = "diagnostics-client-" + this.id + "-" + System.currentTimeMillis();
        ILogger logger = this.loggingService.getLogger(Diagnostics.class);
        HazelcastThreadGroup hzThreadGroup = new HazelcastThreadGroup(this.getName(), logger, config.getClassLoader());
        return new Diagnostics(name, logger, hzThreadGroup, this.properties);
    }

    private MetricsRegistryImpl initMetricsRegistry() {
        ProbeLevel probeLevel = (ProbeLevel)this.properties.getEnum(Diagnostics.METRICS_LEVEL, ProbeLevel.class);
        ILogger logger = this.loggingService.getLogger(MetricsRegistryImpl.class);
        MetricsRegistryImpl metricsRegistry = new MetricsRegistryImpl(logger, probeLevel);
        RuntimeMetricSet.register((MetricsRegistry)metricsRegistry);
        GarbageCollectionMetricSet.register((MetricsRegistry)metricsRegistry);
        OperatingSystemMetricSet.register((MetricsRegistry)metricsRegistry);
        ThreadMetricSet.register((MetricsRegistry)metricsRegistry);
        ClassLoadingMetricSet.register((MetricsRegistry)metricsRegistry);
        FileMetricSet.register((MetricsRegistry)metricsRegistry);
        return metricsRegistry;
    }

    private Collection<AddressProvider> createAddressProviders(AddressProvider externalAddressProvider) {
        ClientNetworkConfig networkConfig = this.getClientConfig().getNetworkConfig();
        ClientAwsConfig awsConfig = networkConfig.getAwsConfig();
        LinkedList<AddressProvider> addressProviders = new LinkedList<AddressProvider>();
        addressProviders.add(new DefaultAddressProvider(networkConfig));
        if (externalAddressProvider != null) {
            addressProviders.add(externalAddressProvider);
        }
        if (this.discoveryService != null) {
            addressProviders.add(new DiscoveryAddressProvider(this.discoveryService, this.loggingService));
        }
        if (this.properties.getBoolean(ClientProperty.DISCOVERY_SPI_ENABLED)) {
            this.discoveryService.start();
        }
        if (awsConfig != null && awsConfig.isEnabled()) {
            try {
                addressProviders.add(new AwsAddressProvider(awsConfig, this.loggingService));
            }
            catch (NoClassDefFoundError e) {
                ILogger logger = this.loggingService.getLogger(HazelcastClient.class);
                logger.log(Level.WARNING, "hazelcast-cloud.jar might be missing!");
                throw e;
            }
        }
        return addressProviders;
    }

    private DiscoveryService initDiscoveryService(ClientConfig config) {
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        DiscoveryConfig discoveryConfig = networkConfig.getDiscoveryConfig().getAsReadOnly();
        if (discoveryConfig == null || !discoveryConfig.isEnabled()) {
            return null;
        }
        DiscoveryServiceProvider factory = discoveryConfig.getDiscoveryServiceProvider();
        if (factory == null) {
            factory = new DefaultDiscoveryServiceProvider();
        }
        ILogger logger = this.loggingService.getLogger(DiscoveryService.class);
        DiscoveryServiceSettings settings = new DiscoveryServiceSettings().setConfigClassLoader(config.getClassLoader()).setLogger(logger).setDiscoveryMode(DiscoveryMode.Client).setDiscoveryConfig(discoveryConfig);
        return factory.newDiscoveryService(settings);
    }

    private LoadBalancer initLoadBalancer(ClientConfig config) {
        LoadBalancer lb = config.getLoadBalancer();
        if (lb == null) {
            lb = new RoundRobinLB();
        }
        return lb;
    }

    private Credentials initCredentials(ClientConfig config) {
        String credentialsClassname;
        GroupConfig groupConfig = config.getGroupConfig();
        ClientSecurityConfig securityConfig = config.getSecurityConfig();
        Credentials c = securityConfig.getCredentials();
        if (c == null && (credentialsClassname = securityConfig.getCredentialsClassname()) != null) {
            try {
                c = (Credentials)ClassLoaderUtil.newInstance((ClassLoader)config.getClassLoader(), (String)credentialsClassname);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
        if (c == null) {
            c = new UsernamePasswordCredentials(groupConfig.getName(), groupConfig.getPassword());
        }
        return c;
    }

    private ClientInvocationService initInvocationService() {
        ClientNetworkConfig networkConfig = this.config.getNetworkConfig();
        if (networkConfig.isSmartRouting()) {
            return new ClientSmartInvocationServiceImpl(this, this.loadBalancer);
        }
        return new ClientNonSmartInvocationServiceImpl(this);
    }

    public int getId() {
        return this.id;
    }

    private ClientExtension createClientInitializer(ClassLoader classLoader) {
        try {
            String factoryId = ClientExtension.class.getName();
            Iterator iter = ServiceLoader.iterator(ClientExtension.class, (String)factoryId, (ClassLoader)classLoader);
            while (iter.hasNext()) {
                ClientExtension initializer = (ClientExtension)iter.next();
                if (initializer.getClass().equals(DefaultClientExtension.class)) continue;
                return initializer;
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return new DefaultClientExtension();
    }

    private ClientListenerServiceImpl initListenerService() {
        int eventQueueCapacity = this.properties.getInteger(ClientProperty.EVENT_QUEUE_CAPACITY);
        int eventThreadCount = this.properties.getInteger(ClientProperty.EVENT_THREAD_COUNT);
        ClientNetworkConfig networkConfig = this.config.getNetworkConfig();
        if (networkConfig.isSmartRouting()) {
            return new ClientSmartListenerService(this, eventThreadCount, eventQueueCapacity);
        }
        return new ClientNonSmartListenerService(this, eventThreadCount, eventQueueCapacity);
    }

    private ClientExecutionServiceImpl initExecutionService() {
        return new ClientExecutionServiceImpl(this.instanceName, this.threadGroup, this.config.getClassLoader(), this.properties, this.config.getExecutorPoolSize(), this.loggingService);
    }

    public void start() {
        this.lifecycleService.setStarted();
        this.invocationService.start();
        this.connectionManager.start();
        try {
            this.clusterService.start();
        }
        catch (Exception e) {
            this.lifecycleService.shutdown();
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        this.listenerService.start();
        this.loadBalancer.init(this.getCluster(), this.config);
        this.partitionService.start();
        this.clientExtension.afterStart(this);
        this.diagnostics.start();
        this.diagnostics.register((DiagnosticsPlugin)new ConfigPropertiesPlugin(this.loggingService.getLogger(ConfigPropertiesPlugin.class), this.properties));
        this.diagnostics.register((DiagnosticsPlugin)new SystemPropertiesPlugin(this.loggingService.getLogger(SystemPropertiesPlugin.class)));
        this.diagnostics.register((DiagnosticsPlugin)new MetricsPlugin(this.loggingService.getLogger(MetricsPlugin.class), (MetricsRegistry)this.metricsRegistry, this.properties));
        this.diagnostics.register((DiagnosticsPlugin)new SystemLogPlugin(this.properties, (ConnectionListenable)this.connectionManager, (HazelcastInstance)this, this.loggingService.getLogger(SystemLogPlugin.class)));
    }

    public MetricsRegistryImpl getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public HazelcastXAResource getXAResource() {
        return (HazelcastXAResource)this.getDistributedObject("hz:impl:xaService", "hz:impl:xaService");
    }

    public Config getConfig() {
        throw new UnsupportedOperationException("Client cannot access cluster config!");
    }

    public HazelcastProperties getProperties() {
        return this.properties;
    }

    public String getName() {
        return this.instanceName;
    }

    public <E> IQueue<E> getQueue(String name) {
        return (IQueue)this.getDistributedObject("hz:impl:queueService", name);
    }

    public <E> ITopic<E> getTopic(String name) {
        return (ITopic)this.getDistributedObject("hz:impl:topicService", name);
    }

    public <E> ISet<E> getSet(String name) {
        return (ISet)this.getDistributedObject("hz:impl:setService", name);
    }

    public <E> IList<E> getList(String name) {
        return (IList)this.getDistributedObject("hz:impl:listService", name);
    }

    public <K, V> IMap<K, V> getMap(String name) {
        return (IMap)this.getDistributedObject("hz:impl:mapService", name);
    }

    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return (MultiMap)this.getDistributedObject("hz:impl:multiMapService", name);
    }

    public <K, V> ReplicatedMap<K, V> getReplicatedMap(String name) {
        return (ReplicatedMap)this.getDistributedObject("hz:impl:replicatedMapService", name);
    }

    public JobTracker getJobTracker(String name) {
        return (JobTracker)this.getDistributedObject("hz:impl:mapReduceService", name);
    }

    public ILock getLock(String key) {
        return (ILock)this.getDistributedObject("hz:impl:lockService", key);
    }

    public <E> ITopic<E> getReliableTopic(String name) {
        return (ITopic)this.getDistributedObject("hz:impl:reliableTopicService", name);
    }

    public <E> Ringbuffer<E> getRingbuffer(String name) {
        return (Ringbuffer)this.getDistributedObject("hz:impl:ringbufferService", name);
    }

    public ClientICacheManager getCacheManager() {
        return this.hazelcastCacheManager;
    }

    public Cluster getCluster() {
        return new ClientClusterProxy(this.clusterService);
    }

    public Client getLocalEndpoint() {
        return this.clusterService.getLocalClient();
    }

    public IExecutorService getExecutorService(String name) {
        return (IExecutorService)this.getDistributedObject("hz:impl:executorService", name);
    }

    public DurableExecutorService getDurableExecutorService(String name) {
        return (DurableExecutorService)this.getDistributedObject("hz:impl:durableExecutorService", name);
    }

    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.transactionManager.executeTransaction(task);
    }

    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        return this.transactionManager.executeTransaction(options, task);
    }

    public TransactionContext newTransactionContext() {
        return this.transactionManager.newTransactionContext();
    }

    public TransactionContext newTransactionContext(TransactionOptions options) {
        return this.transactionManager.newTransactionContext(options);
    }

    public ClientTransactionManagerService getTransactionManager() {
        return this.transactionManager;
    }

    public IdGenerator getIdGenerator(String name) {
        return (IdGenerator)this.getDistributedObject("hz:impl:idGeneratorService", name);
    }

    public IAtomicLong getAtomicLong(String name) {
        return (IAtomicLong)this.getDistributedObject("hz:impl:atomicLongService", name);
    }

    public <E> IAtomicReference<E> getAtomicReference(String name) {
        return (IAtomicReference)this.getDistributedObject("hz:impl:atomicReferenceService", name);
    }

    public ICountDownLatch getCountDownLatch(String name) {
        return (ICountDownLatch)this.getDistributedObject("hz:impl:countDownLatchService", name);
    }

    public ISemaphore getSemaphore(String name) {
        return (ISemaphore)this.getDistributedObject("hz:impl:semaphoreService", name);
    }

    public Collection<DistributedObject> getDistributedObjects() {
        try {
            ClientMessage request = ClientGetDistributedObjectsCodec.encodeRequest();
            ClientInvocationFuture future = new ClientInvocation(this, request).invoke();
            ClientMessage response = (ClientMessage)future.get();
            ClientGetDistributedObjectsCodec.ResponseParameters resultParameters = ClientGetDistributedObjectsCodec.decodeResponse((ClientMessage)response);
            List infoCollection = resultParameters.response;
            for (DistributedObjectInfo distributedObjectInfo : infoCollection) {
                this.getDistributedObject(distributedObjectInfo.getServiceName(), distributedObjectInfo.getName());
            }
            return this.proxyManager.getDistributedObjects();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public String addDistributedObjectListener(DistributedObjectListener distributedObjectListener) {
        return this.proxyManager.addDistributedObjectListener(distributedObjectListener);
    }

    public boolean removeDistributedObjectListener(String registrationId) {
        return this.proxyManager.removeDistributedObjectListener(registrationId);
    }

    public PartitionService getPartitionService() {
        return new PartitionServiceProxy(this.partitionService, this.listenerService);
    }

    public QuorumService getQuorumService() {
        throw new UnsupportedOperationException();
    }

    public ClientService getClientService() {
        throw new UnsupportedOperationException();
    }

    public LoggingService getLoggingService() {
        return this.loggingService;
    }

    public LifecycleService getLifecycleService() {
        return this.lifecycleService;
    }

    public <T extends DistributedObject> T getDistributedObject(String serviceName, String name) {
        return (T)this.proxyManager.getOrCreateProxy(serviceName, name);
    }

    public ConcurrentMap<String, Object> getUserContext() {
        return this.userContext;
    }

    public ClientConfig getClientConfig() {
        return this.config;
    }

    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    public ProxyManager getProxyManager() {
        return this.proxyManager;
    }

    public ClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ClientClusterService getClientClusterService() {
        return this.clusterService;
    }

    public ClientExecutionService getClientExecutionService() {
        return this.executionService;
    }

    public ClientPartitionService getClientPartitionService() {
        return this.partitionService;
    }

    public ClientInvocationService getInvocationService() {
        return this.invocationService;
    }

    public ClientListenerService getListenerService() {
        return this.listenerService;
    }

    public NearCacheManager getNearCacheManager() {
        return this.nearCacheManager;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public ClientExtension getClientExtension() {
        return this.clientExtension;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public short getProtocolVersion() {
        return 1;
    }

    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    public void doShutdown() {
        this.proxyManager.destroy();
        this.connectionManager.shutdown();
        this.clusterService.shutdown();
        this.executionService.shutdown();
        this.partitionService.stop();
        this.transactionManager.shutdown();
        this.invocationService.shutdown();
        this.listenerService.shutdown();
        ((InternalSerializationService)this.serializationService).dispose();
        this.nearCacheManager.destroyAllNearCaches();
        if (this.discoveryService != null) {
            this.discoveryService.destroy();
        }
        this.metricsRegistry.shutdown();
        this.diagnostics.shutdown();
    }

    public ClientLockReferenceIdGenerator getLockReferenceIdGenerator() {
        return this.lockReferenceIdGenerator;
    }
}

