/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.nio.AbstractClientSelectionHandler;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ClientMessageBuilder;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.tcp.nonblocking.NonBlockingIOThread;
import com.hazelcast.util.Clock;
import java.io.EOFException;
import java.nio.ByteBuffer;

public class ClientReadHandler
extends AbstractClientSelectionHandler {
    private final ByteBuffer buffer;
    private final ClientMessageBuilder builder;
    @Probe(name="messagesRead")
    private final SwCounter messagesRead = SwCounter.newSwCounter();
    @Probe(name="bytesRead")
    private final SwCounter bytesRead = SwCounter.newSwCounter();
    private volatile long lastHandle;

    public ClientReadHandler(final ClientConnection connection, NonBlockingIOThread ioThread, int bufferSize, boolean direct, LoggingService loggingService) {
        super(connection, ioThread, loggingService);
        this.buffer = IOUtil.newByteBuffer((int)bufferSize, (boolean)direct);
        this.lastHandle = Clock.currentTimeMillis();
        this.builder = new ClientMessageBuilder(new ClientMessageBuilder.MessageHandler(){

            public void handleMessage(ClientMessage message) {
                ClientReadHandler.this.connectionManager.handleClientMessage(message, connection);
            }
        });
    }

    @Probe(name="idleTimeMs", level=ProbeLevel.DEBUG)
    private long idleTimeMs() {
        return Math.max(System.currentTimeMillis() - this.lastHandle, 0L);
    }

    @Override
    public void run() {
        this.registerOp(1);
    }

    public void handle() throws Exception {
        this.eventCount.inc();
        this.lastHandle = Clock.currentTimeMillis();
        int readBytes = this.socketChannel.read(this.buffer);
        if (readBytes <= 0) {
            if (readBytes == -1) {
                throw new EOFException("Remote socket closed!");
            }
            return;
        }
        this.bytesRead.inc((long)readBytes);
        this.buffer.flip();
        this.messagesRead.inc((long)this.builder.onData(this.buffer));
        if (this.buffer.hasRemaining()) {
            this.buffer.compact();
        } else {
            this.buffer.clear();
        }
    }

    long getLastHandle() {
        return this.lastHandle;
    }
}

