/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapFetchEntriesCodec;
import com.hazelcast.client.impl.protocol.codec.MapFetchKeysCodec;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.map.impl.iterator.AbstractMapPartitionIterator;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import java.util.List;

public class ClientMapPartitionIterator<K, V>
extends AbstractMapPartitionIterator<K, V> {
    private final ClientMapProxy<K, V> mapProxy;
    private final ClientContext context;

    public ClientMapPartitionIterator(ClientMapProxy<K, V> mapProxy, ClientContext context, int fetchSize, int partitionId, boolean prefetchValues) {
        super(mapProxy, fetchSize, partitionId, prefetchValues);
        this.mapProxy = mapProxy;
        this.context = context;
    }

    protected List fetch() {
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.context.getHazelcastInstance();
        if (this.prefetchValues) {
            return this.fetchWithPrefetchValues(client);
        }
        return this.fetchWithoutPrefetchValues(client);
    }

    private List fetchWithoutPrefetchValues(HazelcastClientInstanceImpl client) {
        ClientMessage request = MapFetchKeysCodec.encodeRequest((String)this.mapProxy.getName(), (int)this.partitionId, (int)this.lastTableIndex, (int)this.fetchSize);
        ClientInvocation clientInvocation = new ClientInvocation(client, request, this.partitionId);
        try {
            ClientInvocationFuture f = clientInvocation.invoke();
            MapFetchKeysCodec.ResponseParameters responseParameters = MapFetchKeysCodec.decodeResponse((ClientMessage)((ClientMessage)f.get()));
            this.setLastTableIndex(responseParameters.keys, responseParameters.tableIndex);
            return responseParameters.keys;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private List fetchWithPrefetchValues(HazelcastClientInstanceImpl client) {
        ClientMessage request = MapFetchEntriesCodec.encodeRequest((String)this.mapProxy.getName(), (int)this.partitionId, (int)this.lastTableIndex, (int)this.fetchSize);
        ClientInvocation clientInvocation = new ClientInvocation(client, request, this.partitionId);
        try {
            ClientInvocationFuture f = clientInvocation.invoke();
            MapFetchEntriesCodec.ResponseParameters responseParameters = MapFetchEntriesCodec.decodeResponse((ClientMessage)((ClientMessage)f.get()));
            this.setLastTableIndex(responseParameters.entries, responseParameters.tableIndex);
            return responseParameters.entries;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected SerializationService getSerializationService() {
        return this.context.getSerializationService();
    }
}

