/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.nio.AbstractClientSelectionHandler;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.OutboundFrame;
import com.hazelcast.nio.tcp.nonblocking.NonBlockingIOThread;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClientWriteHandler
extends AbstractClientSelectionHandler
implements Runnable {
    @Probe(name="writeQueueSize")
    private final Queue<ClientMessage> writeQueue = new ConcurrentLinkedQueue<ClientMessage>();
    @Probe(name="bytesWritten")
    private final SwCounter bytesWritten = SwCounter.newSwCounter();
    @Probe(name="messagesWritten")
    private final SwCounter messagesWritten = SwCounter.newSwCounter();
    private final AtomicBoolean informSelector = new AtomicBoolean(true);
    private final ByteBuffer buffer;
    private boolean ready;
    private ClientMessage lastMessage;
    private volatile long lastHandle;

    public ClientWriteHandler(ClientConnection connection, NonBlockingIOThread ioThread, int bufferSize, boolean direct, LoggingService loggingService) {
        super(connection, ioThread, loggingService);
        this.buffer = IOUtil.newByteBuffer((int)bufferSize, (boolean)direct);
    }

    @Probe(name="idleTimeMs", level=ProbeLevel.DEBUG)
    private long idleTimeMs() {
        return Math.max(System.currentTimeMillis() - this.lastHandle, 0L);
    }

    @Probe(name="isScheduled", level=ProbeLevel.DEBUG)
    private long isScheduled() {
        return this.informSelector.get() ? 0L : 1L;
    }

    public void handle() throws Exception {
        this.eventCount.inc();
        this.lastHandle = Clock.currentTimeMillis();
        if (!this.connection.isAlive()) {
            return;
        }
        if (this.lastMessage == null) {
            this.lastMessage = this.poll();
        }
        if (this.lastMessage == null && this.buffer.position() == 0) {
            this.ready = true;
            return;
        }
        this.writeBuffer();
        this.ready = false;
        this.registerWrite();
    }

    private void writeBuffer() throws IOException {
        boolean complete;
        while (this.buffer.hasRemaining() && this.lastMessage != null && (complete = this.lastMessage.writeTo(this.buffer))) {
            this.lastMessage = this.poll();
        }
        if (this.buffer.position() == 0) {
            return;
        }
        this.buffer.flip();
        this.bytesWritten.inc((long)this.socketChannel.write(this.buffer));
        if (this.buffer.hasRemaining()) {
            this.buffer.compact();
        } else {
            this.buffer.clear();
        }
    }

    public void enqueue(OutboundFrame frame) {
        this.writeQueue.offer((ClientMessage)frame);
        if (this.informSelector.compareAndSet(true, false)) {
            this.register();
        }
    }

    private ClientMessage poll() {
        ClientMessage message = this.writeQueue.poll();
        if (message != null) {
            this.messagesWritten.inc();
        }
        return message;
    }

    @Override
    public void run() {
        try {
            this.informSelector.set(true);
            if (this.ready) {
                this.handle();
            } else {
                this.registerWrite();
            }
            this.ready = false;
        }
        catch (Throwable t) {
            this.onFailure(t);
        }
    }

    private void registerWrite() {
        this.registerOp(4);
    }

    @Override
    public void shutdown() {
        this.writeQueue.clear();
    }

    long getLastHandle() {
        return this.lastHandle;
    }
}

