/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceAlterAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceAlterCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceApplyCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceClearCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceCompareAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceContainsCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceGetAndAlterCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceGetAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceIsNullCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceSetAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceSetCodec;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.IFunction;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Preconditions;

public class ClientAtomicReferenceProxy<E>
extends PartitionSpecificClientProxy
implements IAtomicReference<E> {
    public ClientAtomicReferenceProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
    }

    public <R> R apply(IFunction<E, R> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicReferenceApplyCodec.encodeRequest((String)this.name, (Data)this.toData(function));
        ClientMessage response = this.invokeOnPartition(request);
        AtomicReferenceApplyCodec.ResponseParameters resultParameters = AtomicReferenceApplyCodec.decodeResponse((ClientMessage)response);
        return (R)this.toObject(resultParameters.response);
    }

    public void alter(IFunction<E, E> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicReferenceAlterCodec.encodeRequest((String)this.name, (Data)this.toData(function));
        this.invokeOnPartition(request);
    }

    public E alterAndGet(IFunction<E, E> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicReferenceAlterAndGetCodec.encodeRequest((String)this.name, (Data)this.toData(function));
        ClientMessage response = this.invokeOnPartition(request);
        return (E)this.toObject(AtomicReferenceAlterAndGetCodec.decodeResponse((ClientMessage)response).response);
    }

    public E getAndAlter(IFunction<E, E> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicReferenceGetAndAlterCodec.encodeRequest((String)this.name, (Data)this.toData(function));
        ClientMessage response = this.invokeOnPartition(request);
        return (E)this.toObject(AtomicReferenceGetAndAlterCodec.decodeResponse((ClientMessage)response).response);
    }

    public boolean compareAndSet(E expect, E update) {
        ClientMessage request = AtomicReferenceCompareAndSetCodec.encodeRequest((String)this.name, (Data)this.toData(expect), (Data)this.toData(update));
        ClientMessage response = this.invokeOnPartition(request);
        return AtomicReferenceCompareAndSetCodec.decodeResponse((ClientMessage)response).response;
    }

    public boolean contains(E expected) {
        ClientMessage request = AtomicReferenceContainsCodec.encodeRequest((String)this.name, (Data)this.toData(expected));
        ClientMessage response = this.invokeOnPartition(request);
        return AtomicReferenceContainsCodec.decodeResponse((ClientMessage)response).response;
    }

    public E get() {
        ClientMessage request = AtomicReferenceGetCodec.encodeRequest((String)this.name);
        ClientMessage response = this.invokeOnPartition(request);
        return (E)this.toObject(AtomicReferenceGetCodec.decodeResponse((ClientMessage)response).response);
    }

    public void set(E newValue) {
        ClientMessage request = AtomicReferenceSetCodec.encodeRequest((String)this.name, (Data)this.toData(newValue));
        this.invokeOnPartition(request);
    }

    public void clear() {
        ClientMessage request = AtomicReferenceClearCodec.encodeRequest((String)this.name);
        this.invokeOnPartition(request);
    }

    public E getAndSet(E newValue) {
        ClientMessage request = AtomicReferenceGetAndSetCodec.encodeRequest((String)this.name, (Data)this.toData(newValue));
        ClientMessage response = this.invokeOnPartition(request);
        return (E)this.toObject(AtomicReferenceGetAndSetCodec.decodeResponse((ClientMessage)response).response);
    }

    public E setAndGet(E update) {
        ClientMessage request = AtomicReferenceSetAndGetCodec.encodeRequest((String)this.name, (Data)this.toData(update));
        ClientMessage response = this.invokeOnPartition(request);
        return (E)this.toObject(AtomicReferenceSetAndGetCodec.decodeResponse((ClientMessage)response).response);
    }

    public boolean isNull() {
        ClientMessage request = AtomicReferenceIsNullCodec.encodeRequest((String)this.name);
        ClientMessage response = this.invokeOnPartition(request);
        return AtomicReferenceIsNullCodec.decodeResponse((ClientMessage)response).response;
    }

    public String toString() {
        return "IAtomicReference{name='" + this.name + '\'' + '}';
    }
}

