/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.collection.common.DataAwareItemEvent;
import com.hazelcast.collection.impl.queue.QueueIterator;
import com.hazelcast.collection.impl.queue.client.AddAllRequest;
import com.hazelcast.collection.impl.queue.client.AddListenerRequest;
import com.hazelcast.collection.impl.queue.client.ClearRequest;
import com.hazelcast.collection.impl.queue.client.CompareAndRemoveRequest;
import com.hazelcast.collection.impl.queue.client.ContainsRequest;
import com.hazelcast.collection.impl.queue.client.DrainRequest;
import com.hazelcast.collection.impl.queue.client.IsEmptyRequest;
import com.hazelcast.collection.impl.queue.client.IteratorRequest;
import com.hazelcast.collection.impl.queue.client.OfferRequest;
import com.hazelcast.collection.impl.queue.client.PeekRequest;
import com.hazelcast.collection.impl.queue.client.PollRequest;
import com.hazelcast.collection.impl.queue.client.RemainingCapacityRequest;
import com.hazelcast.collection.impl.queue.client.RemoveListenerRequest;
import com.hazelcast.collection.impl.queue.client.RemoveRequest;
import com.hazelcast.collection.impl.queue.client.SizeRequest;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.PortableCollection;
import com.hazelcast.spi.impl.PortableItemEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;

public final class ClientQueueProxy<E>
extends ClientProxy
implements IQueue<E> {
    private final String name;

    public ClientQueueProxy(String serviceName, String name) {
        super(serviceName, name);
        this.name = name;
    }

    public String addItemListener(final ItemListener<E> listener, boolean includeValue) {
        AddListenerRequest request = new AddListenerRequest(this.name, includeValue);
        EventHandler<PortableItemEvent> eventHandler = new EventHandler<PortableItemEvent>(){

            @Override
            public void handle(PortableItemEvent portableItemEvent) {
                Data item = portableItemEvent.getItem();
                Member member = ClientQueueProxy.this.getContext().getClusterService().getMember(portableItemEvent.getUuid());
                ItemEventType eventType = portableItemEvent.getEventType();
                DataAwareItemEvent itemEvent = new DataAwareItemEvent(ClientQueueProxy.this.name, eventType, item, member, ClientQueueProxy.this.getContext().getSerializationService());
                if (eventType == ItemEventType.ADDED) {
                    listener.itemAdded((ItemEvent)itemEvent);
                } else {
                    listener.itemRemoved((ItemEvent)itemEvent);
                }
            }

            @Override
            public void beforeListenerRegister() {
            }

            @Override
            public void onListenerRegister() {
            }
        };
        return this.listen((ClientRequest)request, this.getPartitionKey(), eventHandler);
    }

    public boolean removeItemListener(String registrationId) {
        RemoveListenerRequest request = new RemoveListenerRequest(this.name, registrationId);
        return this.stopListening((BaseClientRemoveListenerRequest)request, registrationId);
    }

    public LocalQueueStats getLocalQueueStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException("Queue is full!");
    }

    public boolean offer(E e) {
        try {
            return this.offer(e, 0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    public void put(E e) throws InterruptedException {
        this.offer(e, -1L, TimeUnit.MILLISECONDS);
    }

    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        Data data = this.getContext().getSerializationService().toData(e);
        OfferRequest request = new OfferRequest(this.name, unit.toMillis(timeout), data);
        Boolean result = (Boolean)this.invokeInterruptibly((ClientRequest)request);
        return result;
    }

    public E take() throws InterruptedException {
        return this.poll(-1L, TimeUnit.MILLISECONDS);
    }

    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        PollRequest request = new PollRequest(this.name, unit.toMillis(timeout));
        return (E)this.invokeInterruptibly((ClientRequest)request);
    }

    public int remainingCapacity() {
        RemainingCapacityRequest request = new RemainingCapacityRequest(this.name);
        Integer result = (Integer)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean remove(Object o) {
        Data data = this.getContext().getSerializationService().toData(o);
        RemoveRequest request = new RemoveRequest(this.name, data);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean contains(Object o) {
        ArrayList<Data> list = new ArrayList<Data>(1);
        list.add(this.getContext().getSerializationService().toData(o));
        ContainsRequest request = new ContainsRequest(this.name, list);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public int drainTo(Collection<? super E> objects) {
        return this.drainTo(objects, -1);
    }

    public int drainTo(Collection<? super E> c, int maxElements) {
        DrainRequest request = new DrainRequest(this.name, maxElements);
        PortableCollection result = (PortableCollection)this.invoke((ClientRequest)request);
        Collection coll = result.getCollection();
        for (Data data : coll) {
            Object e = this.getContext().getSerializationService().toObject((Object)data);
            c.add(e);
        }
        return coll.size();
    }

    public E remove() {
        E res = this.poll();
        if (res == null) {
            throw new NoSuchElementException("Queue is empty!");
        }
        return res;
    }

    public E poll() {
        try {
            return this.poll(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public E element() {
        E res = this.peek();
        if (res == null) {
            throw new NoSuchElementException("Queue is empty!");
        }
        return res;
    }

    public E peek() {
        PeekRequest request = new PeekRequest(this.name);
        return (E)this.invoke((ClientRequest)request);
    }

    public int size() {
        SizeRequest request = new SizeRequest(this.name);
        Integer result = (Integer)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean isEmpty() {
        IsEmptyRequest request = new IsEmptyRequest(this.name);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public Iterator<E> iterator() {
        IteratorRequest request = new IteratorRequest(this.name);
        PortableCollection result = (PortableCollection)this.invoke((ClientRequest)request);
        Collection coll = result.getCollection();
        return new QueueIterator(coll.iterator(), this.getContext().getSerializationService(), false);
    }

    public Object[] toArray() {
        IteratorRequest request = new IteratorRequest(this.name);
        PortableCollection result = (PortableCollection)this.invoke((ClientRequest)request);
        Collection coll = result.getCollection();
        int i = 0;
        Object[] array = new Object[coll.size()];
        for (Data data : coll) {
            array[i++] = this.getContext().getSerializationService().toObject((Object)data);
        }
        return array;
    }

    public <T> T[] toArray(T[] ts) {
        IteratorRequest request = new IteratorRequest(this.name);
        PortableCollection result = (PortableCollection)this.invoke((ClientRequest)request);
        Collection coll = result.getCollection();
        int size = coll.size();
        if (ts.length < size) {
            ts = (Object[])Array.newInstance(ts.getClass().getComponentType(), size);
        }
        int i = 0;
        for (Data data : coll) {
            ts[i++] = this.getContext().getSerializationService().toObject((Object)data);
        }
        return ts;
    }

    public boolean containsAll(Collection<?> c) {
        List<Data> list = this.getDataList(c);
        ContainsRequest request = new ContainsRequest(this.name, list);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean addAll(Collection<? extends E> c) {
        AddAllRequest request = new AddAllRequest(this.name, this.getDataList(c));
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean removeAll(Collection<?> c) {
        CompareAndRemoveRequest request = new CompareAndRemoveRequest(this.name, this.getDataList(c), false);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean retainAll(Collection<?> c) {
        CompareAndRemoveRequest request = new CompareAndRemoveRequest(this.name, this.getDataList(c), true);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public void clear() {
        ClearRequest request = new ClearRequest(this.name);
        this.invoke((ClientRequest)request);
    }

    @Override
    protected <T> T invoke(ClientRequest req) {
        return super.invoke(req, this.getPartitionKey());
    }

    protected <T> T invokeInterruptibly(ClientRequest req) throws InterruptedException {
        return super.invokeInterruptibly(req, this.getPartitionKey());
    }

    private List<Data> getDataList(Collection<?> objects) {
        ArrayList<Data> dataList = new ArrayList<Data>(objects.size());
        for (Object o : objects) {
            dataList.add(this.getContext().getSerializationService().toData(o));
        }
        return dataList;
    }

    public String toString() {
        return "IQueue{name='" + this.getName() + '\'' + '}';
    }
}

