/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.config.Config;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.PartitionService;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.instance.TerminatedLifecycleService;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;

public final class HazelcastClientProxy
implements HazelcastInstance,
SerializationServiceSupport {
    public volatile HazelcastClientInstanceImpl client;

    public HazelcastClientProxy(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    public Config getConfig() {
        return this.getClient().getConfig();
    }

    public String getName() {
        return this.getClient().getName();
    }

    public <E> IQueue<E> getQueue(String name) {
        return this.getClient().getQueue(name);
    }

    public <E> ITopic<E> getTopic(String name) {
        return this.getClient().getTopic(name);
    }

    public <E> ISet<E> getSet(String name) {
        return this.getClient().getSet(name);
    }

    public <E> IList<E> getList(String name) {
        return this.getClient().getList(name);
    }

    public <K, V> IMap<K, V> getMap(String name) {
        return this.getClient().getMap(name);
    }

    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return this.getClient().getMultiMap(name);
    }

    public <K, V> ReplicatedMap<K, V> getReplicatedMap(String name) {
        return this.getClient().getReplicatedMap(name);
    }

    public JobTracker getJobTracker(String name) {
        return this.getClient().getJobTracker(name);
    }

    public ILock getLock(Object key) {
        return this.getClient().getLock(key);
    }

    public ILock getLock(String key) {
        return this.getClient().getLock(key);
    }

    public Cluster getCluster() {
        return this.getClient().getCluster();
    }

    public Client getLocalEndpoint() {
        return this.getClient().getLocalEndpoint();
    }

    public IExecutorService getExecutorService(String name) {
        return this.getClient().getExecutorService(name);
    }

    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.getClient().executeTransaction(task);
    }

    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        return this.getClient().executeTransaction(options, task);
    }

    public TransactionContext newTransactionContext() {
        return this.getClient().newTransactionContext();
    }

    public TransactionContext newTransactionContext(TransactionOptions options) {
        return this.getClient().newTransactionContext(options);
    }

    public IdGenerator getIdGenerator(String name) {
        return this.getClient().getIdGenerator(name);
    }

    public IAtomicLong getAtomicLong(String name) {
        return this.getClient().getAtomicLong(name);
    }

    public <E> IAtomicReference<E> getAtomicReference(String name) {
        return this.getClient().getAtomicReference(name);
    }

    public ICountDownLatch getCountDownLatch(String name) {
        return this.getClient().getCountDownLatch(name);
    }

    public ISemaphore getSemaphore(String name) {
        return this.getClient().getSemaphore(name);
    }

    public Collection<DistributedObject> getDistributedObjects() {
        return this.getClient().getDistributedObjects();
    }

    public String addDistributedObjectListener(DistributedObjectListener distributedObjectListener) {
        return this.getClient().addDistributedObjectListener(distributedObjectListener);
    }

    public boolean removeDistributedObjectListener(String registrationId) {
        return this.getClient().removeDistributedObjectListener(registrationId);
    }

    public PartitionService getPartitionService() {
        return this.getClient().getPartitionService();
    }

    public ClientService getClientService() {
        return this.getClient().getClientService();
    }

    public LoggingService getLoggingService() {
        return this.getClient().getLoggingService();
    }

    public LifecycleService getLifecycleService() {
        HazelcastClientInstanceImpl hz = this.client;
        return hz != null ? hz.getLifecycleService() : new TerminatedLifecycleService();
    }

    @Deprecated
    public <T extends DistributedObject> T getDistributedObject(String serviceName, Object id) {
        return this.getClient().getDistributedObject(serviceName, id);
    }

    public <T extends DistributedObject> T getDistributedObject(String serviceName, String name) {
        return this.getClient().getDistributedObject(serviceName, name);
    }

    public ConcurrentMap<String, Object> getUserContext() {
        return this.getClient().getUserContext();
    }

    public ClientConfig getClientConfig() {
        return this.getClient().getClientConfig();
    }

    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    public SerializationService getSerializationService() {
        return this.getClient().getSerializationService();
    }

    private HazelcastClientInstanceImpl getClient() {
        HazelcastClientInstanceImpl c = this.client;
        if (c == null || !c.getLifecycleService().isRunning()) {
            throw new HazelcastInstanceNotActiveException();
        }
        return c;
    }

    public String toString() {
        HazelcastClientInstanceImpl hazelcastInstance = this.client;
        if (hazelcastInstance != null) {
            return hazelcastInstance.toString();
        }
        return "HazelcastClientInstance {NOT ACTIVE}";
    }
}

