/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn.proxy;

import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.txn.TransactionContextProxy;
import com.hazelcast.client.txn.proxy.ClientTxnProxy;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.map.MapKeySet;
import com.hazelcast.map.MapValueCollection;
import com.hazelcast.map.client.AbstractTxnMapRequest;
import com.hazelcast.map.client.TxnMapRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ClientTxnMapProxy<K, V>
extends ClientTxnProxy
implements TransactionalMap<K, V> {
    public ClientTxnMapProxy(String name, TransactionContextProxy proxy) {
        super(name, proxy);
    }

    public boolean containsKey(Object key) {
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.CONTAINS_KEY, this.toData(key));
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public V get(Object key) {
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.GET, this.toData(key));
        return (V)this.invoke((ClientRequest)request);
    }

    public V getForUpdate(Object key) {
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.GET_FOR_UPDATE, this.toData(key));
        return (V)this.invoke((ClientRequest)request);
    }

    public int size() {
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.SIZE);
        Integer result = (Integer)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public V put(K key, V value) {
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.PUT, this.toData(key), this.toData(value));
        return (V)this.invoke((ClientRequest)request);
    }

    public V put(K key, V value, long ttl, TimeUnit timeunit) {
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.PUT_WITH_TTL, this.toData(key), this.toData(value), ttl, timeunit);
        return (V)this.invoke((ClientRequest)request);
    }

    public void set(K key, V value) {
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.SET, this.toData(key), this.toData(value));
        this.invoke((ClientRequest)request);
    }

    public V putIfAbsent(K key, V value) {
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.PUT_IF_ABSENT, this.toData(key), this.toData(value));
        return (V)this.invoke((ClientRequest)request);
    }

    public V replace(K key, V value) {
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.REPLACE, this.toData(key), this.toData(value));
        return (V)this.invoke((ClientRequest)request);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.REPLACE_IF_SAME, this.toData(key), this.toData(oldValue), this.toData(newValue));
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public V remove(Object key) {
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.REMOVE, this.toData(key));
        return (V)this.invoke((ClientRequest)request);
    }

    public void delete(Object key) {
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.DELETE, this.toData(key));
        this.invoke((ClientRequest)request);
    }

    public boolean remove(Object key, Object value) {
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.REMOVE_IF_SAME, this.toData(key), this.toData(value));
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public Set<K> keySet() {
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.KEYSET);
        MapKeySet result = (MapKeySet)this.invoke((ClientRequest)request);
        Set dataKeySet = result.getKeySet();
        HashSet<Object> keySet = new HashSet<Object>(dataKeySet.size());
        for (Data data : dataKeySet) {
            keySet.add(this.toObject(data));
        }
        return keySet;
    }

    public Set<K> keySet(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.KEYSET_BY_PREDICATE, predicate);
        MapKeySet result = (MapKeySet)this.invoke((ClientRequest)request);
        Set dataKeySet = result.getKeySet();
        HashSet<Object> keySet = new HashSet<Object>(dataKeySet.size());
        for (Data data : dataKeySet) {
            keySet.add(this.toObject(data));
        }
        return keySet;
    }

    public Collection<V> values() {
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.VALUES);
        MapValueCollection result = (MapValueCollection)this.invoke((ClientRequest)request);
        Collection dataValues = result.getValues();
        HashSet<Object> values = new HashSet<Object>(dataValues.size());
        for (Data value : dataValues) {
            values.add(this.toObject(value));
        }
        return values;
    }

    public Collection<V> values(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.VALUES_BY_PREDICATE, predicate);
        MapValueCollection result = (MapValueCollection)this.invoke((ClientRequest)request);
        Collection dataValues = result.getValues();
        HashSet<Object> values = new HashSet<Object>(dataValues.size());
        for (Data value : dataValues) {
            values.add(this.toObject(value));
        }
        return values;
    }

    public String getName() {
        return (String)this.getId();
    }

    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    void onDestroy() {
    }
}

