/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientResponseHandler;
import com.hazelcast.client.spi.impl.ClientResponseHandlerSupplier;
import com.hazelcast.client.spi.impl.listener.AbstractClientListenerService;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.networking.OutboundFrame;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public abstract class AbstractClientInvocationService
implements ClientInvocationService {
    private static final HazelcastProperty CLEAN_RESOURCES_MILLIS = new HazelcastProperty("hazelcast.client.internal.clean.resources.millis", Integer.valueOf(100), TimeUnit.MILLISECONDS);
    protected final HazelcastClientInstanceImpl client;
    protected ClientConnectionManager connectionManager;
    protected ClientPartitionService partitionService;
    final ILogger invocationLogger;
    private AbstractClientListenerService clientListenerService;
    @Probe(name="pendingCalls", level=ProbeLevel.MANDATORY)
    private ConcurrentMap<Long, ClientInvocation> invocations = new ConcurrentHashMap<Long, ClientInvocation>();
    private ClientResponseHandlerSupplier responseHandlerSupplier;
    private volatile boolean isShutdown;
    private final long invocationTimeoutMillis;
    private final long invocationRetryPauseMillis;

    public AbstractClientInvocationService(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.invocationLogger = client.getLoggingService().getLogger(ClientInvocationService.class);
        this.invocationTimeoutMillis = this.initInvocationTimeoutMillis();
        this.invocationRetryPauseMillis = this.initInvocationRetryPauseMillis();
        this.responseHandlerSupplier = new ClientResponseHandlerSupplier(this);
        client.getMetricsRegistry().scanAndRegister((Object)this, "invocations");
    }

    private long initInvocationRetryPauseMillis() {
        long pauseTime = this.client.getProperties().getMillis(ClientProperty.INVOCATION_RETRY_PAUSE_MILLIS);
        return pauseTime > 0L ? pauseTime : Long.parseLong(ClientProperty.INVOCATION_RETRY_PAUSE_MILLIS.getDefaultValue());
    }

    private long initInvocationTimeoutMillis() {
        long waitTime = this.client.getProperties().getMillis(ClientProperty.INVOCATION_TIMEOUT_SECONDS);
        return waitTime > 0L ? waitTime : (long)Integer.parseInt(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getDefaultValue());
    }

    public void start() {
        this.connectionManager = this.client.getConnectionManager();
        this.clientListenerService = (AbstractClientListenerService)this.client.getListenerService();
        this.partitionService = this.client.getClientPartitionService();
        this.responseHandlerSupplier.start();
        ClientExecutionService executionService = this.client.getClientExecutionService();
        long cleanResourcesMillis = this.client.getProperties().getMillis(CLEAN_RESOURCES_MILLIS);
        if (cleanResourcesMillis <= 0L) {
            cleanResourcesMillis = Integer.parseInt(CLEAN_RESOURCES_MILLIS.getDefaultValue());
        }
        executionService.scheduleWithRepetition(new CleanResourcesTask(), cleanResourcesMillis, cleanResourcesMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public ClientResponseHandler getResponseHandler() {
        return this.responseHandlerSupplier.get();
    }

    @Override
    public boolean isRedoOperation() {
        return this.client.getClientConfig().getNetworkConfig().isRedoOperation();
    }

    protected void send(ClientInvocation invocation, ClientConnection connection) throws IOException {
        if (this.isShutdown) {
            throw new HazelcastClientNotActiveException("Client is shut down");
        }
        this.registerInvocation(invocation);
        ClientMessage clientMessage = invocation.getClientMessage();
        if (!this.isAllowedToSendRequest(connection, invocation) || !this.writeToConnection(connection, clientMessage)) {
            long callId = clientMessage.getCorrelationId();
            ClientInvocation clientInvocation = this.deRegisterCallId(callId);
            if (clientInvocation != null) {
                throw new IOException("Packet not sent to " + connection.getEndPoint());
            }
            if (this.invocationLogger.isFinestEnabled()) {
                this.invocationLogger.finest("Invocation not found to deregister for call ID " + callId);
            }
            return;
        }
        invocation.setSendConnection(connection);
    }

    private boolean writeToConnection(ClientConnection connection, ClientMessage clientMessage) {
        clientMessage.addFlag((short)192);
        return connection.write((OutboundFrame)clientMessage);
    }

    private boolean isAllowedToSendRequest(ClientConnection connection, ClientInvocation invocation) {
        if (!connection.isHeartBeating()) {
            if (invocation.shouldBypassHeartbeatCheck()) {
                return true;
            }
            if (this.invocationLogger.isFinestEnabled()) {
                this.invocationLogger.finest("Connection is not heart-beating, won't write client message -> " + invocation.getClientMessage());
            }
            return false;
        }
        return true;
    }

    private void registerInvocation(ClientInvocation clientInvocation) {
        short protocolVersion = this.client.getProtocolVersion();
        ClientMessage clientMessage = clientInvocation.getClientMessage();
        clientMessage.setVersion(protocolVersion);
        long correlationId = clientMessage.getCorrelationId();
        this.invocations.put(correlationId, clientInvocation);
        EventHandler handler = clientInvocation.getEventHandler();
        if (handler != null) {
            this.clientListenerService.addEventHandler(correlationId, handler);
        }
    }

    ClientInvocation deRegisterCallId(long callId) {
        return (ClientInvocation)this.invocations.remove(callId);
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public void shutdown() {
        this.isShutdown = true;
        this.responseHandlerSupplier.shutdown();
        Iterator iterator = this.invocations.values().iterator();
        while (iterator.hasNext()) {
            ClientInvocation invocation = (ClientInvocation)iterator.next();
            iterator.remove();
            invocation.notifyException(new HazelcastClientNotActiveException("Client is shutting down"));
        }
    }

    public long getInvocationTimeoutMillis() {
        return this.invocationTimeoutMillis;
    }

    public long getInvocationRetryPauseMillis() {
        return this.invocationRetryPauseMillis;
    }

    private class CleanResourcesTask
    implements Runnable {
        private CleanResourcesTask() {
        }

        @Override
        public void run() {
            Iterator iter = AbstractClientInvocationService.this.invocations.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                ClientInvocation invocation = (ClientInvocation)entry.getValue();
                ClientConnection connection = invocation.getSendConnection();
                if (connection == null || connection.isHeartBeating()) continue;
                iter.remove();
                this.notifyException(invocation, connection);
            }
        }

        private void notifyException(ClientInvocation invocation, ClientConnection connection) {
            TargetDisconnectedException ex = !connection.isAlive() ? new TargetDisconnectedException(connection.getCloseReason(), connection.getCloseCause()) : new TargetDisconnectedException("Heartbeat timed out to " + connection);
            invocation.notifyException((Throwable)ex);
        }
    }
}

