/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractLoadBalancer
implements LoadBalancer,
InitialMembershipListener {
    private final AtomicReference<Member[]> membersRef = new AtomicReference<Member[]>(new Member[0]);
    private volatile Cluster clusterRef;

    @Override
    public final void init(Cluster cluster, ClientConfig config) {
        this.clusterRef = cluster;
        cluster.addMembershipListener((MembershipListener)this);
    }

    private void setMembersRef() {
        Set memberSet = this.clusterRef.getMembers();
        Member[] members = memberSet.toArray(new Member[memberSet.size()]);
        this.membersRef.set(members);
    }

    protected Member[] getMembers() {
        return this.membersRef.get();
    }

    public final void init(InitialMembershipEvent event) {
        this.setMembersRef();
    }

    public final void memberAdded(MembershipEvent membershipEvent) {
        this.setMembersRef();
    }

    public final void memberRemoved(MembershipEvent membershipEvent) {
        this.setMembersRef();
    }

    public final void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }
}

