/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.AtomicNumberClientProxy;
import com.hazelcast.client.Call;
import com.hazelcast.client.ClientConfig;
import com.hazelcast.client.ClientThreadContext;
import com.hazelcast.client.ClusterClientException;
import com.hazelcast.client.ClusterClientProxy;
import com.hazelcast.client.Connection;
import com.hazelcast.client.ConnectionManager;
import com.hazelcast.client.CountDownLatchClientProxy;
import com.hazelcast.client.DefaultClientBinder;
import com.hazelcast.client.ExecutorServiceClientProxy;
import com.hazelcast.client.IdGeneratorClientProxy;
import com.hazelcast.client.InRunnable;
import com.hazelcast.client.LifecycleServiceClientImpl;
import com.hazelcast.client.ListClientProxy;
import com.hazelcast.client.LockClientProxy;
import com.hazelcast.client.MapClientProxy;
import com.hazelcast.client.MultiMapClientProxy;
import com.hazelcast.client.OutRunnable;
import com.hazelcast.client.PacketReader;
import com.hazelcast.client.PacketWriter;
import com.hazelcast.client.PartitionClientProxy;
import com.hazelcast.client.QueueClientProxy;
import com.hazelcast.client.SemaphoreClientProxy;
import com.hazelcast.client.SetClientProxy;
import com.hazelcast.client.TopicClientProxy;
import com.hazelcast.client.TransactionClientProxy;
import com.hazelcast.client.impl.ListenerManager;
import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.AtomicNumber;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceListener;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.Transaction;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HazelcastClient
implements HazelcastInstance {
    private static final AtomicInteger clientIdCounter = new AtomicInteger();
    private static final List<HazelcastClient> lsClients = new CopyOnWriteArrayList<HazelcastClient>();
    final Map<Long, Call> calls = new ConcurrentHashMap<Long, Call>(100);
    final ListenerManager listenerManager;
    final OutRunnable out;
    final InRunnable in;
    final ConnectionManager connectionManager;
    final Map<Object, Object> mapProxies = new ConcurrentHashMap<Object, Object>(100);
    final ConcurrentMap<String, ExecutorServiceClientProxy> mapExecutors = new ConcurrentHashMap<String, ExecutorServiceClientProxy>(2);
    final ClusterClientProxy clusterClientProxy;
    final PartitionClientProxy partitionClientProxy;
    final LifecycleServiceClientImpl lifecycleService;
    static final ILogger logger = Logger.getLogger((String)HazelcastClient.class.getName());
    final int id;
    private final ClientConfig config;
    private final AtomicBoolean active = new AtomicBoolean(true);

    private HazelcastClient(ClientConfig config) {
        if (config.getAddressList().size() == 0) {
            config.addAddress("localhost");
        }
        if (config.getCredentials() == null) {
            config.setCredentials((Credentials)new UsernamePasswordCredentials(config.getGroupConfig().getName(), config.getGroupConfig().getPassword()));
        }
        this.config = config;
        this.id = clientIdCounter.incrementAndGet();
        this.lifecycleService = new LifecycleServiceClientImpl(this);
        this.lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTING);
        this.connectionManager = new ConnectionManager(this, config, this.lifecycleService);
        this.connectionManager.setBinder(new DefaultClientBinder(this));
        this.out = new OutRunnable(this, this.calls, new PacketWriter());
        this.in = new InRunnable(this, this.out, this.calls, new PacketReader());
        this.listenerManager = new ListenerManager(this);
        try {
            Connection c = this.connectionManager.getInitConnection();
            if (c == null) {
                this.connectionManager.shutdown();
                this.lifecycleService.destroy();
                throw new IllegalStateException("Unable to connect to cluster");
            }
        }
        catch (IOException e) {
            this.connectionManager.shutdown();
            this.lifecycleService.destroy();
            throw new ClusterClientException(e.getMessage(), e);
        }
        String prefix = "hz.client." + this.id + ".";
        new Thread((Runnable)this.out, prefix + "OutThread").start();
        new Thread((Runnable)this.in, prefix + "InThread").start();
        new Thread((Runnable)this.listenerManager, prefix + "Listener").start();
        this.clusterClientProxy = new ClusterClientProxy(this);
        this.partitionClientProxy = new PartitionClientProxy(this);
        if (config.isUpdateAutomatic()) {
            this.getCluster().addMembershipListener((MembershipListener)this.connectionManager);
            this.connectionManager.updateMembers();
        }
        this.lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTED);
        this.connectionManager.scheduleHeartbeatTimerTask();
        lsClients.add(this);
    }

    GroupConfig groupConfig() {
        return this.config.getGroupConfig();
    }

    public InRunnable getInRunnable() {
        return this.in;
    }

    public OutRunnable getOutRunnable() {
        return this.out;
    }

    ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public static HazelcastClient newHazelcastClient(ClientConfig config) {
        if (config == null) {
            config = new ClientConfig();
        }
        return new HazelcastClient(config);
    }

    public Config getConfig() {
        throw new UnsupportedOperationException();
    }

    public PartitionService getPartitionService() {
        return this.partitionClientProxy;
    }

    public ClientService getClientService() {
        return null;
    }

    public LoggingService getLoggingService() {
        throw new UnsupportedOperationException();
    }

    public <K, V> IMap<K, V> getMap(String name) {
        return (IMap)this.getClientProxy("c:" + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V, E> Object getClientProxy(Object o) {
        MapClientProxy proxy = this.mapProxies.get(o);
        if (proxy == null) {
            Map<Object, Object> map = this.mapProxies;
            synchronized (map) {
                proxy = this.mapProxies.get(o);
                if (proxy == null) {
                    String name;
                    proxy = o instanceof String ? ((name = (String)o).startsWith("c:") ? new MapClientProxy(this, name) : (name.startsWith("l:") ? new ListClientProxy(this, name) : (name.startsWith("m:s:") ? new SetClientProxy(this, name) : (name.startsWith("q:") ? new QueueClientProxy(this, name) : (name.startsWith("t:") ? new TopicClientProxy(this, name) : (name.startsWith("a:") ? new AtomicNumberClientProxy(this, name) : (name.startsWith("d:") ? new CountDownLatchClientProxy(this, name) : (name.startsWith("i:") ? new IdGeneratorClientProxy(this, name) : (name.startsWith("m:u:") ? new MultiMapClientProxy(this, name) : (name.startsWith("4:") ? new SemaphoreClientProxy(this, name) : new LockClientProxy(o, this))))))))))) : new LockClientProxy(o, this);
                    this.mapProxies.put(o, proxy);
                }
            }
        }
        return this.mapProxies.get(o);
    }

    public Transaction getTransaction() {
        ClientThreadContext trc = ClientThreadContext.get();
        TransactionClientProxy proxy = (TransactionClientProxy)trc.getTransaction(this);
        return proxy;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void addInstanceListener(InstanceListener instanceListener) {
        this.clusterClientProxy.addInstanceListener(instanceListener);
    }

    public Cluster getCluster() {
        return this.clusterClientProxy;
    }

    public ExecutorService getExecutorService() {
        return this.getExecutorService("default");
    }

    public ExecutorService getExecutorService(String name) {
        ExecutorServiceClientProxy old;
        if (name == null) {
            throw new IllegalArgumentException("ExecutorService name cannot be null");
        }
        ExecutorServiceClientProxy executorServiceProxy = (ExecutorServiceClientProxy)this.mapExecutors.get(name);
        if (executorServiceProxy == null && (old = this.mapExecutors.putIfAbsent(name, executorServiceProxy = new ExecutorServiceClientProxy(this, name))) != null) {
            executorServiceProxy = old;
        }
        return executorServiceProxy;
    }

    public IdGenerator getIdGenerator(String name) {
        return (IdGenerator)this.getClientProxy("i:" + name);
    }

    public AtomicNumber getAtomicNumber(String name) {
        return (AtomicNumber)this.getClientProxy("a:" + name);
    }

    public ICountDownLatch getCountDownLatch(String name) {
        return (ICountDownLatch)this.getClientProxy("d:" + name);
    }

    public ISemaphore getSemaphore(String name) {
        return (ISemaphore)this.getClientProxy("4:" + name);
    }

    public Collection<Instance> getInstances() {
        return this.clusterClientProxy.getInstances();
    }

    public <E> IList<E> getList(String name) {
        return (IList)this.getClientProxy("l:" + name);
    }

    public ILock getLock(Object obj) {
        return new LockClientProxy(obj, this);
    }

    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return (MultiMap)this.getClientProxy("m:u:" + name);
    }

    public String getName() {
        return this.config.getGroupConfig().getName();
    }

    public <E> IQueue<E> getQueue(String name) {
        return (IQueue)this.getClientProxy("q:" + name);
    }

    public <E> ISet<E> getSet(String name) {
        return (ISet)this.getClientProxy("m:s:" + name);
    }

    public <E> ITopic<E> getTopic(String name) {
        return (ITopic)this.getClientProxy("t:" + name);
    }

    public void removeInstanceListener(InstanceListener instanceListener) {
        this.clusterClientProxy.removeInstanceListener(instanceListener);
    }

    public static void shutdownAll() {
        for (HazelcastClient hazelcastClient : lsClients) {
            try {
                hazelcastClient.shutdown();
            }
            catch (Exception exception) {}
        }
        lsClients.clear();
    }

    public static Collection<HazelcastClient> getAllHazelcastClients() {
        return Collections.unmodifiableCollection(lsClients);
    }

    public void shutdown() {
        this.lifecycleService.shutdown();
    }

    void doShutdown() {
        if (this.active.compareAndSet(true, false)) {
            logger.log(Level.INFO, "HazelcastClient[" + this.id + "] is shutting down.");
            this.out.shutdown();
            this.in.shutdown();
            this.connectionManager.shutdown();
            this.listenerManager.shutdown();
            ClientThreadContext.shutdown();
            lsClients.remove(this);
        }
    }

    public boolean isActive() {
        return this.active.get();
    }

    protected void destroy(String proxyName) {
        this.mapProxies.remove(proxyName);
    }

    public void restart() {
        this.lifecycleService.restart();
    }

    public LifecycleService getLifecycleService() {
        return this.lifecycleService;
    }

    static void runAsyncAndWait(final Runnable runnable) {
        HazelcastClient.callAsyncAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                runnable.run();
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <V> V callAsyncAndWait(Callable<V> callable) {
        ExecutorService es = Executors.newSingleThreadExecutor();
        try {
            V v;
            Future<V> future = es.submit(callable);
            try {
                v = future.get();
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                V v2 = null;
                es.shutdown();
                return v2;
            }
            return v;
        }
        finally {
            es.shutdown();
        }
    }

    public ClientConfig getClientConfig() {
        return this.config;
    }
}

