/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.AsyncClientCall;
import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceDestroyedException;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.monitor.LocalSemaphoreStats;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class SemaphoreClientProxy
implements ISemaphore {
    private final String name;
    private final ProxyHelper proxyHelper;

    public SemaphoreClientProxy(HazelcastClient hazelcastClient, String name) {
        this.name = name;
        this.proxyHelper = new ProxyHelper(name, hazelcastClient);
    }

    public void acquire() throws InstanceDestroyedException, InterruptedException {
        this.acquire(1);
    }

    public void acquire(int permits) throws InstanceDestroyedException, InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        this.proxyHelper.doOp(ClusterOperation.SEMAPHORE_TRY_ACQUIRE, false, permits, -1L, TimeUnit.MILLISECONDS);
    }

    public Future acquireAsync() {
        return this.acquireAsync(1);
    }

    public Future acquireAsync(int permits) {
        return this.doAcquireAsync(permits, false);
    }

    public void acquireAttach() throws InstanceDestroyedException, InterruptedException {
        this.acquireAttach(1);
    }

    public void acquireAttach(int permits) throws InstanceDestroyedException, InterruptedException {
        this.proxyHelper.doOp(ClusterOperation.SEMAPHORE_TRY_ACQUIRE, true, permits, -1L, TimeUnit.MILLISECONDS);
    }

    public Future acquireAttachAsync() {
        return this.acquireAttachAsync(1);
    }

    public Future acquireAttachAsync(int permits) {
        return this.doAcquireAsync(permits, true);
    }

    public void attach() {
        this.attach(1);
    }

    public void attach(int permits) {
        this.proxyHelper.doOp(ClusterOperation.SEMAPHORE_ATTACH_DETACH_PERMITS, true, permits);
    }

    public int attachedPermits() {
        return (Integer)this.proxyHelper.doOp(ClusterOperation.SEMAPHORE_GET_ATTACHED_PERMITS, false, 0);
    }

    public int availablePermits() {
        return (Integer)this.proxyHelper.doOp(ClusterOperation.SEMAPHORE_GET_AVAILABLE_PERMITS, false, 0);
    }

    public void detach() {
        this.detach(1);
    }

    public void detach(int permits) {
        this.proxyHelper.doOp(ClusterOperation.SEMAPHORE_ATTACH_DETACH_PERMITS, false, permits);
    }

    public int drainPermits() {
        return (Integer)this.proxyHelper.doOp(ClusterOperation.SEMAPHORE_DRAIN_PERMITS, false, 0);
    }

    public void reducePermits(int permits) {
        this.proxyHelper.doOp(ClusterOperation.SEMAPHORE_REDUCE_PERMITS, false, permits);
    }

    public void release() {
        this.release(1);
    }

    public void release(int permits) {
        this.proxyHelper.doOp(ClusterOperation.SEMAPHORE_RELEASE, false, permits);
    }

    public void releaseDetach() {
        this.releaseDetach(1);
    }

    public void releaseDetach(int permits) {
        this.proxyHelper.doOp(ClusterOperation.SEMAPHORE_RELEASE, true, permits);
    }

    public boolean tryAcquire() {
        return this.tryAcquire(1);
    }

    public boolean tryAcquire(int permits) {
        try {
            return this.tryAcquire(permits, 0L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
        return this.tryAcquire(1, timeout, unit);
    }

    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.SEMAPHORE_TRY_ACQUIRE, false, permits, timeout, unit);
    }

    public boolean tryAcquireAttach() {
        return this.tryAcquireAttach(1);
    }

    public boolean tryAcquireAttach(int permits) {
        try {
            return this.tryAcquireAttach(permits, 0L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public boolean tryAcquireAttach(long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
        return this.tryAcquireAttach(1, timeout, unit);
    }

    public boolean tryAcquireAttach(int permits, long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.SEMAPHORE_TRY_ACQUIRE, true, permits, timeout, unit);
    }

    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.SEMAPHORE;
    }

    public void destroy() {
        this.proxyHelper.destroy();
    }

    public Object getId() {
        return this.name;
    }

    public String getName() {
        return this.name.substring("4:".length());
    }

    private Future doAcquireAsync(int permits, boolean attach) {
        Packet request = this.proxyHelper.prepareRequest(ClusterOperation.SEMAPHORE_TRY_ACQUIRE, attach, permits, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Call remoteCall = this.proxyHelper.createCall(request);
        this.proxyHelper.sendCall(remoteCall);
        return new AsyncClientCall(remoteCall){

            public boolean cancel(boolean mayInterruptIfRunning) {
                return !this.isDone() && (this.cancelled = ((Boolean)SemaphoreClientProxy.this.proxyHelper.doOp(ClusterOperation.SEMAPHORE_CANCEL_ACQUIRE, false, 0)).booleanValue());
            }
        };
    }

    public LocalSemaphoreStats getLocalSemaphoreStats() {
        throw new UnsupportedOperationException();
    }
}

