/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.Call;
import com.hazelcast.client.ClientRunnable;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.IOUtil;
import com.hazelcast.client.Packet;
import com.hazelcast.client.impl.EntryListenerManager;
import com.hazelcast.client.impl.InstanceListenerManager;
import com.hazelcast.client.impl.ItemListenerManager;
import com.hazelcast.client.impl.MembershipListenerManager;
import com.hazelcast.client.impl.MessageListenerManager;
import com.hazelcast.client.impl.QueueItemListenerManager;
import com.hazelcast.core.Instance;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ListenerManager
extends ClientRunnable {
    private final ILogger logger = Logger.getLogger((String)this.getClass().getName());
    private final HazelcastClient client;
    private final BlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
    private final InstanceListenerManager instanceListenerManager;
    private final MembershipListenerManager membershipListenerManager;
    private final MessageListenerManager messageListenerManager;
    private final EntryListenerManager entryListenerManager;
    private final ItemListenerManager itemListenerManager;
    private final QueueItemListenerManager queueItemListenerManager;

    public ListenerManager(HazelcastClient hazelcastClient) {
        this.client = hazelcastClient;
        this.instanceListenerManager = new InstanceListenerManager(this.client);
        this.membershipListenerManager = new MembershipListenerManager(this.client);
        this.messageListenerManager = new MessageListenerManager();
        this.entryListenerManager = new EntryListenerManager();
        this.itemListenerManager = new ItemListenerManager(this.entryListenerManager);
        this.queueItemListenerManager = new QueueItemListenerManager();
    }

    public void enqueue(Object object) {
        try {
            this.queue.put(object);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.FINEST, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void customRun() throws InterruptedException {
        try {
            Object obj = this.queue.poll(100L, TimeUnit.MILLISECONDS);
            if (obj == null) {
                return;
            }
            if (obj instanceof Packet) {
                Packet packet = (Packet)obj;
                if (packet.getName() == null) {
                    Object eventType = IOUtil.toObject(packet.getValue());
                    if (new Integer(0).equals(eventType) || new Integer(2).equals(eventType)) {
                        this.instanceListenerManager.notifyListeners(packet);
                    } else {
                        this.membershipListenerManager.notifyListeners(packet);
                    }
                } else if (BaseManager.getInstanceType((String)packet.getName()).equals((Object)Instance.InstanceType.TOPIC)) {
                    this.messageListenerManager.notifyMessageListeners(packet);
                } else if (BaseManager.getInstanceType((String)packet.getName()).equals((Object)Instance.InstanceType.QUEUE)) {
                    this.queueItemListenerManager.notifyListeners(packet);
                } else {
                    this.entryListenerManager.notifyListeners(packet);
                }
            } else if (obj instanceof Runnable) {
                ((Runnable)obj).run();
            }
        }
        catch (InterruptedException ine) {
            throw ine;
        }
        catch (Throwable ignored) {
            ignored.printStackTrace();
        }
    }

    public Collection<Call> getListenerCalls() {
        ArrayList<Call> calls = new ArrayList<Call>();
        calls.addAll(this.instanceListenerManager.calls(this.client));
        calls.addAll(this.entryListenerManager.calls(this.client));
        calls.addAll(this.itemListenerManager.calls(this.client));
        calls.addAll(this.queueItemListenerManager.calls(this.client));
        calls.addAll(this.messageListenerManager.calls(this.client));
        return calls;
    }

    public InstanceListenerManager getInstanceListenerManager() {
        return this.instanceListenerManager;
    }

    public MembershipListenerManager getMembershipListenerManager() {
        return this.membershipListenerManager;
    }

    public MessageListenerManager getMessageListenerManager() {
        return this.messageListenerManager;
    }

    public EntryListenerManager getEntryListenerManager() {
        return this.entryListenerManager;
    }

    public ItemListenerManager getItemListenerManager() {
        return this.itemListenerManager;
    }

    public QueueItemListenerManager getQueueItemListenerManager() {
        return this.queueItemListenerManager;
    }
}

