/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.core.AtomicNumber;
import com.hazelcast.core.Instance;
import com.hazelcast.impl.ClusterOperation;

public class AtomicNumberClientProxy
implements AtomicNumber {
    private final String name;
    private final ProxyHelper proxyHelper;

    public AtomicNumberClientProxy(HazelcastClient hazelcastClient, String name) {
        this.name = name;
        this.proxyHelper = new ProxyHelper(this.getName(), hazelcastClient);
    }

    public String getName() {
        return this.name.substring("a:".length());
    }

    public long addAndGet(long delta) {
        return this.setLongGetLong(ClusterOperation.ATOMIC_NUMBER_ADD_AND_GET, delta);
    }

    private long setLongGetLong(ClusterOperation operation, long value) {
        Packet request = this.proxyHelper.prepareRequest(operation, null, null);
        request.setLongValue(value);
        Packet response = this.proxyHelper.callAndGetResult(request);
        return (Long)this.proxyHelper.getValue(response);
    }

    public boolean compareAndSet(long expect, long update) {
        Packet request = this.proxyHelper.prepareRequest(ClusterOperation.ATOMIC_NUMBER_COMPARE_AND_SET, expect, update);
        Packet response = this.proxyHelper.callAndGetResult(request);
        return (Boolean)this.proxyHelper.getValue(response);
    }

    public boolean weakCompareAndSet(long expect, long update) {
        return this.compareAndSet(expect, update);
    }

    public long decrementAndGet() {
        return this.setLongGetLong(ClusterOperation.ATOMIC_NUMBER_ADD_AND_GET, -1L);
    }

    public long get() {
        return this.getAndAdd(0L);
    }

    public long getAndAdd(long delta) {
        return this.setLongGetLong(ClusterOperation.ATOMIC_NUMBER_GET_AND_ADD, delta);
    }

    public long getAndSet(long newValue) {
        return this.setLongGetLong(ClusterOperation.ATOMIC_NUMBER_GET_AND_SET, newValue);
    }

    public long incrementAndGet() {
        return this.setLongGetLong(ClusterOperation.ATOMIC_NUMBER_ADD_AND_GET, 1L);
    }

    public void lazySet(long newValue) {
        this.set(newValue);
    }

    public void set(long newValue) {
        this.getAndSet(newValue);
    }

    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.ATOMIC_NUMBER;
    }

    public void destroy() {
        this.proxyHelper.destroy();
    }

    public Object getId() {
        return this.name;
    }
}

