/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.Connection;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.IORunnable;
import com.hazelcast.client.PacketWriter;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutRunnable
extends IORunnable {
    final PacketWriter writer;
    final BlockingQueue<Call> queue = new LinkedBlockingQueue<Call>();
    final BlockingQueue<Call> temp = new LinkedBlockingQueue<Call>();
    private Connection connection = null;
    Logger logger = Logger.getLogger(this.getClass().toString());

    public OutRunnable(HazelcastClient client, Map<Long, Call> calls, PacketWriter writer) {
        super(client, calls);
        this.writer = writer;
    }

    @Override
    protected void customRun() throws InterruptedException {
        Call call = null;
        try {
            call = this.queue.poll(100L, TimeUnit.MILLISECONDS);
            if (call == null) {
                return;
            }
            this.callMap.put(call.getId(), call);
            Connection oldConnection = this.connection;
            this.connection = this.client.connectionManager.getConnection();
            if (this.restoredConnection(oldConnection, this.connection)) {
                this.redoUnfinishedCalls(call, oldConnection);
            } else if (this.connection != null) {
                this.writer.write(this.connection, call.getRequest());
            } else {
                this.interruptWaitingCalls();
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable io) {
            this.logger.info("OutRunnable got an exception:" + io.getMessage());
            this.enQueue(call);
            this.client.connectionManager.destroyConnection(this.connection);
        }
    }

    private void redoUnfinishedCalls(Call call, Connection oldConnection) {
        this.temp.add(call);
        this.queue.drainTo(this.temp);
        this.client.listenerManager.getListenerCalls().drainTo(this.queue);
        this.temp.drainTo(this.queue);
        this.onDisconnect(oldConnection);
    }

    public void enQueue(Call call) {
        try {
            this.queue.put(call);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

