/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.AddressCodec;
import com.hazelcast.client.impl.protocol.codec.ClientMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class ClientAuthenticationCustomCodec {
    public static final ClientMessageType REQUEST_TYPE = ClientMessageType.CLIENT_AUTHENTICATIONCUSTOM;
    public static final int RESPONSE_TYPE = 107;
    public static final boolean RETRYABLE = true;

    public static ClientMessage encodeRequest(Data credentials, String uuid, String ownerUuid, boolean isOwnerConnection, String clientType, byte serializationVersion) {
        int requiredDataSize = RequestParameters.calculateDataSize(credentials, uuid, ownerUuid, isOwnerConnection, clientType, serializationVersion);
        ClientMessage clientMessage = ClientMessage.createForEncode((int)requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(true);
        clientMessage.set(credentials);
        if (uuid == null) {
            boolean uuid_isNull = true;
            clientMessage.set(uuid_isNull);
        } else {
            boolean uuid_isNull = false;
            clientMessage.set(uuid_isNull);
            clientMessage.set(uuid);
        }
        if (ownerUuid == null) {
            boolean ownerUuid_isNull = true;
            clientMessage.set(ownerUuid_isNull);
        } else {
            boolean ownerUuid_isNull = false;
            clientMessage.set(ownerUuid_isNull);
            clientMessage.set(ownerUuid);
        }
        clientMessage.set(isOwnerConnection);
        clientMessage.set(clientType);
        clientMessage.set(serializationVersion);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        byte serializationVersion;
        boolean isOwnerConnection;
        RequestParameters parameters = new RequestParameters();
        Data credentials = null;
        parameters.credentials = credentials = clientMessage.getData();
        String uuid = null;
        boolean uuid_isNull = clientMessage.getBoolean();
        if (!uuid_isNull) {
            parameters.uuid = uuid = clientMessage.getStringUtf8();
        }
        String ownerUuid = null;
        boolean ownerUuid_isNull = clientMessage.getBoolean();
        if (!ownerUuid_isNull) {
            parameters.ownerUuid = ownerUuid = clientMessage.getStringUtf8();
        }
        parameters.isOwnerConnection = isOwnerConnection = clientMessage.getBoolean();
        String clientType = null;
        parameters.clientType = clientType = clientMessage.getStringUtf8();
        parameters.serializationVersion = serializationVersion = clientMessage.getByte();
        return parameters;
    }

    public static ClientMessage encodeResponse(byte status, Address address, String uuid, String ownerUuid, byte serializationVersion) {
        int requiredDataSize = ResponseParameters.calculateDataSize(status, address, uuid, ownerUuid, serializationVersion);
        ClientMessage clientMessage = ClientMessage.createForEncode((int)requiredDataSize);
        clientMessage.setMessageType(107);
        clientMessage.set(status);
        if (address == null) {
            boolean address_isNull = true;
            clientMessage.set(address_isNull);
        } else {
            boolean address_isNull = false;
            clientMessage.set(address_isNull);
            AddressCodec.encode(address, clientMessage);
        }
        if (uuid == null) {
            boolean uuid_isNull = true;
            clientMessage.set(uuid_isNull);
        } else {
            boolean uuid_isNull = false;
            clientMessage.set(uuid_isNull);
            clientMessage.set(uuid);
        }
        if (ownerUuid == null) {
            boolean ownerUuid_isNull = true;
            clientMessage.set(ownerUuid_isNull);
        } else {
            boolean ownerUuid_isNull = false;
            clientMessage.set(ownerUuid_isNull);
            clientMessage.set(ownerUuid);
        }
        clientMessage.set(serializationVersion);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        byte serializationVersion;
        byte status;
        ResponseParameters parameters = new ResponseParameters();
        parameters.status = status = clientMessage.getByte();
        Address address = null;
        boolean address_isNull = clientMessage.getBoolean();
        if (!address_isNull) {
            parameters.address = address = AddressCodec.decode(clientMessage);
        }
        String uuid = null;
        boolean uuid_isNull = clientMessage.getBoolean();
        if (!uuid_isNull) {
            parameters.uuid = uuid = clientMessage.getStringUtf8();
        }
        String ownerUuid = null;
        boolean ownerUuid_isNull = clientMessage.getBoolean();
        if (!ownerUuid_isNull) {
            parameters.ownerUuid = ownerUuid = clientMessage.getStringUtf8();
        }
        parameters.serializationVersion = serializationVersion = clientMessage.getByte();
        return parameters;
    }

    public static class ResponseParameters {
        public byte status;
        public Address address;
        public String uuid;
        public String ownerUuid;
        public byte serializationVersion;

        public static int calculateDataSize(byte status, Address address, String uuid, String ownerUuid, byte serializationVersion) {
            int dataSize = ClientMessage.HEADER_SIZE;
            ++dataSize;
            ++dataSize;
            if (address != null) {
                dataSize += AddressCodec.calculateDataSize(address);
            }
            ++dataSize;
            if (uuid != null) {
                dataSize += ParameterUtil.calculateDataSize((String)uuid);
            }
            ++dataSize;
            if (ownerUuid != null) {
                dataSize += ParameterUtil.calculateDataSize((String)ownerUuid);
            }
            return ++dataSize;
        }
    }

    public static class RequestParameters {
        public static final ClientMessageType TYPE = REQUEST_TYPE;
        public Data credentials;
        public String uuid;
        public String ownerUuid;
        public boolean isOwnerConnection;
        public String clientType;
        public byte serializationVersion;

        public static int calculateDataSize(Data credentials, String uuid, String ownerUuid, boolean isOwnerConnection, String clientType, byte serializationVersion) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize((Data)credentials);
            ++dataSize;
            if (uuid != null) {
                dataSize += ParameterUtil.calculateDataSize((String)uuid);
            }
            ++dataSize;
            if (ownerUuid != null) {
                dataSize += ParameterUtil.calculateDataSize((String)ownerUuid);
            }
            ++dataSize;
            dataSize += ParameterUtil.calculateDataSize((String)clientType);
            return ++dataSize;
        }
    }
}

