/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.connector.map;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Reader<F extends CompletableFuture, B, R> {
    protected final String objectName;
    private final Function<B, Integer> toNextIndexFn;
    private Function<B, List<R>> toRecordSetFn;

    public Reader(@Nonnull String objectName, @Nonnull Function<B, Integer> toNextIndexFn, @Nonnull Function<B, List<R>> toRecordSetFn) {
        this.objectName = objectName;
        this.toNextIndexFn = toNextIndexFn;
        this.toRecordSetFn = toRecordSetFn;
    }

    @Nonnull
    public abstract F readBatch(int var1, int var2);

    @Nonnull
    public B toBatchResult(@Nonnull F future) throws ExecutionException, InterruptedException {
        return (B)((CompletableFuture)future).get();
    }

    public final int toNextIndex(@Nonnull B result) {
        return this.toNextIndexFn.apply(result);
    }

    @Nonnull
    public final List<R> toRecordSet(@Nonnull B result) {
        return this.toRecordSetFn.apply(result);
    }

    @Nullable
    public abstract Object toObject(@Nonnull R var1);
}

