/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection;

import com.h3xstream.findsecbugs.FindSecBugsGlobalConfig;
import com.h3xstream.findsecbugs.injection.AbstractInjectionDetector;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.injection.SinksLoader;
import com.h3xstream.findsecbugs.taintanalysis.TaintDataflowEngine;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrameAdditionalVisitor;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.io.IO;
import edu.umd.cs.findbugs.util.ClassName;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public abstract class BasicInjectionDetector
extends AbstractInjectionDetector {
    private final Map<String, InjectionPoint> injectionMap = new HashMap<String, InjectionPoint>();
    private static final SinksLoader SINKS_LOADER = new SinksLoader();

    protected BasicInjectionDetector(BugReporter bugReporter) {
        super(bugReporter);
        this.loadCustomConfigFiles();
    }

    @Override
    protected InjectionPoint getInjectionPoint(InvokeInstruction invoke, ConstantPoolGen cpg, InstructionHandle handle) {
        assert (invoke != null && cpg != null);
        String fullMethodName = this.getFullMethodName(invoke, cpg);
        if ("java/lang/Object.<init>()V".equals(fullMethodName)) {
            return InjectionPoint.NONE;
        }
        InjectionPoint injectionPoint = this.injectionMap.get(fullMethodName);
        if (injectionPoint != null) {
            return injectionPoint;
        }
        try {
            JavaClass classDef = Repository.lookupClass((String)invoke.getClassName(cpg));
            for (JavaClass superClass : classDef.getSuperClasses()) {
                String superClassFullMethodName;
                if ("java.lang.Object".equals(superClass.getClassName()) || (injectionPoint = this.injectionMap.get(superClassFullMethodName = superClass.getClassName().replace('.', '/') + "." + invoke.getMethodName(cpg) + invoke.getSignature(cpg))) == null) continue;
                return injectionPoint;
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass((ClassNotFoundException)e);
        }
        return InjectionPoint.NONE;
    }

    protected void loadConfiguredSinks(InputStream stream, String bugType) throws IOException {
        SINKS_LOADER.loadSinks(stream, bugType, new SinksLoader.InjectionPointReceiver(){

            @Override
            public void receiveInjectionPoint(String fullMethodName, InjectionPoint injectionPoint) {
                BasicInjectionDetector.this.addParsedInjectionPoint(fullMethodName, injectionPoint);
            }
        });
    }

    protected void loadConfiguredSinks(String filename, String bugType) {
        SINKS_LOADER.loadConfiguredSinks(filename, bugType, new SinksLoader.InjectionPointReceiver(){

            @Override
            public void receiveInjectionPoint(String fullMethodName, InjectionPoint injectionPoint) {
                BasicInjectionDetector.this.addParsedInjectionPoint(fullMethodName, injectionPoint);
            }
        });
    }

    protected void loadCustomConfigFiles() {
        String customConfigFile = FindSecBugsGlobalConfig.getInstance().getCustomConfigFile(this.getClass().getSimpleName());
        if (customConfigFile != null && !customConfigFile.isEmpty()) {
            for (String configFile : customConfigFile.split(File.pathSeparator)) {
                String[] injectionDefinition = configFile.split(Pattern.quote("|"));
                if (injectionDefinition.length != 2 || injectionDefinition[0].trim().isEmpty() || injectionDefinition[1].trim().isEmpty()) {
                    AnalysisContext.logError((String)("Wrong injection config file definition: " + configFile + ". Syntax: fileName|bugType, example: sql-custom.txt|SQL_INJECTION_HIBERNATE"));
                    continue;
                }
                this.loadCustomSinks(injectionDefinition[0], injectionDefinition[1]);
            }
        }
    }

    protected void loadCustomSinks(String fileName, String bugType) {
        InputStream stream;
        block5: {
            stream = null;
            try {
                File file = new File(fileName);
                if (file.exists()) {
                    stream = new FileInputStream(file);
                    this.loadConfiguredSinks(stream, bugType);
                    break block5;
                }
                stream = this.getClass().getClassLoader().getResourceAsStream(fileName);
                this.loadConfiguredSinks(stream, bugType);
            }
            catch (Exception ex) {
                try {
                    throw new RuntimeException("Cannot load custom injection sinks from " + fileName, ex);
                }
                catch (Throwable throwable) {
                    IO.close(stream);
                    throw throwable;
                }
            }
        }
        IO.close((InputStream)stream);
    }

    protected void loadSink(String line, String bugType) {
        SINKS_LOADER.loadSink(line, bugType, new SinksLoader.InjectionPointReceiver(){

            @Override
            public void receiveInjectionPoint(String fullMethodName, InjectionPoint injectionPoint) {
                BasicInjectionDetector.this.addParsedInjectionPoint(fullMethodName, injectionPoint);
            }
        });
    }

    protected void addParsedInjectionPoint(String fullMethodName, InjectionPoint injectionPoint) {
        assert (!this.injectionMap.containsKey(fullMethodName)) : "Duplicate method name loaded: " + fullMethodName;
        this.injectionMap.put(fullMethodName, injectionPoint);
    }

    private String getFullMethodName(InvokeInstruction invoke, ConstantPoolGen cpg) {
        return ClassName.toSlashedClassName((String)invoke.getReferenceType(cpg).toString()) + "." + invoke.getMethodName(cpg) + invoke.getSignature(cpg);
    }

    public void registerVisitor(TaintFrameAdditionalVisitor visitor) {
        TaintDataflowEngine.registerAdditionalVisitor(visitor);
    }
}

