/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.spring;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Location;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.LDC;

public class SpringUnvalidatedRedirectDetector
implements Detector {
    private static final String SPRING_UNVALIDATED_REDIRECT_TYPE = "SPRING_UNVALIDATED_REDIRECT";
    private static final List<String> REQUEST_MAPPING_ANNOTATION_TYPES = Arrays.asList("Lorg/springframework/web/bind/annotation/RequestMapping;", "Lorg/springframework/web/bind/annotation/GetMapping;", "Lorg/springframework/web/bind/annotation/PostMapping;", "Lorg/springframework/web/bind/annotation/PutMapping;", "Lorg/springframework/web/bind/annotation/DeleteMapping;", "Lorg/springframework/web/bind/annotation/PatchMapping;");
    private BugReporter reporter;

    public SpringUnvalidatedRedirectDetector(BugReporter bugReporter) {
        this.reporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass clazz = classContext.getJavaClass();
        if (this.hasRequestMapping(clazz)) {
            Method[] methods;
            for (Method m : methods = clazz.getMethods()) {
                try {
                    this.analyzeMethod(m, classContext);
                }
                catch (CFGBuilderException cFGBuilderException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean hasRequestMapping(JavaClass clazz) {
        Method[] methods;
        for (Method m : methods = clazz.getMethods()) {
            AnnotationEntry[] annotations;
            for (AnnotationEntry ae : annotations = m.getAnnotationEntries()) {
                if (!REQUEST_MAPPING_ANNOTATION_TYPES.contains(ae.getAnnotationType())) continue;
                return true;
            }
        }
        return false;
    }

    private void analyzeMethod(Method m, ClassContext classContext) throws CFGBuilderException {
        JavaClass clazz = classContext.getJavaClass();
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            String v;
            LDC ldc;
            Object value;
            Instruction prev;
            INVOKEVIRTUAL invoke;
            Location loc = (Location)i.next();
            Instruction inst = loc.getHandle().getInstruction();
            if (!(inst instanceof INVOKEVIRTUAL) || !"java.lang.StringBuilder".equals((invoke = (INVOKEVIRTUAL)inst).getClassName(cpg)) || !"append".equals(invoke.getMethodName(cpg)) || !((prev = loc.getHandle().getPrev().getInstruction()) instanceof LDC) || !((value = (ldc = (LDC)prev).getValue(cpg)) instanceof String) || !"redirect:".equals(v = (String)value)) continue;
            BugInstance bug = new BugInstance((Detector)this, SPRING_UNVALIDATED_REDIRECT_TYPE, 2);
            bug.addClass(clazz).addMethod(clazz, m).addSourceLine(classContext, m, loc);
            this.reporter.reportBug(bug);
        }
    }

    public void report() {
    }
}

