/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.Arrays;
import org.h2.message.DbException;
import org.h2.util.HashBase;

public class IntIntHashMap
extends HashBase {
    public static final int NOT_FOUND = -1;
    private static final int DELETED = 1;
    private int[] keys;
    private int[] values;
    private int zeroValue;

    public IntIntHashMap() {
        this(true);
    }

    public IntIntHashMap(boolean bl) {
        super(bl);
    }

    @Override
    protected void reset(int n) {
        super.reset(n);
        this.keys = new int[this.len];
        this.values = new int[this.len];
    }

    public void put(int n, int n2) {
        if (n == 0) {
            this.zeroKey = true;
            this.zeroValue = n2;
            return;
        }
        this.checkSizePut();
        this.internalPut(n, n2);
    }

    private void internalPut(int n, int n2) {
        int n3 = this.getIndex(n);
        int n4 = 1;
        int n5 = -1;
        do {
            int n6;
            if ((n6 = this.keys[n3]) == 0) {
                if (this.values[n3] != 1) {
                    if (n5 >= 0) {
                        n3 = n5;
                        --this.deletedCount;
                    }
                    ++this.size;
                    this.keys[n3] = n;
                    this.values[n3] = n2;
                    return;
                }
                if (n5 < 0) {
                    n5 = n3;
                }
            } else if (n6 == n) {
                this.values[n3] = n2;
                return;
            }
            n3 = n3 + n4++ & this.mask;
        } while (n4 <= this.len);
        throw DbException.getInternalError("hashmap is full");
    }

    public void remove(int n) {
        if (n == 0) {
            this.zeroKey = false;
            return;
        }
        this.checkSizeRemove();
        int n2 = this.getIndex(n);
        int n3 = 1;
        do {
            int n4;
            if ((n4 = this.keys[n2]) == n) {
                this.keys[n2] = 0;
                this.values[n2] = 1;
                ++this.deletedCount;
                --this.size;
                return;
            }
            if (n4 == 0 && this.values[n2] == 0) {
                return;
            }
            n2 = n2 + n3++ & this.mask;
        } while (n3 <= this.len);
    }

    @Override
    protected void rehash(int n) {
        int[] nArray = this.keys;
        int[] nArray2 = this.values;
        this.reset(n);
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 == 0) continue;
            this.internalPut(n2, nArray2[i]);
        }
    }

    public int get(int n) {
        if (n == 0) {
            return this.zeroKey ? this.zeroValue : -1;
        }
        int n2 = this.getIndex(n);
        int n3 = 1;
        do {
            int n4;
            if ((n4 = this.keys[n2]) == 0 && this.values[n2] == 0) {
                return -1;
            }
            if (n4 == n) {
                return this.values[n2];
            }
            n2 = n2 + n3++ & this.mask;
        } while (n3 <= this.len);
        return -1;
    }

    @Override
    public void clear() {
        if (this.autoShrink && this.level > 2) {
            this.reset(2);
        } else {
            Arrays.fill(this.keys, 0);
            Arrays.fill(this.values, 0);
            this.deletedCount = 0;
            this.size = 0;
        }
        this.zeroKey = false;
    }
}

