/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintActionType;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Domain;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Mode;
import org.h2.engine.QueryStatisticsData;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MetaIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.store.InDoubtTransaction;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableSynonym;
import org.h2.table.TableType;
import org.h2.table.TableView;
import org.h2.tools.Csv;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringIgnoreCase;

public class MetaTable
extends Table {
    public static final long ROW_COUNT_APPROXIMATION = 1000L;
    private static final String CHARACTER_SET_NAME = "Unicode";
    private static final int TABLES = 0;
    private static final int COLUMNS = 1;
    private static final int INDEXES = 2;
    private static final int TABLE_TYPES = 3;
    private static final int TYPE_INFO = 4;
    private static final int CATALOGS = 5;
    private static final int SETTINGS = 6;
    private static final int HELP = 7;
    private static final int SEQUENCES = 8;
    private static final int USERS = 9;
    private static final int ROLES = 10;
    private static final int RIGHTS = 11;
    private static final int FUNCTION_ALIASES = 12;
    private static final int SCHEMATA = 13;
    private static final int TABLE_PRIVILEGES = 14;
    private static final int COLUMN_PRIVILEGES = 15;
    private static final int COLLATIONS = 16;
    private static final int VIEWS = 17;
    private static final int IN_DOUBT = 18;
    private static final int CROSS_REFERENCES = 19;
    private static final int CONSTRAINTS = 20;
    private static final int FUNCTION_COLUMNS = 21;
    private static final int CONSTANTS = 22;
    private static final int DOMAINS = 23;
    private static final int TRIGGERS = 24;
    private static final int SESSIONS = 25;
    private static final int LOCKS = 26;
    private static final int SESSION_STATE = 27;
    private static final int QUERY_STATISTICS = 28;
    private static final int SYNONYMS = 29;
    private static final int TABLE_CONSTRAINTS = 30;
    private static final int KEY_COLUMN_USAGE = 31;
    private static final int REFERENTIAL_CONSTRAINTS = 32;
    private static final int META_TABLE_TYPE_COUNT = 33;
    private final int type;
    private final int indexColumn;
    private final MetaIndex metaIndex;

    public MetaTable(Schema schema, int n, int n2) {
        super(schema, n, null, true, true);
        Column[] columnArray;
        this.type = n2;
        String string = null;
        switch (n2) {
            case 0: {
                this.setMetaTableName("TABLES");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "TABLE_TYPE", "STORAGE_TYPE", "SQL", "REMARKS", "LAST_MODIFICATION BIGINT", "ID INT", "TYPE_NAME", "TABLE_CLASS", "ROW_COUNT_ESTIMATE BIGINT");
                string = "TABLE_NAME";
                break;
            }
            case 1: {
                this.setMetaTableName("COLUMNS");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "CHARACTER_MAXIMUM_LENGTH INT", "CHARACTER_OCTET_LENGTH INT", "NUMERIC_PRECISION INT", "NUMERIC_PRECISION_RADIX INT", "NUMERIC_SCALE INT", "DATETIME_PRECISION INT", "INTERVAL_TYPE", "INTERVAL_PRECISION INT", "CHARACTER_SET_NAME", "COLLATION_NAME", "TYPE_NAME", "NULLABLE INT", "IS_COMPUTED BIT", "SELECTIVITY INT", "CHECK_CONSTRAINT", "SEQUENCE_NAME", "REMARKS", "SOURCE_DATA_TYPE SMALLINT", "COLUMN_TYPE", "COLUMN_ON_UPDATE", "IS_VISIBLE");
                string = "TABLE_NAME";
                break;
            }
            case 2: {
                this.setMetaTableName("INDEXES");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "NON_UNIQUE BIT", "INDEX_NAME", "ORDINAL_POSITION SMALLINT", "COLUMN_NAME", "CARDINALITY INT", "PRIMARY_KEY BIT", "INDEX_TYPE_NAME", "IS_GENERATED BIT", "INDEX_TYPE SMALLINT", "ASC_OR_DESC", "PAGES INT", "FILTER_CONDITION", "REMARKS", "SQL", "ID INT", "SORT_TYPE INT", "CONSTRAINT_NAME", "INDEX_CLASS", "AFFINITY BIT");
                string = "TABLE_NAME";
                break;
            }
            case 3: {
                this.setMetaTableName("TABLE_TYPES");
                columnArray = this.createColumns("TYPE");
                break;
            }
            case 4: {
                this.setMetaTableName("TYPE_INFO");
                columnArray = this.createColumns("TYPE_NAME", "DATA_TYPE INT", "PRECISION INT", "PREFIX", "SUFFIX", "PARAMS", "AUTO_INCREMENT BIT", "MINIMUM_SCALE SMALLINT", "MAXIMUM_SCALE SMALLINT", "RADIX INT", "POS INT", "CASE_SENSITIVE BIT", "NULLABLE SMALLINT", "SEARCHABLE SMALLINT");
                break;
            }
            case 5: {
                this.setMetaTableName("CATALOGS");
                columnArray = this.createColumns("CATALOG_NAME");
                break;
            }
            case 6: {
                this.setMetaTableName("SETTINGS");
                columnArray = this.createColumns("NAME", "VALUE");
                break;
            }
            case 7: {
                this.setMetaTableName("HELP");
                columnArray = this.createColumns("ID INT", "SECTION", "TOPIC", "SYNTAX", "TEXT");
                break;
            }
            case 8: {
                this.setMetaTableName("SEQUENCES");
                columnArray = this.createColumns("SEQUENCE_CATALOG", "SEQUENCE_SCHEMA", "SEQUENCE_NAME", "CURRENT_VALUE BIGINT", "INCREMENT BIGINT", "IS_GENERATED BIT", "REMARKS", "CACHE BIGINT", "MIN_VALUE BIGINT", "MAX_VALUE BIGINT", "IS_CYCLE BIT", "ID INT");
                break;
            }
            case 9: {
                this.setMetaTableName("USERS");
                columnArray = this.createColumns("NAME", "ADMIN", "REMARKS", "ID INT");
                break;
            }
            case 10: {
                this.setMetaTableName("ROLES");
                columnArray = this.createColumns("NAME", "REMARKS", "ID INT");
                break;
            }
            case 11: {
                this.setMetaTableName("RIGHTS");
                columnArray = this.createColumns("GRANTEE", "GRANTEETYPE", "GRANTEDROLE", "RIGHTS", "TABLE_SCHEMA", "TABLE_NAME", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 12: {
                this.setMetaTableName("FUNCTION_ALIASES");
                columnArray = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "DATA_TYPE INT", "TYPE_NAME", "COLUMN_COUNT INT", "RETURNS_RESULT SMALLINT", "REMARKS", "ID INT", "SOURCE");
                break;
            }
            case 21: {
                this.setMetaTableName("FUNCTION_COLUMNS");
                columnArray = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "COLUMN_COUNT INT", "POS INT", "COLUMN_NAME", "DATA_TYPE INT", "TYPE_NAME", "PRECISION INT", "SCALE SMALLINT", "RADIX SMALLINT", "NULLABLE SMALLINT", "COLUMN_TYPE SMALLINT", "REMARKS", "COLUMN_DEFAULT");
                break;
            }
            case 13: {
                this.setMetaTableName("SCHEMATA");
                columnArray = this.createColumns("CATALOG_NAME", "SCHEMA_NAME", "SCHEMA_OWNER", "DEFAULT_CHARACTER_SET_NAME", "DEFAULT_COLLATION_NAME", "IS_DEFAULT BIT", "REMARKS", "ID INT");
                break;
            }
            case 14: {
                this.setMetaTableName("TABLE_PRIVILEGES");
                columnArray = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string = "TABLE_NAME";
                break;
            }
            case 15: {
                this.setMetaTableName("COLUMN_PRIVILEGES");
                columnArray = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string = "TABLE_NAME";
                break;
            }
            case 16: {
                this.setMetaTableName("COLLATIONS");
                columnArray = this.createColumns("NAME", "KEY");
                break;
            }
            case 17: {
                this.setMetaTableName("VIEWS");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "VIEW_DEFINITION", "CHECK_OPTION", "IS_UPDATABLE", "STATUS", "REMARKS", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 18: {
                this.setMetaTableName("IN_DOUBT");
                columnArray = this.createColumns("TRANSACTION", "STATE");
                break;
            }
            case 19: {
                this.setMetaTableName("CROSS_REFERENCES");
                columnArray = this.createColumns("PKTABLE_CATALOG", "PKTABLE_SCHEMA", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CATALOG", "FKTABLE_SCHEMA", "FKTABLE_NAME", "FKCOLUMN_NAME", "ORDINAL_POSITION SMALLINT", "UPDATE_RULE SMALLINT", "DELETE_RULE SMALLINT", "FK_NAME", "PK_NAME", "DEFERRABILITY SMALLINT");
                string = "PKTABLE_NAME";
                break;
            }
            case 20: {
                this.setMetaTableName("CONSTRAINTS");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "UNIQUE_INDEX_NAME", "CHECK_EXPRESSION", "COLUMN_LIST", "REMARKS", "SQL", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 22: {
                this.setMetaTableName("CONSTANTS");
                columnArray = this.createColumns("CONSTANT_CATALOG", "CONSTANT_SCHEMA", "CONSTANT_NAME", "DATA_TYPE INT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 23: {
                this.setMetaTableName("DOMAINS");
                columnArray = this.createColumns("DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "PRECISION INT", "SCALE INT", "TYPE_NAME", "SELECTIVITY INT", "CHECK_CONSTRAINT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 24: {
                this.setMetaTableName("TRIGGERS");
                columnArray = this.createColumns("TRIGGER_CATALOG", "TRIGGER_SCHEMA", "TRIGGER_NAME", "TRIGGER_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "BEFORE BIT", "JAVA_CLASS", "QUEUE_SIZE INT", "NO_WAIT BIT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 25: {
                this.setMetaTableName("SESSIONS");
                columnArray = this.createColumns("ID INT", "USER_NAME", "SESSION_START TIMESTAMP WITH TIME ZONE", "STATEMENT", "STATEMENT_START TIMESTAMP WITH TIME ZONE", "CONTAINS_UNCOMMITTED BIT", "STATE", "BLOCKER_ID INT");
                break;
            }
            case 26: {
                this.setMetaTableName("LOCKS");
                columnArray = this.createColumns("TABLE_SCHEMA", "TABLE_NAME", "SESSION_ID INT", "LOCK_TYPE");
                break;
            }
            case 27: {
                this.setMetaTableName("SESSION_STATE");
                columnArray = this.createColumns("KEY", "SQL");
                break;
            }
            case 28: {
                this.setMetaTableName("QUERY_STATISTICS");
                columnArray = this.createColumns("SQL_STATEMENT", "EXECUTION_COUNT INT", "MIN_EXECUTION_TIME DOUBLE", "MAX_EXECUTION_TIME DOUBLE", "CUMULATIVE_EXECUTION_TIME DOUBLE", "AVERAGE_EXECUTION_TIME DOUBLE", "STD_DEV_EXECUTION_TIME DOUBLE", "MIN_ROW_COUNT INT", "MAX_ROW_COUNT INT", "CUMULATIVE_ROW_COUNT LONG", "AVERAGE_ROW_COUNT DOUBLE", "STD_DEV_ROW_COUNT DOUBLE");
                break;
            }
            case 29: {
                this.setMetaTableName("SYNONYMS");
                columnArray = this.createColumns("SYNONYM_CATALOG", "SYNONYM_SCHEMA", "SYNONYM_NAME", "SYNONYM_FOR", "SYNONYM_FOR_SCHEMA", "TYPE_NAME", "STATUS", "REMARKS", "ID INT");
                string = "SYNONYM_NAME";
                break;
            }
            case 30: {
                this.setMetaTableName("TABLE_CONSTRAINTS");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "IS_DEFERRABLE", "INITIALLY_DEFERRED");
                string = "TABLE_NAME";
                break;
            }
            case 31: {
                this.setMetaTableName("KEY_COLUMN_USAGE");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "POSITION_IN_UNIQUE_CONSTRAINT INT");
                string = "TABLE_NAME";
                break;
            }
            case 32: {
                this.setMetaTableName("REFERENTIAL_CONSTRAINTS");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "UNIQUE_CONSTRAINT_CATALOG", "UNIQUE_CONSTRAINT_SCHEMA", "UNIQUE_CONSTRAINT_NAME", "MATCH_OPTION", "UPDATE_RULE", "DELETE_RULE");
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n2);
            }
        }
        this.setColumns(columnArray);
        if (string == null) {
            this.indexColumn = -1;
            this.metaIndex = null;
        } else {
            this.indexColumn = this.getColumn(this.database.sysIdentifier(string)).getColumnId();
            IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{columnArray[this.indexColumn]});
            this.metaIndex = new MetaIndex(this, indexColumnArray, false);
        }
    }

    private void setMetaTableName(String string) {
        this.setObjectName(this.database.sysIdentifier(string));
    }

    private Column[] createColumns(String ... stringArray) {
        Column[] columnArray = new Column[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n;
            String string2 = stringArray[i];
            int n2 = string2.indexOf(32);
            if (n2 < 0) {
                n = this.database.getMode().lowerCaseIdentifiers ? 14 : 13;
                string = string2;
            } else {
                n = DataType.getTypeByName((String)string2.substring((int)(n2 + 1)), (Mode)this.database.getMode()).type;
                string = string2.substring(0, n2);
            }
            columnArray[i] = new Column(this.database.sysIdentifier(string), n);
        }
        return columnArray;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public boolean lock(Session session, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    private String identifier(String string) {
        if (this.database.getMode().lowerCaseIdentifiers) {
            string = string == null ? null : StringUtils.toLowerEnglish(string);
        }
        return string;
    }

    private ArrayList<Table> getAllTables(Session session) {
        ArrayList<Table> arrayList = this.database.getAllTablesAndViews(true);
        ArrayList<Table> arrayList2 = session.getLocalTempTables();
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    private ArrayList<Table> getTablesByName(Session session, String string) {
        if (this.database.getMode().lowerCaseIdentifiers) {
            string = StringUtils.toUpperEnglish(string);
        }
        ArrayList<Table> arrayList = this.database.getTableOrViewByName(string);
        for (Table table : session.getLocalTempTables()) {
            if (!table.getName().equals(string)) continue;
            arrayList.add(table);
        }
        return arrayList;
    }

    private boolean checkIndex(Session session, String string, Value value, Value value2) {
        if (string == null || value == null && value2 == null) {
            return true;
        }
        Database database = session.getDatabase();
        Value value3 = this.database.getMode().lowerCaseIdentifiers ? ValueStringIgnoreCase.get(string) : ValueString.get(string);
        if (value != null && database.compare(value3, value) < 0) {
            return false;
        }
        return value2 == null || database.compare(value3, value2) <= 0;
    }

    private static String replaceNullWithEmpty(String string) {
        return string == null ? "" : string;
    }

    private boolean hideTable(Table table, Session session) {
        return table.isHidden() && session != this.database.getSystemSession();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public ArrayList<Row> generateRows(Session var1_1, SearchRow var2_2, SearchRow var3_3) {
        var4_4 = null;
        var5_5 = null;
        if (this.indexColumn >= 0) {
            if (var2_2 != null) {
                var4_4 = var2_2.getValue(this.indexColumn);
            }
            if (var3_3 != null) {
                var5_5 = var3_3.getValue(this.indexColumn);
            }
        }
        var6_6 = Utils.newSmallArrayList();
        var7_7 = this.identifier(this.database.getShortName());
        var8_8 = var1_1.getUser().isAdmin();
        switch (this.type) {
            case 0: {
                for (Table var10_40 : this.getAllTables(var1_1)) {
                    var11_75 = this.identifier(var10_40.getName());
                    if (!this.checkIndex(var1_1, var11_75, var4_4, var5_5) || this.hideTable(var10_40, var1_1)) continue;
                    var12_104 = var10_40.isTemporary() ? (var10_40.isGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY") : (var10_40.isPersistIndexes() != false ? "CACHED" : "MEMORY");
                    var13_130 = var10_40.getCreateSQL();
                    if (!var8_8 && var13_130 != null && var13_130.contains("--hide--")) {
                        var13_130 = "-";
                    }
                    this.add(var6_6, new Object[]{var7_7, this.identifier(var10_40.getSchema().getName()), var11_75, var10_40.getTableType().toString(), var12_104, var13_130, MetaTable.replaceNullWithEmpty(var10_40.getComment()), ValueLong.get(var10_40.getMaxDataModificationId()), ValueInt.get(var10_40.getId()), null, var10_40.getClass().getName(), ValueLong.get(var10_40.getRowCountApproximation())});
                }
                break;
            }
            case 1: {
                if (var4_4 != null && var4_4.equals(var5_5)) {
                    var10_41 = this.identifier(var4_4.getString());
                    if (var10_41 == null) break;
                    var9_10 = this.getTablesByName(var1_1, var10_41);
                } else {
                    var9_10 = this.getAllTables(var1_1);
                }
                for (Table var11_76 : var9_10) {
                    var12_105 = this.identifier(var11_76.getName());
                    if (!this.checkIndex(var1_1, var12_105, var4_4, var5_5) || this.hideTable(var11_76, var1_1)) continue;
                    var13_131 = var11_76.getColumns();
                    var14_150 = this.database.getCompareMode().getName();
                    for (var15_165 = 0; var15_165 < var13_131.length; ++var15_165) {
                        var16_176 = var13_131[var15_165];
                        var17_186 = var16_176.getDomain();
                        var18_196 = var16_176.getDataType();
                        var19_206 = ValueInt.get(var16_176.getPrecisionAsInt());
                        var20_213 = ValueInt.get(var16_176.getType().getScale());
                        var21_219 = var16_176.getSequence();
                        var23_228 = var18_196.type;
                        switch (var23_228) {
                            case 9: 
                            case 10: 
                            case 11: 
                            case 24: 
                            case 31: 
                            case 35: 
                            case 37: 
                            case 38: {
                                var22_224 = true;
                                break;
                            }
                            default: {
                                var22_224 = false;
                            }
                        }
                        var24_231 = DataType.isIntervalType(var23_228);
                        var25_233 = var16_176.getCreateSQLWithoutName();
                        this.add(var6_6, new Object[]{var7_7, this.identifier(var11_76.getSchema().getName()), var12_105, this.identifier(var16_176.getName()), ValueInt.get(var15_165 + 1), var17_186 != null ? var7_7 : null, var17_186 != null ? this.database.getMainSchema().getName() : null, var17_186 != null ? var17_186.getName() : null, var16_176.getDefaultSQL(), var16_176.isNullable() != false ? "YES" : "NO", ValueInt.get(var18_196.sqlType), var19_206, var19_206, var19_206, ValueInt.get(10), var20_213, var22_224 != false ? var20_213 : null, var24_231 != false ? var25_233.substring(9) : null, var24_231 != false ? var19_206 : null, "Unicode", var14_150, this.identifier(var24_231 != false ? "INTERVAL" : var18_196.name), ValueInt.get(var16_176.isNullable() != false ? 1 : 0), ValueBoolean.get(var16_176.getComputed()), ValueInt.get(var16_176.getSelectivity()), var16_176.getCheckConstraintSQL(var1_1, var16_176.getName()), var21_219 == null ? null : var21_219.getName(), MetaTable.replaceNullWithEmpty(var16_176.getComment()), null, var25_233, var16_176.getOnUpdateSQL(), ValueBoolean.get(var16_176.getVisible())});
                    }
                }
                break;
            }
            case 2: {
                if (var4_4 != null && var4_4.equals(var5_5)) {
                    var10_42 = this.identifier(var4_4.getString());
                    if (var10_42 == null) break;
                    var9_11 = this.getTablesByName(var1_1, var10_42);
                } else {
                    var9_11 = this.getAllTables(var1_1);
                }
                for (Table var11_77 : var9_11) {
                    var12_106 = this.identifier(var11_77.getName());
                    if (!this.checkIndex(var1_1, var12_106, var4_4, var5_5) || this.hideTable(var11_77, var1_1)) continue;
                    var13_132 = var11_77.getIndexes();
                    var14_151 = var11_77.getConstraints();
                    for (var15_166 = 0; var13_132 != null && var15_166 < var13_132.size(); ++var15_166) {
                        var16_177 = var13_132.get(var15_166);
                        if (var16_177.getCreateSQL() == null) continue;
                        var17_187 = null;
                        for (var18_198 = 0; var14_151 != null && var18_198 < var14_151.size(); ++var18_198) {
                            var19_207 = var14_151.get(var18_198);
                            if (!var19_207.usesIndex(var16_177)) continue;
                            if (var16_177.getIndexType().isPrimaryKey()) {
                                if (var19_207.getConstraintType() != Constraint.Type.PRIMARY_KEY) continue;
                                var17_187 = var19_207.getName();
                                continue;
                            }
                            var17_187 = var19_207.getName();
                        }
                        var18_197 = var16_177.getIndexColumns();
                        var19_207 = var16_177.getClass().getName();
                        for (var20_214 = 0; var20_214 < var18_197.length; ++var20_214) {
                            var21_220 = var18_197[var20_214];
                            var22_225 = var21_220.column;
                            this.add(var6_6, new Object[]{var7_7, this.identifier(var11_77.getSchema().getName()), var12_106, ValueBoolean.get(var16_177.getIndexType().isUnique() == false), this.identifier(var16_177.getName()), ValueShort.get((short)(var20_214 + 1)), this.identifier(var22_225.getName()), ValueInt.get(0), ValueBoolean.get(var16_177.getIndexType().isPrimaryKey()), var16_177.getIndexType().getSQL(), ValueBoolean.get(var16_177.getIndexType().getBelongsToConstraint()), ValueShort.get((short)3), (var21_220.sortType & 1) != 0 ? "D" : "A", ValueInt.get(0), "", MetaTable.replaceNullWithEmpty(var16_177.getComment()), var16_177.getCreateSQL(), ValueInt.get(var16_177.getId()), ValueInt.get(var21_220.sortType), var17_187, var19_207, ValueBoolean.get(var16_177.getIndexType().isAffinity())});
                        }
                    }
                }
                break;
            }
            case 3: {
                this.add(var6_6, new Object[]{TableType.TABLE.toString()});
                this.add(var6_6, new Object[]{TableType.TABLE_LINK.toString()});
                this.add(var6_6, new Object[]{TableType.SYSTEM_TABLE.toString()});
                this.add(var6_6, new Object[]{TableType.VIEW.toString()});
                this.add(var6_6, new Object[]{TableType.EXTERNAL_TABLE_ENGINE.toString()});
                break;
            }
            case 4: {
                for (DataType var10_43 : DataType.getTypes()) {
                    if (var10_43.hidden || var10_43.sqlType == 0) continue;
                    this.add(var6_6, new Object[]{var10_43.name, ValueInt.get(var10_43.sqlType), ValueInt.get(MathUtils.convertLongToInt(var10_43.maxPrecision)), var10_43.prefix, var10_43.suffix, var10_43.params, ValueBoolean.get(var10_43.autoIncrement), ValueShort.get((short)var10_43.minScale), ValueShort.get((short)var10_43.maxScale), var10_43.decimal != false ? ValueInt.get(10) : null, ValueInt.get(var10_43.sqlTypePos), ValueBoolean.get(var10_43.caseSensitive), ValueShort.get((short)1), ValueShort.get((short)3)});
                }
                break;
            }
            case 5: {
                this.add(var6_6, new Object[]{var7_7});
                break;
            }
            case 6: {
                var9_13 = this.database.getAllSettings().iterator();
                while (var9_13.hasNext()) {
                    var10_44 = var9_13.next();
                    var11_78 = var10_44.getStringValue();
                    if (var11_78 == null) {
                        var11_78 = Integer.toString(var10_44.getIntValue());
                    }
                    this.add(var6_6, new Object[]{this.identifier(var10_44.getName()), var11_78});
                }
                this.add(var6_6, new Object[]{"info.BUILD_ID", "198"});
                this.add(var6_6, new Object[]{"info.VERSION_MAJOR", "1"});
                this.add(var6_6, new Object[]{"info.VERSION_MINOR", "4"});
                this.add(var6_6, new Object[]{"info.VERSION", Constants.getFullVersion()});
                if (var8_8) {
                    for (Object var13_133 : var9_13 = new String[]{"java.runtime.version", "java.vm.name", "java.vendor", "os.name", "os.arch", "os.version", "sun.os.patch.level", "file.separator", "path.separator", "line.separator", "user.country", "user.language", "user.variant", "file.encoding"}) {
                        this.add(var6_6, new Object[]{"property." + (String)var13_133, Utils.getProperty((String)var13_133, "")});
                    }
                }
                this.add(var6_6, new Object[]{"EXCLUSIVE", this.database.getExclusiveSession() == null ? "FALSE" : "TRUE"});
                this.add(var6_6, new Object[]{"MODE", this.database.getMode().getName()});
                this.add(var6_6, new Object[]{"MULTI_THREADED", this.database.isMultiThreaded() != false ? "1" : "0"});
                this.add(var6_6, new Object[]{"QUERY_TIMEOUT", Integer.toString(var1_1.getQueryTimeout())});
                this.add(var6_6, new Object[]{"RETENTION_TIME", Integer.toString(this.database.getRetentionTime())});
                this.add(var6_6, new Object[]{"LOG", Integer.toString(this.database.getLogMode())});
                var9_13 = this.database.getSettings().getSettings();
                var10_44 = new ArrayList<E>(var9_13.size());
                var10_44.addAll(var9_13.keySet());
                Collections.sort(var10_44);
                var11_80 = var10_44.iterator();
                while (var11_80.hasNext()) {
                    var12_109 = (String)var11_80.next();
                    this.add(var6_6, new Object[]{var12_109, var9_13.get(var12_109)});
                }
                if (!this.database.isPersistent()) break;
                var11_80 = this.database.getPageStore();
                if (var11_80 != null) {
                    this.add(var6_6, new Object[]{"info.FILE_WRITE_TOTAL", Long.toString(var11_80.getWriteCountTotal())});
                    this.add(var6_6, new Object[]{"info.FILE_WRITE", Long.toString(var11_80.getWriteCount())});
                    this.add(var6_6, new Object[]{"info.FILE_READ", Long.toString(var11_80.getReadCount())});
                    this.add(var6_6, new Object[]{"info.PAGE_COUNT", Integer.toString(var11_80.getPageCount())});
                    this.add(var6_6, new Object[]{"info.PAGE_SIZE", Integer.toString(var11_80.getPageSize())});
                    this.add(var6_6, new Object[]{"info.CACHE_MAX_SIZE", Integer.toString(var11_80.getCache().getMaxMemory())});
                    this.add(var6_6, new Object[]{"info.CACHE_SIZE", Integer.toString(var11_80.getCache().getMemory())});
                }
                if ((var12_110 = this.database.getStore()) == null) break;
                var13_133 = var12_110.getMvStore();
                var14_152 = var13_133.getFileStore();
                this.add(var6_6, new Object[]{"info.FILE_WRITE", Long.toString(var14_152.getWriteCount())});
                this.add(var6_6, new Object[]{"info.FILE_READ", Long.toString(var14_152.getReadCount())});
                this.add(var6_6, new Object[]{"info.UPDATE_FAILURE_PERCENT", String.format(Locale.ENGLISH, "%.2f%%", new Object[]{100.0 * var13_133.getUpdateFailureRatio()})});
                try {
                    var15_167 = var14_152.getFile().size();
                }
                catch (IOException var17_188) {
                    throw DbException.convertIOException(var17_188, "Can not get size");
                }
                var17_189 = 4096;
                var18_199 = var15_167 / (long)var17_189;
                this.add(var6_6, new Object[]{"info.PAGE_COUNT", Long.toString(var18_199)});
                this.add(var6_6, new Object[]{"info.PAGE_SIZE", Integer.toString(var13_133.getPageSplitSize())});
                this.add(var6_6, new Object[]{"info.CACHE_MAX_SIZE", Integer.toString(var13_133.getCacheSize())});
                this.add(var6_6, new Object[]{"info.CACHE_SIZE", Integer.toString(var13_133.getCacheSizeUsed())});
                break;
            }
            case 7: {
                var9_14 = "/org/h2/res/help.csv";
                try {
                    var10_45 = Utils.getResource(var9_14);
                    var11_81 = new InputStreamReader(new ByteArrayInputStream(var10_45));
                    var12_111 = new Csv();
                    var12_111.setLineCommentCharacter('#');
                    var13_134 = var12_111.read(var11_81, null);
                    var14_153 = 0;
                    while (var13_134.next()) {
                        this.add(var6_6, new Object[]{ValueInt.get(var14_153), var13_134.getString(1).trim(), var13_134.getString(2).trim(), var13_134.getString(3).trim(), var13_134.getString(4).trim()});
                        ++var14_153;
                    }
                    break;
                }
                catch (Exception var10_46) {
                    throw DbException.convert(var10_46);
                }
            }
            case 8: {
                for (SchemaObject var10_47 : this.database.getAllSchemaObjects(3)) {
                    var11_82 = (Sequence)var10_47;
                    this.add(var6_6, new Object[]{var7_7, this.identifier(var11_82.getSchema().getName()), this.identifier(var11_82.getName()), ValueLong.get(var11_82.getCurrentValue()), ValueLong.get(var11_82.getIncrement()), ValueBoolean.get(var11_82.getBelongsToTable()), MetaTable.replaceNullWithEmpty(var11_82.getComment()), ValueLong.get(var11_82.getCacheSize()), ValueLong.get(var11_82.getMinValue()), ValueLong.get(var11_82.getMaxValue()), ValueBoolean.get(var11_82.getCycle()), ValueInt.get(var11_82.getId())});
                }
                break;
            }
            case 9: {
                for (User var10_48 : this.database.getAllUsers()) {
                    if (!var8_8 && var1_1.getUser() != var10_48) continue;
                    this.add(var6_6, new Object[]{this.identifier(var10_48.getName()), String.valueOf(var10_48.isAdmin()), MetaTable.replaceNullWithEmpty(var10_48.getComment()), ValueInt.get(var10_48.getId())});
                }
                break;
            }
            case 10: {
                for (Role var10_49 : this.database.getAllRoles()) {
                    if (!var8_8 && !var1_1.getUser().isRoleGranted(var10_49)) continue;
                    this.add(var6_6, new Object[]{this.identifier(var10_49.getName()), MetaTable.replaceNullWithEmpty(var10_49.getComment()), ValueInt.get(var10_49.getId())});
                }
                break;
            }
            case 11: {
                if (!var8_8) break;
                for (Right var10_50 : this.database.getAllRights()) {
                    var11_83 = var10_50.getGrantedRole();
                    var12_112 = var10_50.getGrantee();
                    v0 = var13_135 = var12_112.getType() == 2 ? "USER" : "ROLE";
                    if (var11_83 == null) {
                        var14_154 = var10_50.getGrantedObject();
                        var15_168 = null;
                        var16_178 = null;
                        if (var14_154 != null) {
                            if (var14_154 instanceof Schema) {
                                var15_168 = (Schema)var14_154;
                            } else if (var14_154 instanceof Table) {
                                var16_178 = (Table)var14_154;
                                var15_168 = var16_178.getSchema();
                            }
                        }
                        var17_190 = var16_178 != null ? this.identifier(var16_178.getName()) : "";
                        v1 = var18_200 = var15_168 != null ? this.identifier(var15_168.getName()) : "";
                        if (!this.checkIndex(var1_1, var17_190, var4_4, var5_5)) continue;
                        this.add(var6_6, new Object[]{this.identifier(var12_112.getName()), var13_135, "", var10_50.getRights(), var18_200, var17_190, ValueInt.get(var10_50.getId())});
                        continue;
                    }
                    this.add(var6_6, new Object[]{this.identifier(var12_112.getName()), var13_135, this.identifier(var11_83.getName()), "", "", "", ValueInt.get(var10_50.getId())});
                }
                break;
            }
            case 12: {
                for (DbObject var10_51 : this.database.getAllSchemaObjects(9)) {
                    var11_84 = (FunctionAlias)var10_51;
                    try {
                        var12_113 = var11_84.getJavaMethods();
                    }
                    catch (DbException var13_137) {
                        var12_113 = new FunctionAlias.JavaMethod[]{};
                    }
                    for (FunctionAlias.JavaMethod var16_179 : var12_113) {
                        this.add(var6_6, new Object[]{var7_7, var11_84.getSchema().getName(), this.identifier(var11_84.getName()), var11_84.getJavaClassName(), var11_84.getJavaMethodName(), ValueInt.get(DataType.convertTypeToSQLType(var16_179.getDataType())), DataType.getDataType((int)var16_179.getDataType()).name, ValueInt.get(var16_179.getParameterCount()), ValueShort.get(var16_179.getDataType() == 0 ? 1 : 2), MetaTable.replaceNullWithEmpty(var11_84.getComment()), ValueInt.get(var11_84.getId()), var11_84.getSource()});
                    }
                }
                for (DbObject var10_51 : this.database.getAllAggregates()) {
                    this.add(var6_6, new Object[]{var7_7, this.database.getMainSchema().getName(), this.identifier(var10_51.getName()), var10_51.getJavaClassName(), "", ValueInt.get(0), DataType.getDataType((int)0).name, ValueInt.get(1), ValueShort.get((short)2), MetaTable.replaceNullWithEmpty(var10_51.getComment()), ValueInt.get(var10_51.getId()), ""});
                }
                break;
            }
            case 21: {
                for (SchemaObject var10_52 : this.database.getAllSchemaObjects(9)) {
                    var11_85 = (FunctionAlias)var10_52;
                    try {
                        var12_114 = var11_85.getJavaMethods();
                    }
                    catch (DbException var13_139) {
                        var12_114 = new FunctionAlias.JavaMethod[]{};
                    }
                    for (FunctionAlias.JavaMethod var16_180 : var12_114) {
                        if (var16_180.getDataType() != 0) {
                            var17_191 /* !! */  = DataType.getDataType(var16_180.getDataType());
                            this.add(var6_6, new Object[]{var7_7, var11_85.getSchema().getName(), this.identifier(var11_85.getName()), var11_85.getJavaClassName(), var11_85.getJavaMethodName(), ValueInt.get(var16_180.getParameterCount()), ValueInt.get(0), "P0", ValueInt.get(DataType.convertTypeToSQLType(var16_180.getDataType())), var17_191 /* !! */ .name, ValueInt.get(MathUtils.convertLongToInt(var17_191 /* !! */ .defaultPrecision)), ValueShort.get((short)var17_191 /* !! */ .defaultScale), ValueShort.get((short)10), ValueShort.get((short)2), ValueShort.get((short)5), "", null});
                        }
                        var17_191 /* !! */  = var16_180.getColumnClasses();
                        for (var18_201 = 0; var18_201 < var17_191 /* !! */ .length; ++var18_201) {
                            if (var16_180.hasConnectionParam() && var18_201 == 0) continue;
                            var19_208 = var17_191 /* !! */ [var18_201];
                            var20_215 = DataType.getTypeFromClass(var19_208);
                            var21_221 = DataType.getDataType(var20_215);
                            this.add(var6_6, new Object[]{var7_7, var11_85.getSchema().getName(), this.identifier(var11_85.getName()), var11_85.getJavaClassName(), var11_85.getJavaMethodName(), ValueInt.get(var16_180.getParameterCount()), ValueInt.get(var18_201 + (var16_180.hasConnectionParam() != false ? 0 : 1)), "P" + (var18_201 + 1), ValueInt.get(DataType.convertTypeToSQLType(var21_221.type)), var21_221.name, ValueInt.get(MathUtils.convertLongToInt(var21_221.defaultPrecision)), ValueShort.get((short)var21_221.defaultScale), ValueShort.get((short)10), ValueShort.get(var19_208.isPrimitive() != false ? 0 : 1), ValueShort.get((short)1), "", null});
                        }
                    }
                }
                break;
            }
            case 13: {
                var9_21 = this.database.getCompareMode().getName();
                for (Schema var11_86 : this.database.getAllSchemas()) {
                    this.add(var6_6, new Object[]{var7_7, this.identifier(var11_86.getName()), this.identifier(var11_86.getOwner().getName()), "Unicode", var9_21, ValueBoolean.get(var11_86.getId() == 0), MetaTable.replaceNullWithEmpty(var11_86.getComment()), ValueInt.get(var11_86.getId())});
                }
                break;
            }
            case 14: {
                for (Right var10_54 : this.database.getAllRights()) {
                    var11_87 = var10_54.getGrantedObject();
                    if (!(var11_87 instanceof Table) || this.hideTable(var12_115 = (Table)var11_87, var1_1) || !this.checkIndex(var1_1, var13_140 = this.identifier(var12_115.getName()), var4_4, var5_5)) continue;
                    this.addPrivileges(var6_6, var10_54.getGrantee(), var7_7, var12_115, null, var10_54.getRightMask());
                }
                break;
            }
            case 15: {
                for (Right var10_55 : this.database.getAllRights()) {
                    var11_88 = var10_55.getGrantedObject();
                    if (!(var11_88 instanceof Table) || this.hideTable(var12_116 = (Table)var11_88, var1_1) || !this.checkIndex(var1_1, var13_141 = this.identifier(var12_116.getName()), var4_4, var5_5)) continue;
                    var14_157 = var10_55.getGrantee();
                    var15_171 = var10_55.getRightMask();
                    for (Column var19_209 : var12_116.getColumns()) {
                        this.addPrivileges(var6_6, var14_157, var7_7, var12_116, var19_209.getName(), var15_171);
                    }
                }
                break;
            }
            case 16: {
                for (Locale var12_117 : Collator.getAvailableLocales()) {
                    this.add(var6_6, new Object[]{CompareMode.getName(var12_117), var12_117.toString()});
                }
                break;
            }
            case 17: {
                for (Table var10_57 : this.getAllTables(var1_1)) {
                    if (var10_57.getTableType() != TableType.VIEW || !this.checkIndex(var1_1, var11_90 = this.identifier(var10_57.getName()), var4_4, var5_5)) continue;
                    var12_118 = (TableView)var10_57;
                    this.add(var6_6, new Object[]{var7_7, this.identifier(var10_57.getSchema().getName()), var11_90, var10_57.getCreateSQL(), "NONE", "NO", var12_118.isInvalid() != false ? "INVALID" : "VALID", MetaTable.replaceNullWithEmpty(var12_118.getComment()), ValueInt.get(var12_118.getId())});
                }
                break;
            }
            case 18: {
                var9_26 = this.database.getInDoubtTransactions();
                if (var9_26 == null || !var8_8) break;
                for (InDoubtTransaction var11_91 : var9_26) {
                    this.add(var6_6, new Object[]{var11_91.getTransactionName(), var11_91.getState()});
                }
                break;
            }
            case 19: {
                for (SchemaObject var10_59 : this.database.getAllSchemaObjects(5)) {
                    var11_92 = (Constraint)var10_59;
                    if (var11_92.getConstraintType() != Constraint.Type.REFERENTIAL) continue;
                    var12_119 = (ConstraintReferential)var11_92;
                    var13_142 = var12_119.getColumns();
                    var14_158 = var12_119.getRefColumns();
                    var15_172 = var12_119.getTable();
                    var16_182 = var12_119.getRefTable();
                    var17_193 = this.identifier(var16_182.getName());
                    if (!this.checkIndex(var1_1, var17_193, var4_4, var5_5)) continue;
                    var18_203 = ValueShort.get(MetaTable.getRefAction(var12_119.getUpdateAction()));
                    var19_210 = ValueShort.get(MetaTable.getRefAction(var12_119.getDeleteAction()));
                    for (var20_216 = 0; var20_216 < var13_142.length; ++var20_216) {
                        this.add(var6_6, new Object[]{var7_7, this.identifier(var16_182.getSchema().getName()), this.identifier(var16_182.getName()), this.identifier(var14_158[var20_216].column.getName()), var7_7, this.identifier(var15_172.getSchema().getName()), this.identifier(var15_172.getName()), this.identifier(var13_142[var20_216].column.getName()), ValueShort.get((short)(var20_216 + 1)), var18_203, var19_210, this.identifier(var12_119.getName()), this.identifier(var12_119.getUniqueIndex().getName()), ValueShort.get((short)7)});
                    }
                }
                break;
            }
            case 20: {
                for (SchemaObject var10_60 : this.database.getAllSchemaObjects(5)) {
                    var11_93 = (Constraint)var10_60;
                    var12_120 = var11_93.getConstraintType();
                    var13_143 = null;
                    var14_159 = null;
                    var15_173 = var11_93.getTable();
                    if (this.hideTable(var15_173, var1_1)) continue;
                    var16_183 = var11_93.getUniqueIndex();
                    var17_194 = null;
                    if (var16_183 != null) {
                        var17_194 = var16_183.getName();
                    }
                    if (!this.checkIndex(var1_1, var18_204 = this.identifier(var15_173.getName()), var4_4, var5_5)) continue;
                    if (var12_120 == Constraint.Type.CHECK) {
                        var13_143 = ((ConstraintCheck)var11_93).getExpression().getSQL();
                    } else if (var12_120 == Constraint.Type.UNIQUE || var12_120 == Constraint.Type.PRIMARY_KEY) {
                        var14_159 = ((ConstraintUnique)var11_93).getColumns();
                    } else if (var12_120 == Constraint.Type.REFERENTIAL) {
                        var14_159 = ((ConstraintReferential)var11_93).getColumns();
                    }
                    var19_211 = null;
                    if (var14_159 != null) {
                        var20_217 = new StatementBuilder();
                        for (IndexColumn var24_232 : var14_159) {
                            var20_217.appendExceptFirst(",");
                            var20_217.append(var24_232.column.getName());
                        }
                        var19_211 = var20_217.toString();
                    }
                    this.add(var6_6, new Object[]{var7_7, this.identifier(var11_93.getSchema().getName()), this.identifier(var11_93.getName()), var12_120 == Constraint.Type.PRIMARY_KEY ? var12_120.getSqlName() : var12_120.name(), var7_7, this.identifier(var15_173.getSchema().getName()), var18_204, var17_194, var13_143, var19_211, MetaTable.replaceNullWithEmpty(var11_93.getComment()), var11_93.getCreateSQL(), ValueInt.get(var11_93.getId())});
                }
                break;
            }
            case 22: {
                for (SchemaObject var10_61 : this.database.getAllSchemaObjects(11)) {
                    var11_94 = (Constant)var10_61;
                    var12_121 = var11_94.getValue();
                    this.add(var6_6, new Object[]{var7_7, this.identifier(var11_94.getSchema().getName()), this.identifier(var11_94.getName()), ValueInt.get(DataType.convertTypeToSQLType(var12_121.getType().getValueType())), MetaTable.replaceNullWithEmpty(var11_94.getComment()), var12_121.getSQL(), ValueInt.get(var11_94.getId())});
                }
                break;
            }
            case 23: {
                for (Domain var10_62 : this.database.getAllDomains()) {
                    var11_95 = var10_62.getColumn();
                    this.add(var6_6, new Object[]{var7_7, this.database.getMainSchema().getName(), this.identifier(var10_62.getName()), var11_95.getDefaultSQL(), var11_95.isNullable() != false ? "YES" : "NO", ValueInt.get(var11_95.getDataType().sqlType), ValueInt.get(var11_95.getPrecisionAsInt()), ValueInt.get(var11_95.getType().getScale()), var11_95.getDataType().name, ValueInt.get(var11_95.getSelectivity()), var11_95.getCheckConstraintSQL(var1_1, "VALUE"), MetaTable.replaceNullWithEmpty(var10_62.getComment()), var10_62.getCreateSQL(), ValueInt.get(var10_62.getId())});
                }
                break;
            }
            case 24: {
                for (SchemaObject var10_63 : this.database.getAllSchemaObjects(4)) {
                    var11_96 = (TriggerObject)var10_63;
                    var12_122 = var11_96.getTable();
                    this.add(var6_6, new Object[]{var7_7, this.identifier(var11_96.getSchema().getName()), this.identifier(var11_96.getName()), var11_96.getTypeNameList(), var7_7, this.identifier(var12_122.getSchema().getName()), this.identifier(var12_122.getName()), ValueBoolean.get(var11_96.isBefore()), var11_96.getTriggerClassName(), ValueInt.get(var11_96.getQueueSize()), ValueBoolean.get(var11_96.isNoWait()), MetaTable.replaceNullWithEmpty(var11_96.getComment()), var11_96.getCreateSQL(), ValueInt.get(var11_96.getId())});
                }
                break;
            }
            case 25: {
                for (Session var12_123 : this.database.getSessions(false)) {
                    if (!var8_8 && var12_123 != var1_1) continue;
                    var13_144 = var12_123.getCurrentCommand();
                    var14_160 = var12_123.getBlockingSessionId();
                    this.add(var6_6, new Object[]{ValueInt.get(var12_123.getId()), var12_123.getUser().getName(), DateTimeUtils.timestampTimeZoneFromMillis(var12_123.getSessionStart()), var13_144 == null ? null : var13_144.toString(), var13_144 == null ? null : var12_123.getCurrentCommandStart(), ValueBoolean.get(var12_123.containsUncommitted()), String.valueOf((Object)var12_123.getState()), var14_160 == 0 ? null : ValueInt.get(var14_160)});
                }
                break;
            }
            case 26: {
                for (Session var12_124 : this.database.getSessions(false)) {
                    if (!var8_8 && var12_124 != var1_1) continue;
                    for (Table var16_184 : var12_124.getLocks()) {
                        this.add(var6_6, new Object[]{var16_184.getSchema().getName(), var16_184.getName(), ValueInt.get(var12_124.getId()), var16_184.isLockedExclusivelyBy(var12_124) != false ? "WRITE" : "READ"});
                    }
                }
                break;
            }
            case 27: {
                for (String var12_125 : var1_1.getVariableNames()) {
                    var13_146 = var1_1.getVariable(var12_125);
                    var14_162 = new StringBuilder().append("SET @").append(var12_125).append(' ');
                    var13_146.getSQL(var14_162);
                    this.add(var6_6, new Object[]{"@" + var12_125, var14_162.toString()});
                }
                for (Table var10_67 : var1_1.getLocalTempTables()) {
                    this.add(var6_6, new Object[]{"TABLE " + var10_67.getName(), var10_67.getCreateSQL()});
                }
                var9_34 = var1_1.getSchemaSearchPath();
                if (var9_34 != null && var9_34.length > 0) {
                    var10_68 = new StringBuilder("SET SCHEMA_SEARCH_PATH ");
                    var12_126 = var9_34.length;
                    for (var11_99 = 0; var11_99 < var12_126; ++var11_99) {
                        if (var11_99 > 0) {
                            var10_68.append(", ");
                        }
                        StringUtils.quoteIdentifier(var10_68, (String)var9_34[var11_99]);
                    }
                    this.add(var6_6, new Object[]{"SCHEMA_SEARCH_PATH", var10_68.toString()});
                }
                if ((var10_69 = var1_1.getCurrentSchemaName()) == null) break;
                this.add(var6_6, new Object[]{"SCHEMA", StringUtils.quoteIdentifier(new StringBuilder("SET SCHEMA "), var10_69).toString()});
                break;
            }
            case 28: {
                var9_35 = this.database.getQueryStatisticsData();
                if (var9_35 == null) break;
                for (QueryStatisticsData.QueryEntry var11_100 : var9_35.getQueries()) {
                    this.add(var6_6, new Object[]{var11_100.sqlStatement, ValueInt.get(var11_100.count), ValueDouble.get((double)var11_100.executionTimeMinNanos / 1000000.0), ValueDouble.get((double)var11_100.executionTimeMaxNanos / 1000000.0), ValueDouble.get((double)var11_100.executionTimeCumulativeNanos / 1000000.0), ValueDouble.get(var11_100.executionTimeMeanNanos / 1000000.0), ValueDouble.get(var11_100.getExecutionTimeStandardDeviation() / 1000000.0), ValueInt.get(var11_100.rowCountMin), ValueInt.get(var11_100.rowCountMax), ValueLong.get(var11_100.rowCountCumulative), ValueDouble.get(var11_100.rowCountMean), ValueDouble.get(var11_100.getRowCountStandardDeviation())});
                }
                break;
            }
            case 29: {
                for (TableSynonym var10_71 : this.database.getAllSynonyms()) {
                    this.add(var6_6, new Object[]{var7_7, this.identifier(var10_71.getSchema().getName()), this.identifier(var10_71.getName()), var10_71.getSynonymForName(), var10_71.getSynonymForSchema().getName(), "SYNONYM", "VALID", MetaTable.replaceNullWithEmpty(var10_71.getComment()), ValueInt.get(var10_71.getId())});
                }
                break;
            }
            case 30: {
                for (SchemaObject var10_72 : this.database.getAllSchemaObjects(5)) {
                    var11_101 = (Constraint)var10_72;
                    var12_127 = var11_101.getConstraintType();
                    var13_147 = var11_101.getTable();
                    if (this.hideTable(var13_147, var1_1) || !this.checkIndex(var1_1, var14_163 = this.identifier(var13_147.getName()), var4_4, var5_5)) continue;
                    this.add(var6_6, new Object[]{var7_7, this.identifier(var11_101.getSchema().getName()), this.identifier(var11_101.getName()), var12_127.getSqlName(), var7_7, this.identifier(var13_147.getSchema().getName()), var14_163, "NO", "NO"});
                }
                break;
            }
            case 31: {
                for (SchemaObject var10_73 : this.database.getAllSchemaObjects(5)) {
                    var11_102 = (Constraint)var10_73;
                    var12_128 = var11_102.getConstraintType();
                    var13_148 = null;
                    var14_164 = var11_102.getTable();
                    if (this.hideTable(var14_164, var1_1) || !this.checkIndex(var1_1, var15_175 = this.identifier(var14_164.getName()), var4_4, var5_5)) continue;
                    if (var12_128 == Constraint.Type.UNIQUE || var12_128 == Constraint.Type.PRIMARY_KEY) {
                        var13_148 = ((ConstraintUnique)var11_102).getColumns();
                    } else if (var12_128 == Constraint.Type.REFERENTIAL) {
                        var13_148 = ((ConstraintReferential)var11_102).getColumns();
                    }
                    if (var13_148 == null) continue;
                    var16_185 = var12_128 == Constraint.Type.REFERENTIAL ? MetaTable.lookupUniqueForReferential((ConstraintReferential)var11_102) : null;
                    for (var17_195 = 0; var17_195 < var13_148.length; ++var17_195) {
                        var18_205 = var13_148[var17_195];
                        var19_212 = ValueInt.get(var17_195 + 1);
                        if (var12_128 != Constraint.Type.REFERENTIAL) ** GOTO lbl470
                        var20_218 = var19_212;
                        if (var16_185 == null) ** GOTO lbl471
                        var21_223 = ((ConstraintReferential)var11_102).getRefColumns()[var17_195].column;
                        var22_227 = var16_185.getColumns();
                        for (var23_230 = 0; var23_230 < var22_227.length; ++var23_230) {
                            if (!var22_227[var23_230].column.equals(var21_223)) continue;
                            var20_218 = ValueInt.get(var23_230 + 1);
                            ** GOTO lbl471
                        }
                        ** GOTO lbl471
lbl470:
                        // 1 sources

                        var20_218 = null;
lbl471:
                        // 4 sources

                        this.add(var6_6, new Object[]{var7_7, this.identifier(var11_102.getSchema().getName()), this.identifier(var11_102.getName()), var7_7, this.identifier(var14_164.getSchema().getName()), var15_175, var18_205.columnName, var19_212, var20_218});
                    }
                }
                break;
            }
            case 32: {
                for (SchemaObject var10_74 : this.database.getAllSchemaObjects(5)) {
                    if (((Constraint)var10_74).getConstraintType() != Constraint.Type.REFERENTIAL || this.hideTable(var12_129 = (var11_103 = (ConstraintReferential)var10_74).getTable(), var1_1)) continue;
                    var13_149 = MetaTable.lookupUniqueForReferential(var11_103);
                    if (var13_149 == null) {
                        var13_149 = var11_103.getUniqueIndex();
                    }
                    this.add(var6_6, new Object[]{var7_7, this.identifier(var11_103.getSchema().getName()), this.identifier(var11_103.getName()), var7_7, this.identifier(var13_149.getSchema().getName()), var13_149.getName(), "NONE", var11_103.getUpdateAction().getSqlName(), var11_103.getDeleteAction().getSqlName()});
                }
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return var6_6;
    }

    private static short getRefAction(ConstraintActionType constraintActionType) {
        switch (constraintActionType) {
            case CASCADE: {
                return 0;
            }
            case RESTRICT: {
                return 1;
            }
            case SET_DEFAULT: {
                return 4;
            }
            case SET_NULL: {
                return 2;
            }
        }
        throw DbException.throwInternalError("action=" + (Object)((Object)constraintActionType));
    }

    private static ConstraintUnique lookupUniqueForReferential(ConstraintReferential constraintReferential) {
        Table table = constraintReferential.getRefTable();
        for (Constraint constraint : table.getConstraints()) {
            ConstraintUnique constraintUnique;
            if (constraint.getConstraintType() != Constraint.Type.UNIQUE || !(constraintUnique = (ConstraintUnique)constraint).getReferencedColumns(table).equals(constraintReferential.getReferencedColumns(table))) continue;
            return constraintUnique;
        }
        return null;
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session session) {
    }

    private void addPrivileges(ArrayList<Row> arrayList, DbObject dbObject, String string, Table table, String string2, int n) {
        if ((n & 1) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "SELECT");
        }
        if ((n & 4) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "INSERT");
        }
        if ((n & 8) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "UPDATE");
        }
        if ((n & 2) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "DELETE");
        }
    }

    private void addPrivilege(ArrayList<Row> arrayList, DbObject dbObject, String string, Table table, String string2, String string3) {
        User user;
        String string4 = "NO";
        if (dbObject.getType() == 2 && (user = (User)dbObject).isAdmin()) {
            string4 = "YES";
        }
        if (string2 == null) {
            this.add(arrayList, null, this.identifier(dbObject.getName()), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), string3, string4);
        } else {
            this.add(arrayList, null, this.identifier(dbObject.getName()), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), this.identifier(string2), string3, string4);
        }
    }

    private void add(ArrayList<Row> arrayList, Object ... objectArray) {
        Value[] valueArray = new Value[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            ValueNull valueNull = object == null ? ValueNull.INSTANCE : (object instanceof String ? ValueString.get((String)object) : (Value)object);
            valueArray[i] = this.columns[i].convert(valueNull);
        }
        Row row = this.database.createRow(valueArray, 1);
        row.setKey(arrayList.size());
        arrayList.add(row);
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public long getRowCount(Session session) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public TableType getTableType() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Index getScanIndex(Session session) {
        return new MetaIndex(this, IndexColumn.wrap(this.columns), true);
    }

    @Override
    public ArrayList<Index> getIndexes() {
        ArrayList<Index> arrayList = new ArrayList<Index>(2);
        if (this.metaIndex == null) {
            return arrayList;
        }
        arrayList.add(new MetaIndex(this, IndexColumn.wrap(this.columns), true));
        arrayList.add(this.metaIndex);
        return arrayList;
    }

    @Override
    public long getMaxDataModificationId() {
        switch (this.type) {
            case 6: 
            case 18: 
            case 25: 
            case 26: 
            case 27: {
                return Long.MAX_VALUE;
            }
        }
        return this.database.getModificationDataId();
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    public static int getMetaTableTypeCount() {
        return 33;
    }

    @Override
    public long getRowCountApproximation() {
        return 1000L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean canReference() {
        return false;
    }
}

