/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.IntervalOperation;
import org.h2.expression.UnaryOperation;
import org.h2.expression.ValueExpression;
import org.h2.expression.function.Function;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class BinaryOperation
extends Expression {
    private OpType opType;
    private Expression left;
    private Expression right;
    private TypeInfo type;
    private boolean convertRight = true;

    public BinaryOperation(OpType opType, Expression expression, Expression expression2) {
        this.opType = opType;
        this.left = expression;
        this.right = expression2;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        stringBuilder.append('(');
        this.left.getSQL(stringBuilder).append(' ').append(this.getOperationToken()).append(' ');
        return this.right.getSQL(stringBuilder).append(')');
    }

    private String getOperationToken() {
        switch (this.opType) {
            case CONCAT: {
                return "||";
            }
            case PLUS: {
                return "+";
            }
            case MINUS: {
                return "-";
            }
            case MULTIPLY: {
                return "*";
            }
            case DIVIDE: {
                return "/";
            }
            case MODULUS: {
                return "%";
            }
        }
        throw DbException.throwInternalError("opType=" + (Object)((Object)this.opType));
    }

    @Override
    public Value getValue(Session session) {
        Mode mode = session.getDatabase().getMode();
        Value value = this.left.getValue(session).convertTo(this.type, mode, null);
        Value value2 = this.right.getValue(session);
        if (this.convertRight) {
            value2 = value2.convertTo(this.type, mode, null);
        }
        switch (this.opType) {
            case CONCAT: {
                if (value == ValueNull.INSTANCE) {
                    if (mode.nullConcatIsNull) {
                        return ValueNull.INSTANCE;
                    }
                    return value2;
                }
                if (value2 == ValueNull.INSTANCE) {
                    if (mode.nullConcatIsNull) {
                        return ValueNull.INSTANCE;
                    }
                    return value;
                }
                String string = value.getString();
                String string2 = value2.getString();
                StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length());
                stringBuilder.append(string).append(string2);
                return ValueString.get(stringBuilder.toString());
            }
            case PLUS: {
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value.add(value2);
            }
            case MINUS: {
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value.subtract(value2);
            }
            case MULTIPLY: {
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value.multiply(value2);
            }
            case DIVIDE: {
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value.divide(value2);
            }
            case MODULUS: {
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value.modulus(value2);
            }
        }
        throw DbException.throwInternalError("type=" + (Object)((Object)this.opType));
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.left.mapColumns(columnResolver, n, n2);
        this.right.mapColumns(columnResolver, n, n2);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        switch (this.opType) {
            case CONCAT: {
                long l;
                TypeInfo typeInfo = this.left.getType();
                TypeInfo typeInfo2 = this.right.getType();
                if (DataType.isStringType(typeInfo.getValueType()) && DataType.isStringType(typeInfo2.getValueType()) && (l = typeInfo.getPrecision() + typeInfo2.getPrecision()) >= 0L && l < Integer.MAX_VALUE) {
                    this.type = TypeInfo.getTypeInfo(13, l, 0, null);
                    break;
                }
                this.type = TypeInfo.TYPE_STRING;
                break;
            }
            case PLUS: 
            case MINUS: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULUS: {
                int n = this.left.getType().getValueType();
                int n2 = this.right.getType().getValueType();
                if (n == 0 && n2 == 0 || n == -1 && n2 == -1) {
                    if (this.opType == OpType.PLUS && session.getDatabase().getMode().allowPlusForStringConcat) {
                        this.type = TypeInfo.TYPE_STRING;
                        this.opType = OpType.CONCAT;
                        break;
                    }
                    this.type = TypeInfo.TYPE_DECIMAL_DEFAULT;
                    break;
                }
                if (DataType.isIntervalType(n) || DataType.isIntervalType(n2)) {
                    return this.optimizeInterval(session, n, n2);
                }
                if (DataType.isDateTimeType(n) || DataType.isDateTimeType(n2)) {
                    return this.optimizeDateTime(session, n, n2);
                }
                int n3 = Value.getHigherOrder(n, n2);
                if (n3 == 25) {
                    this.type = TypeInfo.TYPE_INT;
                    break;
                }
                this.type = TypeInfo.getTypeInfo(n3);
                if (!DataType.isStringType(n3) || !session.getDatabase().getMode().allowPlusForStringConcat) break;
                this.opType = OpType.CONCAT;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.opType));
            }
        }
        if (this.left.isConstant() && this.right.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    private Expression optimizeInterval(Session session, int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (DataType.isIntervalType(n)) {
            bl = true;
        } else if (DataType.isNumericType(n)) {
            bl2 = true;
        } else if (DataType.isDateTimeType(n)) {
            bl3 = true;
        } else {
            throw this.getUnsupported(n, n2);
        }
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (DataType.isIntervalType(n2)) {
            bl4 = true;
        } else if (DataType.isNumericType(n2)) {
            bl5 = true;
        } else if (DataType.isDateTimeType(n2)) {
            bl6 = true;
        } else {
            throw this.getUnsupported(n, n2);
        }
        switch (this.opType) {
            case PLUS: {
                if (bl && bl4) {
                    if (DataType.isYearMonthIntervalType(n) != DataType.isYearMonthIntervalType(n2)) break;
                    return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_PLUS_INTERVAL, this.left, this.right);
                }
                if (bl && bl6) {
                    if (n2 == 9 && DataType.isYearMonthIntervalType(n)) break;
                    return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_PLUS_INTERVAL, this.right, this.left);
                }
                if (!bl3 || !bl4 || n == 9 && DataType.isYearMonthIntervalType(n2)) break;
                return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_PLUS_INTERVAL, this.left, this.right);
            }
            case MINUS: {
                if (bl && bl4) {
                    if (DataType.isYearMonthIntervalType(n) != DataType.isYearMonthIntervalType(n2)) break;
                    return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_MINUS_INTERVAL, this.left, this.right);
                }
                if (!bl3 || !bl4 || n == 9 && DataType.isYearMonthIntervalType(n2)) break;
                return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_MINUS_INTERVAL, this.left, this.right);
            }
            case MULTIPLY: {
                if (bl && bl5) {
                    return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_MULTIPLY_NUMERIC, this.left, this.right);
                }
                if (!bl2 || !bl4) break;
                return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_MULTIPLY_NUMERIC, this.right, this.left);
            }
            case DIVIDE: {
                if (!bl || !bl5) break;
                return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_DIVIDE_NUMERIC, this.left, this.right);
            }
        }
        throw this.getUnsupported(n, n2);
    }

    private Expression optimizeDateTime(Session session, int n, int n2) {
        switch (this.opType) {
            case PLUS: {
                if (n2 != Value.getHigherOrder(n, n2)) {
                    this.swap();
                    int n3 = n;
                    n = n2;
                    n2 = n3;
                }
                switch (n) {
                    case 4: {
                        Function function = Function.getFunction(session.getDatabase(), "DATEADD");
                        function.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                        function.setParameter(1, this.left);
                        function.setParameter(2, this.right);
                        function.doneWithParameters();
                        return function.optimize(session);
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        Function function = Function.getFunction(session.getDatabase(), "DATEADD");
                        function.setParameter(0, ValueExpression.get(ValueString.get("SECOND")));
                        this.left = new BinaryOperation(OpType.MULTIPLY, ValueExpression.get(ValueInt.get(86400)), this.left);
                        function.setParameter(1, this.left);
                        function.setParameter(2, this.right);
                        function.doneWithParameters();
                        return function.optimize(session);
                    }
                    case 9: {
                        if (n2 == 9 || n2 == 24) {
                            this.type = TypeInfo.getTypeInfo(n2);
                            return this;
                        }
                        this.type = TypeInfo.TYPE_TIMESTAMP;
                        return this;
                    }
                }
                break;
            }
            case MINUS: {
                switch (n) {
                    case 10: 
                    case 11: 
                    case 24: {
                        switch (n2) {
                            case 4: {
                                Function function = Function.getFunction(session.getDatabase(), "DATEADD");
                                function.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                                this.right = new UnaryOperation(this.right);
                                this.right = this.right.optimize(session);
                                function.setParameter(1, this.right);
                                function.setParameter(2, this.left);
                                function.doneWithParameters();
                                return function.optimize(session);
                            }
                            case 6: 
                            case 7: 
                            case 8: {
                                Function function = Function.getFunction(session.getDatabase(), "DATEADD");
                                function.setParameter(0, ValueExpression.get(ValueString.get("SECOND")));
                                this.right = new BinaryOperation(OpType.MULTIPLY, ValueExpression.get(ValueInt.get(86400)), this.right);
                                this.right = new UnaryOperation(this.right);
                                this.right = this.right.optimize(session);
                                function.setParameter(1, this.right);
                                function.setParameter(2, this.left);
                                function.doneWithParameters();
                                return function.optimize(session);
                            }
                            case 9: {
                                this.type = TypeInfo.TYPE_TIMESTAMP;
                                return this;
                            }
                            case 10: 
                            case 11: 
                            case 24: {
                                return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_MINUS_DATETIME, this.left, this.right);
                            }
                        }
                        break;
                    }
                    case 9: {
                        if (n2 != 9) break;
                        return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_MINUS_DATETIME, this.left, this.right);
                    }
                }
                break;
            }
            case MULTIPLY: {
                if (n == 9) {
                    this.type = TypeInfo.TYPE_TIME;
                    this.convertRight = false;
                    return this;
                }
                if (n2 != 9) break;
                this.swap();
                this.type = TypeInfo.TYPE_TIME;
                this.convertRight = false;
                return this;
            }
            case DIVIDE: {
                if (n != 9) break;
                this.type = TypeInfo.TYPE_TIME;
                this.convertRight = false;
                return this;
            }
        }
        throw this.getUnsupported(n, n2);
    }

    private DbException getUnsupported(int n, int n2) {
        return DbException.getUnsupportedException(DataType.getDataType((int)n).name + ' ' + this.getOperationToken() + ' ' + DataType.getDataType((int)n2).name);
    }

    private void swap() {
        Expression expression = this.left;
        this.left = this.right;
        this.right = expression;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.right.setEvaluatable(tableFilter, bl);
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.left.updateAggregate(session, n);
        this.right.updateAggregate(session, n);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.right.getCost() + 1;
    }

    @Override
    public int getSubexpressionCount() {
        return 2;
    }

    @Override
    public Expression getSubexpression(int n) {
        switch (n) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public static enum OpType {
        CONCAT,
        PLUS,
        MINUS,
        MULTIPLY,
        DIVIDE,
        MODULUS;

    }
}

