/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import org.h2.engine.Database;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.message.DbException;
import org.h2.table.Table;

public class Role
extends RightOwner {
    private final boolean system;

    public Role(Database database, int n, String string, boolean bl) {
        super(database, n, string, 13);
        this.system = bl;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    public String getCreateSQL(boolean bl) {
        if (this.system) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("CREATE ROLE ");
        if (bl) {
            stringBuilder.append("IF NOT EXISTS ");
        }
        stringBuilder.append(this.getSQL());
        return stringBuilder.toString();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQL(false);
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        Right right;
        for (User dbObjectBase : this.database.getAllUsers()) {
            right = dbObjectBase.getRightForRole(this);
            if (right == null) continue;
            this.database.removeDatabaseObject(session, right);
        }
        for (Role role : this.database.getAllRoles()) {
            right = role.getRightForRole(this);
            if (right == null) continue;
            this.database.removeDatabaseObject(session, right);
        }
        for (Right right2 : this.database.getAllRights()) {
            if (right2.getGrantee() != this) continue;
            this.database.removeDatabaseObject(session, right2);
        }
        this.database.removeMeta(session, this.getId());
        this.invalidate();
    }

    @Override
    public void checkRename() {
    }
}

