/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.Timestamp;
import java.util.Map;
import java.util.TreeMap;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.StringDataType;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;

public class MVStoreTool {
    public static void main(String ... stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if ("-dump".equals(stringArray[i])) {
                string = stringArray[++i];
                MVStoreTool.dump(string, new PrintWriter(System.out));
                continue;
            }
            if (!"-info".equals(stringArray[i])) continue;
            string = stringArray[++i];
            MVStoreTool.info(string, new PrintWriter(System.out));
        }
    }

    public static void dump(String string) {
        MVStoreTool.dump(string, new PrintWriter(System.out));
    }

    public static void info(String string) {
        MVStoreTool.info(string, new PrintWriter(System.out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(String string, Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        if (!FilePath.get(string).exists()) {
            printWriter.println("File not found: " + string);
            return;
        }
        long l = FileUtils.size(string);
        printWriter.printf("File %s, %d bytes, %d MB\n", string, l, l / 1024L / 1024L);
        FileChannel fileChannel = null;
        int n = 4096;
        try {
            fileChannel = FilePath.get(string).open("r");
            long l2 = fileChannel.size();
            int n2 = Long.toHexString(l2).length();
            ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
            long l3 = 0L;
            while (l3 < l2) {
                int n3;
                byteBuffer.rewind();
                DataUtils.readFully(fileChannel, l3, byteBuffer);
                byteBuffer.rewind();
                byte by = byteBuffer.get();
                if (by == 72) {
                    printWriter.printf("%0" + n2 + "x fileHeader %s%n", l3, new String(byteBuffer.array(), DataUtils.LATIN).trim());
                    l3 += (long)n;
                    continue;
                }
                if (by != 99) {
                    l3 += (long)n;
                    continue;
                }
                byteBuffer.position(0);
                Chunk chunk = null;
                try {
                    chunk = Chunk.readChunkHeader(byteBuffer, l3);
                }
                catch (IllegalStateException illegalStateException) {
                    l3 += (long)n;
                    continue;
                }
                int n4 = chunk.len * 4096;
                printWriter.printf("%n%0" + n2 + "x chunkHeader %s%n", l3, chunk.toString());
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n4);
                DataUtils.readFully(fileChannel, l3, byteBuffer2);
                int n5 = byteBuffer.position();
                l3 += (long)n4;
                int n6 = chunk.pageCount;
                while (n6 > 0) {
                    byteBuffer2.position(n5);
                    n3 = byteBuffer2.getInt();
                    byteBuffer2.getShort();
                    int n7 = DataUtils.readVarInt(byteBuffer2);
                    int n8 = DataUtils.readVarInt(byteBuffer2);
                    byte by2 = byteBuffer2.get();
                    boolean bl = (by2 & 2) != 0;
                    boolean bl2 = (by2 & 1) != 0;
                    printWriter.printf("+%0" + n2 + "x %s, map %x, %d entries, %d bytes%n", n5, (bl2 ? "node" : "leaf") + (bl ? " compressed" : ""), n7, bl2 ? n8 + 1 : n8, n3);
                    n5 += n3;
                    --n6;
                    long[] lArray = null;
                    long[] lArray2 = null;
                    if (bl2) {
                        int n9;
                        lArray = new long[n8 + 1];
                        for (n9 = 0; n9 <= n8; ++n9) {
                            lArray[n9] = byteBuffer2.getLong();
                        }
                        lArray2 = new long[n8 + 1];
                        for (n9 = 0; n9 <= n8; ++n9) {
                            long l4;
                            lArray2[n9] = l4 = DataUtils.readVarLong(byteBuffer2);
                        }
                    }
                    String[] stringArray = new String[n8];
                    if (n7 == 0) {
                        int n10;
                        if (!bl) {
                            for (int i = 0; i < n8; ++i) {
                                String string2;
                                stringArray[i] = string2 = StringDataType.INSTANCE.read(byteBuffer2);
                            }
                        }
                        if (bl2) {
                            for (int i = 0; i < n8; ++i) {
                                long l5 = lArray[i];
                                printWriter.printf("    %d children < %s @ chunk %x +%0" + n2 + "x%n", lArray2[i], stringArray[i], DataUtils.getPageChunkId(l5), DataUtils.getPageOffset(l5));
                            }
                            long l6 = lArray[n8];
                            printWriter.printf("    %d children >= %s @ chunk %x +%0" + n2 + "x%n", lArray2[n8], stringArray.length >= n8 ? null : stringArray[n8], DataUtils.getPageChunkId(l6), DataUtils.getPageOffset(l6));
                            continue;
                        }
                        if (bl) continue;
                        String[] stringArray2 = new String[n8];
                        for (n10 = 0; n10 < n8; ++n10) {
                            String string3;
                            stringArray2[n10] = string3 = StringDataType.INSTANCE.read(byteBuffer2);
                        }
                        for (n10 = 0; n10 < n8; ++n10) {
                            printWriter.println("    " + stringArray[n10] + " = " + stringArray2[n10]);
                        }
                        continue;
                    }
                    if (!bl2) continue;
                    for (int i = 0; i <= n8; ++i) {
                        long l7 = lArray[i];
                        printWriter.printf("    %d children @ chunk %x +%0" + n2 + "x%n", lArray2[i], DataUtils.getPageChunkId(l7), DataUtils.getPageOffset(l7));
                    }
                }
                n3 = byteBuffer2.limit() - 128;
                byteBuffer2.position(n3);
                printWriter.printf("+%0" + n2 + "x chunkFooter %s%n", n3, new String(byteBuffer2.array(), byteBuffer2.position(), 128, DataUtils.LATIN).trim());
            }
            printWriter.printf("%n%0" + n2 + "x eof%n", l2);
            printWriter.printf("\n", new Object[0]);
        }
        catch (IOException iOException) {
            printWriter.println("ERROR: " + iOException);
            iOException.printStackTrace(printWriter);
        }
        finally {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
        printWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void info(String string, Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        if (!FilePath.get(string).exists()) {
            printWriter.println("File not found: " + string);
            return;
        }
        long l = FileUtils.size(string);
        MVStore mVStore = new MVStore.Builder().fileName(string).readOnly().open();
        try {
            Object object;
            MVMap<String, String> mVMap = mVStore.getMetaMap();
            Map<String, Object> map = mVStore.getStoreHeader();
            long l2 = DataUtils.readHexLong(map, "created", 0L);
            TreeMap<Integer, Chunk> treeMap = new TreeMap<Integer, Chunk>();
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            for (Map.Entry<String, String> entry : mVMap.entrySet()) {
                object = entry.getKey();
                if (!((String)object).startsWith("chunk.")) continue;
                Chunk chunk = Chunk.fromString(entry.getValue());
                treeMap.put(chunk.id, chunk);
                l3 += (long)(chunk.len * 4096);
                l4 += chunk.maxLen;
                l5 += chunk.maxLenLive;
            }
            printWriter.printf("Created: %s\n", MVStoreTool.formatTimestamp(l2));
            printWriter.printf("File length: %d\n", l);
            printWriter.printf("Chunk length: %d\n", l3);
            printWriter.printf("Chunk count: %d\n", treeMap.size());
            printWriter.printf("Used space: %d%%\n", 100L * l3 / l);
            printWriter.printf("Chunk fill rate: %d%%\n", 100L * l5 / l4);
            for (Map.Entry<String, String> entry : treeMap.entrySet()) {
                object = (Chunk)((Object)entry.getValue());
                long l6 = l2 + ((Chunk)object).time;
                printWriter.printf("  Chunk %d: %s, %d%% used, %d blocks\n", ((Chunk)object).id, MVStoreTool.formatTimestamp(l6), 100L * ((Chunk)object).maxLenLive / ((Chunk)object).maxLen, ((Chunk)object).len);
            }
            printWriter.printf("\n", new Object[0]);
        }
        catch (Exception exception) {
            printWriter.println("ERROR: " + exception);
            exception.printStackTrace(printWriter);
        }
        finally {
            mVStore.close();
        }
        printWriter.flush();
    }

    private static String formatTimestamp(long l) {
        String string = new Timestamp(l).toString();
        return string.substring(0, 19);
    }

    public static void compress(String string) {
        MVStoreTool.compress(string, string + ".new");
        FileUtils.moveTo(string, string + ".old");
        FileUtils.moveTo(string, string);
        FileUtils.delete(string + ".old");
    }

    public static void compress(String string, String string2) {
        Object object;
        MVStore mVStore = new MVStore.Builder().fileName(string).readOnly().open();
        FileUtils.delete(string2);
        MVStore mVStore2 = new MVStore.Builder().fileName(string2).open();
        MVMap<String, String> mVMap = mVStore.getMetaMap();
        MVMap<String, String> mVMap2 = mVStore2.getMetaMap();
        for (Map.Entry<String, String> entry : mVMap.entrySet()) {
            object = entry.getKey();
            if (((String)object).startsWith("chunk.") || ((String)object).startsWith("map.") || ((String)object).startsWith("name.") || ((String)object).startsWith("root.")) continue;
            mVMap2.put((String)object, entry.getValue());
        }
        for (String string3 : mVStore.getMapNames()) {
            object = new MVMap.Builder().keyType(new GenericDataType()).valueType(new GenericDataType());
            Object m = mVStore.openMap(string3, object);
            Object m2 = mVStore2.openMap(string3, object);
            ((MVMap)m2).copyFrom(m);
            mVStore2.commit();
        }
        mVStore2.close();
        mVStore.close();
    }

    static class GenericDataType
    implements DataType {
        GenericDataType() {
        }

        @Override
        public int compare(Object object, Object object2) {
            throw DataUtils.newUnsupportedOperationException("Can not compare");
        }

        @Override
        public int getMemory(Object object) {
            return object == null ? 0 : ((byte[])object).length;
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            if (object != null) {
                writeBuffer.put((byte[])object);
            }
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object[] objectArray, int n, boolean bl) {
            for (Object object : objectArray) {
                this.write(writeBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer) {
            int n = byteBuffer.remaining();
            if (n == 0) {
                return null;
            }
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            return byArray;
        }

        @Override
        public void read(ByteBuffer byteBuffer, Object[] objectArray, int n, boolean bl) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.read(byteBuffer);
            }
        }
    }
}

