/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.nio.ByteBuffer;
import org.h2.mvstore.DataUtils;

public class WriteBuffer {
    private static final int MAX_REUSE_LIMIT = 0x400000;
    private static final int MAX_GROW = 0x100000;
    private ByteBuffer reuse;
    private ByteBuffer buff;

    public WriteBuffer() {
        this.buff = this.reuse = ByteBuffer.allocate(524288);
    }

    public WriteBuffer putVarInt(int n) {
        DataUtils.writeVarInt(this.ensureCapacity(5), n);
        return this;
    }

    public WriteBuffer putVarLong(long l) {
        DataUtils.writeVarLong(this.ensureCapacity(10), l);
        return this;
    }

    public WriteBuffer putStringData(String string, int n) {
        ByteBuffer byteBuffer = this.ensureCapacity(3 * n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                byteBuffer.put((byte)c);
                continue;
            }
            if (c >= '\u0800') {
                byteBuffer.put((byte)(0xE0 | c >> 12));
                byteBuffer.put((byte)(c >> 6 & 0x3F));
                byteBuffer.put((byte)(c & 0x3F));
                continue;
            }
            byteBuffer.put((byte)(0xC0 | c >> 6));
            byteBuffer.put((byte)(c & 0x3F));
        }
        return this;
    }

    public WriteBuffer put(byte by) {
        this.ensureCapacity(1).put(by);
        return this;
    }

    public WriteBuffer putChar(char c) {
        this.ensureCapacity(2).putChar(c);
        return this;
    }

    public WriteBuffer putShort(short s) {
        this.ensureCapacity(2).putShort(s);
        return this;
    }

    public WriteBuffer putInt(int n) {
        this.ensureCapacity(4).putInt(n);
        return this;
    }

    public WriteBuffer putLong(long l) {
        this.ensureCapacity(8).putLong(l);
        return this;
    }

    public WriteBuffer putFloat(float f) {
        this.ensureCapacity(4).putFloat(f);
        return this;
    }

    public WriteBuffer putDouble(double d) {
        this.ensureCapacity(8).putDouble(d);
        return this;
    }

    public WriteBuffer put(byte[] byArray) {
        this.ensureCapacity(byArray.length).put(byArray);
        return this;
    }

    public WriteBuffer put(byte[] byArray, int n, int n2) {
        this.ensureCapacity(n2).put(byArray, n, n2);
        return this;
    }

    public WriteBuffer put(ByteBuffer byteBuffer) {
        this.ensureCapacity(this.buff.remaining()).put(byteBuffer);
        return this;
    }

    public WriteBuffer limit(int n) {
        this.ensureCapacity(n - this.buff.position()).limit(n);
        return this;
    }

    public int capacity() {
        return this.buff.capacity();
    }

    public WriteBuffer position(int n) {
        this.buff.position(n);
        return this;
    }

    public int limit() {
        return this.buff.limit();
    }

    public int position() {
        return this.buff.position();
    }

    public WriteBuffer get(byte[] byArray) {
        this.buff.get(byArray);
        return this;
    }

    public WriteBuffer putInt(int n, int n2) {
        this.buff.putInt(n, n2);
        return this;
    }

    public WriteBuffer putShort(int n, short s) {
        this.buff.putShort(n, s);
        return this;
    }

    public WriteBuffer clear() {
        if (this.buff.limit() > 0x400000) {
            this.buff = this.reuse;
        } else if (this.buff != this.reuse) {
            this.reuse = this.buff;
        }
        this.buff.clear();
        return this;
    }

    public ByteBuffer getBuffer() {
        return this.buff;
    }

    private ByteBuffer ensureCapacity(int n) {
        if (this.buff.remaining() < n) {
            this.grow(n);
        }
        return this.buff;
    }

    private void grow(int n) {
        ByteBuffer byteBuffer = this.buff;
        n = byteBuffer.remaining() + n;
        int n2 = byteBuffer.capacity();
        n = Math.max(n, Math.min(n2 + 0x100000, n2 * 2));
        this.buff = ByteBuffer.allocate(n);
        byteBuffer.flip();
        this.buff.put(byteBuffer);
        if (n <= 0x400000) {
            this.reuse = this.buff;
        }
    }
}

