/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;

public class AlterTableRename
extends SchemaCommand {
    private Table oldTable;
    private String newTableName;

    public AlterTableRename(Session session, Schema schema) {
        super(session, schema);
    }

    public void setOldTable(Table table) {
        this.oldTable = table;
    }

    public void setNewTableName(String string) {
        this.newTableName = string;
    }

    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        if (this.getSchema().findTableOrView(this.session, this.newTableName) != null || this.newTableName.equals(this.oldTable.getName())) {
            throw DbException.get(42101, this.newTableName);
        }
        this.session.getUser().checkRight(this.oldTable, 15);
        if (this.oldTable.isTemporary()) {
            throw DbException.getUnsupportedException("TEMP TABLE");
        }
        database.renameSchemaObject(this.session, this.oldTable, this.newTableName);
        return 0;
    }

    public int getType() {
        return 15;
    }
}

