/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.h2.message.DbException;
import org.h2.message.TraceSystem;
import org.h2.store.FileLock;
import org.h2.util.IOUtils;
import org.h2.util.New;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLister {
    private FileLister() {
    }

    public static String getDatabaseNameFromFileName(String string) {
        if (string.endsWith(".h2.db")) {
            return string.substring(0, string.length() - ".h2.db".length());
        }
        return null;
    }

    public static void tryUnlockDatabase(List<String> list, String string) throws SQLException {
        for (String string2 : list) {
            if (!string2.endsWith(".lock.db")) continue;
            FileLock fileLock = new FileLock(new TraceSystem(null), string2, 1000);
            try {
                fileLock.lock(1);
                fileLock.unlock();
            }
            catch (DbException dbException) {
                throw DbException.get(90133, string).getSQLException();
            }
        }
    }

    public static String getDir(String string) {
        if (string == null || string.equals("")) {
            return ".";
        }
        return IOUtils.normalize(string);
    }

    public static ArrayList<String> getDatabaseFiles(String string, String string2, boolean bl) {
        ArrayList<String> arrayList = New.arrayList();
        String string3 = string2 == null ? null : IOUtils.normalize(string + "/" + string2);
        String[] stringArray = IOUtils.listFiles(string);
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            boolean bl2 = false;
            if (string4.endsWith(".lobs.db")) {
                if (string3 == null || IOUtils.fileStartsWith(string4, string3 + ".")) {
                    arrayList.addAll(FileLister.getDatabaseFiles(string4, null, bl));
                    bl2 = true;
                }
            } else if (string4.endsWith(".lob.db")) {
                bl2 = true;
            } else if (string4.endsWith(".h2.db")) {
                bl2 = true;
            } else if (bl) {
                if (string4.endsWith(".lock.db")) {
                    bl2 = true;
                } else if (string4.endsWith(".temp.db")) {
                    bl2 = true;
                } else if (string4.endsWith(".trace.db")) {
                    bl2 = true;
                }
            }
            if (!bl2 || string2 != null && !IOUtils.fileStartsWith(string4, string3 + ".")) continue;
            String string5 = string4;
            arrayList.add(string5);
        }
        return arrayList;
    }
}

