/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.util.JdbcUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class UpdatableRow {
    private final JdbcConnection conn;
    private final DatabaseMetaData meta;
    private final ResultInterface result;
    private final int columnCount;
    private String schemaName;
    private String tableName;
    private ArrayList<String> key;
    private boolean isUpdatable;

    public UpdatableRow(JdbcConnection jdbcConnection, ResultInterface resultInterface) throws SQLException {
        String string;
        String string2;
        this.conn = jdbcConnection;
        this.meta = jdbcConnection.getMetaData();
        this.result = resultInterface;
        this.columnCount = resultInterface.getVisibleColumnCount();
        for (int i = 0; i < this.columnCount; ++i) {
            string2 = resultInterface.getTableName(i);
            String string3 = resultInterface.getSchemaName(i);
            if (string2 == null || string3 == null) {
                return;
            }
            if (this.tableName == null) {
                this.tableName = string2;
            } else if (!this.tableName.equals(string2)) {
                return;
            }
            if (this.schemaName == null) {
                this.schemaName = string3;
                continue;
            }
            if (this.schemaName.equals(string3)) continue;
            return;
        }
        ResultSet resultSet = this.meta.getTables(null, JdbcUtils.escapeMetaDataPattern(this.schemaName), JdbcUtils.escapeMetaDataPattern(this.tableName), new String[]{"TABLE"});
        if (!resultSet.next()) {
            return;
        }
        if (resultSet.getString("SQL") == null) {
            return;
        }
        string2 = resultSet.getString("TABLE_NAME");
        boolean bl = !string2.equals(this.tableName) && string2.equalsIgnoreCase(this.tableName);
        this.key = New.arrayList();
        resultSet = this.meta.getPrimaryKeys(null, JdbcUtils.escapeMetaDataPattern(this.schemaName), this.tableName);
        while (resultSet.next()) {
            string = resultSet.getString("COLUMN_NAME");
            this.key.add(bl ? StringUtils.toUpperEnglish(string) : string);
        }
        if (this.key.size() == 0) {
            resultSet = this.meta.getIndexInfo(null, JdbcUtils.escapeMetaDataPattern(this.schemaName), this.tableName, true, true);
            while (resultSet.next()) {
                string = resultSet.getString("COLUMN_NAME");
                this.key.add(bl ? StringUtils.toUpperEnglish(string) : string);
            }
        }
        this.isUpdatable = this.key.size() > 0;
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    private int getColumnIndex(String string) {
        for (int i = 0; i < this.columnCount; ++i) {
            String string2 = this.result.getColumnName(i);
            if (!string2.equals(string)) continue;
            return i;
        }
        throw DbException.get(42122, string);
    }

    private void appendColumnList(StatementBuilder statementBuilder, boolean bl) {
        statementBuilder.resetCount();
        for (int i = 0; i < this.columnCount; ++i) {
            statementBuilder.appendExceptFirst(",");
            String string = this.result.getColumnName(i);
            statementBuilder.append(StringUtils.quoteIdentifier(string));
            if (!bl) continue;
            statementBuilder.append("=? ");
        }
    }

    private void appendKeyCondition(StatementBuilder statementBuilder) {
        statementBuilder.append(" WHERE ");
        statementBuilder.resetCount();
        for (String string : this.key) {
            statementBuilder.appendExceptFirst(" AND ");
            statementBuilder.append(StringUtils.quoteIdentifier(string)).append("=?");
        }
    }

    private void setKey(PreparedStatement preparedStatement, int n, Value[] valueArray) throws SQLException {
        int n2 = this.key.size();
        for (int i = 0; i < n2; ++i) {
            String string = this.key.get(i);
            int n3 = this.getColumnIndex(string);
            Value value = valueArray[n3];
            if (value == null || value == ValueNull.INSTANCE) {
                throw DbException.get(2000);
            }
            value.set(preparedStatement, n + i);
        }
    }

    private void appendTableName(StatementBuilder statementBuilder) {
        if (this.schemaName != null && this.schemaName.length() > 0) {
            statementBuilder.append(StringUtils.quoteIdentifier(this.schemaName)).append('.');
        }
        statementBuilder.append(StringUtils.quoteIdentifier(this.tableName));
    }

    public Value[] readRow(Value[] valueArray) throws SQLException {
        StatementBuilder statementBuilder = new StatementBuilder("SELECT ");
        this.appendColumnList(statementBuilder, false);
        statementBuilder.append(" FROM ");
        this.appendTableName(statementBuilder);
        this.appendKeyCondition(statementBuilder);
        PreparedStatement preparedStatement = this.conn.prepareStatement(statementBuilder.toString());
        this.setKey(preparedStatement, 1, valueArray);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            throw DbException.get(2000);
        }
        Value[] valueArray2 = new Value[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            int n = this.result.getColumnType(i);
            valueArray2[i] = DataType.readValue(this.conn.getSession(), resultSet, i + 1, n);
        }
        return valueArray2;
    }

    public void deleteRow(Value[] valueArray) throws SQLException {
        StatementBuilder statementBuilder = new StatementBuilder("DELETE FROM ");
        this.appendTableName(statementBuilder);
        this.appendKeyCondition(statementBuilder);
        PreparedStatement preparedStatement = this.conn.prepareStatement(statementBuilder.toString());
        this.setKey(preparedStatement, 1, valueArray);
        int n = preparedStatement.executeUpdate();
        if (n != 1) {
            throw DbException.get(2000);
        }
    }

    public void updateRow(Value[] valueArray, Value[] valueArray2) throws SQLException {
        int n;
        StatementBuilder statementBuilder = new StatementBuilder("UPDATE ");
        this.appendTableName(statementBuilder);
        statementBuilder.append(" SET ");
        this.appendColumnList(statementBuilder, true);
        this.appendKeyCondition(statementBuilder);
        PreparedStatement preparedStatement = this.conn.prepareStatement(statementBuilder.toString());
        int n2 = 1;
        for (n = 0; n < this.columnCount; ++n) {
            Value value = valueArray2[n];
            if (value == null) {
                value = valueArray[n];
            }
            value.set(preparedStatement, n2++);
        }
        this.setKey(preparedStatement, n2, valueArray);
        n = preparedStatement.executeUpdate();
        if (n != 1) {
            throw DbException.get(2000);
        }
    }

    public void insertRow(Value[] valueArray) throws SQLException {
        int n;
        StatementBuilder statementBuilder = new StatementBuilder("INSERT INTO ");
        this.appendTableName(statementBuilder);
        statementBuilder.append('(');
        this.appendColumnList(statementBuilder, false);
        statementBuilder.append(")VALUES(");
        statementBuilder.resetCount();
        for (int i = 0; i < this.columnCount; ++i) {
            statementBuilder.appendExceptFirst(",");
            statementBuilder.append('?');
        }
        statementBuilder.append(')');
        PreparedStatement preparedStatement = this.conn.prepareStatement(statementBuilder.toString());
        for (n = 0; n < this.columnCount; ++n) {
            Value value = valueArray[n];
            if (value == null) {
                value = ValueNull.INSTANCE;
            }
            value.set(preparedStatement, n + 1);
        }
        n = preparedStatement.executeUpdate();
        if (n != 1) {
            throw DbException.get(2000);
        }
    }
}

