/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.h2.constant.ErrorCode;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.TraceSystem;
import org.h2.util.SortedProperties;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class DbException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final Properties MESSAGES = new Properties();

    private DbException(SQLException sQLException) {
        super(sQLException.getMessage(), sQLException);
    }

    private static String translate(String string, String ... stringArray) {
        String string2 = null;
        if (MESSAGES != null) {
            string2 = MESSAGES.getProperty(string);
        }
        if (string2 == null) {
            string2 = "(Message " + string + " not found)";
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (string3 == null || string3.length() <= 0) continue;
                stringArray[i] = StringUtils.quoteIdentifier(string3);
            }
            string2 = MessageFormat.format(string2, stringArray);
        }
        return string2;
    }

    public SQLException getSQLException() {
        return (SQLException)this.getCause();
    }

    public int getErrorCode() {
        return this.getSQLException().getErrorCode();
    }

    public DbException addSQL(String string) {
        SQLException sQLException = this.getSQLException();
        if (sQLException instanceof JdbcSQLException) {
            JdbcSQLException jdbcSQLException = (JdbcSQLException)sQLException;
            if (jdbcSQLException.getSQL() == null) {
                jdbcSQLException.setSQL(string);
            }
            return this;
        }
        sQLException = new JdbcSQLException(sQLException.getMessage(), string, sQLException.getSQLState(), sQLException.getErrorCode(), sQLException, null);
        return new DbException(sQLException);
    }

    public static DbException get(int n) {
        return DbException.get(n, (String)null);
    }

    public static DbException get(int n, String string) {
        return DbException.get(n, new String[]{string});
    }

    public static DbException get(int n, Throwable throwable, String ... stringArray) {
        return new DbException(DbException.getJdbcSQLException(n, throwable, stringArray));
    }

    public static DbException get(int n, String ... stringArray) {
        return new DbException(DbException.getJdbcSQLException(n, null, stringArray));
    }

    public static DbException getSyntaxError(String string, int n) {
        string = StringUtils.addAsterisk(string, n);
        return DbException.get(42000, string);
    }

    public static DbException getSyntaxError(String string, int n, String string2) {
        string = StringUtils.addAsterisk(string, n);
        return DbException.get(42001, string, string2);
    }

    public static DbException getUnsupportedException(String string) {
        return DbException.get(50100, string);
    }

    public static DbException getInvalidValueException(String string, Object object) {
        return DbException.get(90008, object == null ? "null" : object.toString(), string);
    }

    public static RuntimeException throwInternalError(String string) {
        RuntimeException runtimeException = new RuntimeException(string);
        TraceSystem.traceThrowable(runtimeException);
        throw runtimeException;
    }

    public static RuntimeException throwInternalError() {
        return DbException.throwInternalError("Unexpected code path");
    }

    public static SQLException toSQLException(Exception exception) {
        if (exception instanceof SQLException) {
            return (SQLException)exception;
        }
        return DbException.convert(exception).getSQLException();
    }

    public static DbException convert(Throwable throwable) {
        if (throwable instanceof DbException) {
            return (DbException)throwable;
        }
        if (throwable instanceof SQLException) {
            return new DbException((SQLException)throwable);
        }
        if (throwable instanceof InvocationTargetException) {
            return DbException.convertInvocation((InvocationTargetException)throwable, null);
        }
        if (throwable instanceof IOException) {
            return DbException.get(90028, throwable, throwable.toString());
        }
        if (throwable instanceof OutOfMemoryError) {
            return DbException.get(90108, throwable, new String[0]);
        }
        if (throwable instanceof StackOverflowError || throwable instanceof LinkageError) {
            return DbException.get(50000, throwable, throwable.toString());
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        return DbException.get(50000, throwable, throwable.toString());
    }

    public static DbException convertInvocation(InvocationTargetException invocationTargetException, String string) {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof SQLException || throwable instanceof DbException) {
            return DbException.convert(throwable);
        }
        string = string == null ? throwable.getMessage() : string + ": " + throwable.getMessage();
        return DbException.get(90105, throwable, string);
    }

    public static DbException convertIOException(IOException iOException, String string) {
        if (string == null) {
            Throwable throwable = iOException.getCause();
            if (throwable != null && throwable instanceof DbException) {
                return (DbException)throwable;
            }
            return DbException.get(90028, iOException, iOException.toString());
        }
        return DbException.get(90031, iOException, iOException.toString(), string);
    }

    private static JdbcSQLException getJdbcSQLException(int n, Throwable throwable, String ... stringArray) {
        String string = ErrorCode.getState(n);
        String string2 = DbException.translate(string, stringArray);
        return new JdbcSQLException(string2, null, string, n, throwable, null);
    }

    public static IOException convertToIOException(Throwable throwable) {
        Exception exception;
        if (throwable instanceof JdbcSQLException && ((JdbcSQLException)(exception = (JdbcSQLException)throwable)).getOriginalCause() != null) {
            throwable = ((JdbcSQLException)exception).getOriginalCause();
        }
        exception = new IOException(throwable.toString());
        exception.initCause(throwable);
        return exception;
    }

    static {
        try {
            byte[] byArray;
            String string;
            byte[] byArray2 = Utils.getResource("/org/h2/res/_messages_en.prop");
            if (byArray2 != null) {
                MESSAGES.load(new ByteArrayInputStream(byArray2));
            }
            if (!"en".equals(string = Locale.getDefault().getLanguage()) && (byArray = Utils.getResource("/org/h2/res/_messages_" + string + ".prop")) != null) {
                SortedProperties sortedProperties = SortedProperties.fromLines(new String(byArray, "UTF-8"));
                for (Map.Entry<Object, Object> entry : sortedProperties.entrySet()) {
                    String string2 = (String)entry.getKey();
                    String string3 = (String)entry.getValue();
                    if (string3 == null || string3.startsWith("#")) continue;
                    String string4 = MESSAGES.getProperty(string2);
                    String string5 = string3 + "\n" + string4;
                    MESSAGES.put(string2, string5);
                }
            }
        }
        catch (IOException iOException) {
            TraceSystem.traceThrowable(iOException);
        }
    }
}

