/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.h2.command.dml.SetTypes;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.security.SHA256;
import org.h2.util.IOUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class ConnectionInfo
implements Cloneable {
    private static final HashSet<String> KNOWN_SETTINGS;
    private Properties prop = new Properties();
    private String originalURL;
    private String url;
    private String user;
    private byte[] filePasswordHash;
    private byte[] userPasswordHash;
    private String name;
    private String nameNormalized;
    private boolean remote;
    private boolean ssl;
    private boolean persistent;
    private boolean unnamed;

    public ConnectionInfo(String string) {
        this.name = string;
        this.parseName();
    }

    public ConnectionInfo(String string, Properties properties) {
        this.originalURL = string;
        if (!string.startsWith("jdbc:h2:")) {
            throw DbException.getInvalidValueException(string, "url");
        }
        this.url = string;
        this.readProperties(properties);
        this.readSettingsFromURL();
        this.setUserName(this.removeProperty("USER", ""));
        this.convertPasswords();
        this.name = this.url.substring("jdbc:h2:".length());
        this.parseName();
    }

    private static boolean isKnownSetting(String string) {
        return KNOWN_SETTINGS.contains(string);
    }

    public Object clone() throws CloneNotSupportedException {
        ConnectionInfo connectionInfo = (ConnectionInfo)super.clone();
        connectionInfo.prop = (Properties)this.prop.clone();
        connectionInfo.filePasswordHash = Utils.cloneByteArray(this.filePasswordHash);
        connectionInfo.userPasswordHash = Utils.cloneByteArray(this.userPasswordHash);
        return connectionInfo;
    }

    private void parseName() {
        if (".".equals(this.name)) {
            this.name = "mem:";
        }
        if (this.name.startsWith("tcp:")) {
            this.remote = true;
            this.name = this.name.substring("tcp:".length());
        } else if (this.name.startsWith("ssl:")) {
            this.remote = true;
            this.ssl = true;
            this.name = this.name.substring("ssl:".length());
        } else if (this.name.startsWith("mem:")) {
            this.persistent = false;
            if ("mem:".equals(this.name)) {
                this.unnamed = true;
            }
        } else if (this.name.startsWith("file:")) {
            this.name = this.name.substring("file:".length());
            this.persistent = true;
        } else {
            this.persistent = true;
        }
    }

    public void setBaseDir(String string) {
        if (this.persistent) {
            File file;
            String string2;
            File file2;
            String string3 = "";
            int n = this.name.lastIndexOf(58);
            if (n > 1) {
                string3 = this.name.substring(0, n + 1);
                this.name = this.name.substring(n + 1);
            }
            if (!IOUtils.isInDir(file2 = new File(string2 = this.name.startsWith("~") ? System.getProperty("user.home") + SysProperties.FILE_SEPARATOR + this.name.substring(1) : string + SysProperties.FILE_SEPARATOR + this.name), file = new File(string))) {
                throw DbException.get(90028, file2.getAbsolutePath() + " outside " + file.getAbsolutePath());
            }
            this.name = this.name.startsWith("~") ? string3 + this.name : string3 + string + SysProperties.FILE_SEPARATOR + this.name;
        }
    }

    public boolean isRemote() {
        return this.remote;
    }

    boolean isPersistent() {
        return this.persistent;
    }

    boolean isUnnamedInMemory() {
        return this.unnamed;
    }

    private void readProperties(Properties properties) {
        Object[] objectArray = new Object[properties.size()];
        properties.keySet().toArray(objectArray);
        for (Object object : objectArray) {
            String string = StringUtils.toUpperEnglish(object.toString());
            if (this.prop.containsKey(string)) {
                throw DbException.get(90066, string);
            }
            if (!ConnectionInfo.isKnownSetting(string)) continue;
            this.prop.put(string, properties.get(object));
        }
    }

    private void readSettingsFromURL() {
        int n = this.url.indexOf(59);
        if (n >= 0) {
            String[] stringArray;
            String string = this.url.substring(n + 1);
            this.url = this.url.substring(0, n);
            for (String string2 : stringArray = StringUtils.arraySplit(string, ';', false)) {
                int n2 = string2.indexOf(61);
                if (n2 < 0) {
                    throw this.getFormatException();
                }
                String string3 = string2.substring(n2 + 1);
                String string4 = string2.substring(0, n2);
                if (!ConnectionInfo.isKnownSetting(string4 = StringUtils.toUpperEnglish(string4))) {
                    throw DbException.get(90113, string4);
                }
                String string5 = this.prop.getProperty(string4);
                if (string5 != null && !string5.equals(string3)) {
                    throw DbException.get(90066, string4);
                }
                this.prop.setProperty(string4, string3);
            }
        }
    }

    private char[] removePassword() {
        Object object = this.prop.remove("PASSWORD");
        if (object == null) {
            return new char[0];
        }
        if (object instanceof char[]) {
            return (char[])object;
        }
        return object.toString().toCharArray();
    }

    private void convertPasswords() {
        char[] cArray = this.removePassword();
        boolean bl = this.removeProperty("PASSWORD_HASH", false);
        if (this.getProperty("CIPHER", null) != null) {
            int n = -1;
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] != ' ') continue;
                n = i;
                break;
            }
            if (n < 0) {
                throw DbException.get(90050);
            }
            char[] cArray2 = new char[cArray.length - n - 1];
            char[] cArray3 = new char[n];
            System.arraycopy(cArray, n + 1, cArray2, 0, cArray2.length);
            System.arraycopy(cArray, 0, cArray3, 0, n);
            Arrays.fill(cArray, '\u0000');
            cArray = cArray2;
            this.filePasswordHash = this.hashPassword(bl, "file", cArray3);
        }
        this.userPasswordHash = this.hashPassword(bl, this.user, cArray);
    }

    private byte[] hashPassword(boolean bl, String string, char[] cArray) {
        if (bl) {
            return StringUtils.convertStringToBytes(new String(cArray));
        }
        if (string.length() == 0 && cArray.length == 0 && SysProperties.EMPTY_PASSWORD) {
            return new byte[0];
        }
        SHA256 sHA256 = new SHA256();
        return sHA256.getKeyPasswordHash(string, cArray);
    }

    public boolean getProperty(String string, boolean bl) {
        String string2 = this.getProperty(string, null);
        if (string2 == null) {
            return bl;
        }
        if (string2.length() == 1 && Character.isDigit(string2.charAt(0))) {
            return Integer.parseInt(string2) != 0;
        }
        return Boolean.valueOf(string2);
    }

    public boolean removeProperty(String string, boolean bl) {
        String string2 = this.removeProperty(string, null);
        return string2 == null ? bl : Boolean.valueOf(string2);
    }

    String removeProperty(String string, String string2) {
        Object object;
        if (SysProperties.CHECK && !ConnectionInfo.isKnownSetting(string)) {
            DbException.throwInternalError(string);
        }
        return (object = this.prop.remove(string)) == null ? string2 : object.toString();
    }

    String getName() {
        if (this.persistent) {
            if (this.nameNormalized == null) {
                String string = ".h2.db";
                String string2 = IOUtils.normalize(this.name + string);
                String string3 = IOUtils.getFileName(string2);
                if (string3.length() < string.length() + 1) {
                    throw DbException.get(90138, this.name);
                }
                this.nameNormalized = string2.substring(0, string2.length() - string.length());
            }
            return this.nameNormalized;
        }
        return this.name;
    }

    byte[] getFilePasswordHash() {
        return this.filePasswordHash;
    }

    public String getUserName() {
        return this.user;
    }

    byte[] getUserPasswordHash() {
        return this.userPasswordHash;
    }

    String[] getKeys() {
        String[] stringArray = new String[this.prop.size()];
        this.prop.keySet().toArray(stringArray);
        return stringArray;
    }

    String getProperty(String string) {
        Object object = this.prop.get(string);
        if (object == null || !(object instanceof String)) {
            return null;
        }
        return object.toString();
    }

    public int getProperty(String string, int n) {
        String string2;
        if (SysProperties.CHECK && !ConnectionInfo.isKnownSetting(string)) {
            DbException.throwInternalError(string);
        }
        return (string2 = this.getProperty(string)) == null ? n : Integer.parseInt(string2);
    }

    public String getProperty(String string, String string2) {
        String string3;
        if (SysProperties.CHECK && !ConnectionInfo.isKnownSetting(string)) {
            DbException.throwInternalError(string);
        }
        return (string3 = this.getProperty(string)) == null ? string2 : string3;
    }

    String getProperty(int n, String string) {
        String string2 = SetTypes.getTypeName(n);
        String string3 = this.getProperty(string2);
        return string3 == null ? string : string3;
    }

    int getIntProperty(int n, int n2) {
        String string = SetTypes.getTypeName(n);
        String string2 = this.getProperty(string, null);
        try {
            return string2 == null ? n2 : Integer.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    boolean isSSL() {
        return this.ssl;
    }

    public void setUserName(String string) {
        this.user = StringUtils.toUpperEnglish(string);
    }

    public void setUserPasswordHash(byte[] byArray) {
        this.userPasswordHash = byArray;
    }

    public void setFilePasswordHash(byte[] byArray) {
        this.filePasswordHash = byArray;
    }

    public void setProperty(String string, String string2) {
        if (string2 != null) {
            this.prop.setProperty(string, string2);
        }
    }

    public String getURL() {
        return this.url;
    }

    public String getOriginalURL() {
        return this.originalURL;
    }

    public void setOriginalURL(String string) {
        this.originalURL = string;
    }

    DbException getFormatException() {
        String string = "jdbc:h2:{ {.|mem:}[name] | [file:]fileName | {tcp|ssl}:[//]server[:port][,server2[:port]]/name }[;key=value...]";
        return DbException.get(90046, string, this.url);
    }

    public void setServerKey(String string) {
        this.remote = true;
        this.persistent = false;
        this.name = string;
    }

    static {
        String[] stringArray;
        KNOWN_SETTINGS = New.hashSet();
        ArrayList<String> arrayList = SetTypes.getTypes();
        HashSet<String> hashSet = KNOWN_SETTINGS;
        hashSet.addAll(arrayList);
        for (String string : stringArray = new String[]{"ACCESS_MODE_DATA", "AUTOCOMMIT", "CIPHER", "CREATE", "CACHE_TYPE", "DB_CLOSE_ON_EXIT", "FILE_LOCK", "IGNORE_UNKNOWN_SETTINGS", "IFEXISTS", "INIT", "PASSWORD", "RECOVER", "USER", "AUTO_SERVER", "AUTO_RECONNECT", "OPEN_NEW", "PAGE_SIZE", "PASSWORD_HASH"}) {
            if (SysProperties.CHECK && hashSet.contains(string)) {
                DbException.throwInternalError(string);
            }
            hashSet.add(string);
        }
    }
}

