/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.h2.constant.SysProperties;
import org.h2.store.fs.FileObject;
import org.h2.util.IOUtils;

public class FileObjectDiskMapped
implements FileObject {
    private static final long GC_TIMEOUT_MS = 10000L;
    private final String name;
    private final FileChannel.MapMode mode;
    private RandomAccessFile file;
    private MappedByteBuffer mapped;
    private int pos;

    FileObjectDiskMapped(String string, String string2) throws IOException {
        this.mode = "r".equals(string2) ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
        this.name = string;
        this.file = new RandomAccessFile(string, string2);
        this.reMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unMap() throws IOException {
        if (this.mapped != null) {
            Object object;
            boolean bl;
            this.mapped.force();
            if (SysProperties.NIO_CLEANER_HACK) {
                try {
                    bl = false;
                    object = this.mapped.getClass().getMethod("cleaner", new Class[0]);
                    ((Method)object).setAccessible(true);
                    Object object2 = ((Method)object).invoke((Object)this.mapped, new Object[0]);
                    Method method = object2.getClass().getMethod("clear", new Class[0]);
                    method.invoke(object2, new Object[0]);
                }
                catch (Throwable throwable) {
                    bl = true;
                }
                finally {
                    this.mapped = null;
                }
            } else {
                bl = true;
            }
            if (bl) {
                object = new WeakReference<MappedByteBuffer>(this.mapped);
                this.mapped = null;
                long l = System.currentTimeMillis();
                while (((Reference)object).get() != null) {
                    if (System.currentTimeMillis() - l > 10000L) {
                        throw new IOException("Timeout (10000 ms) reached while trying to GC mapped buffer");
                    }
                    System.gc();
                    Thread.yield();
                }
            }
        }
    }

    private void reMap() throws IOException {
        int n = 0;
        if (this.mapped != null) {
            n = this.pos;
            this.mapped.force();
            this.unMap();
        }
        long l = this.file.length();
        this.checkFileSizeLimit(l);
        this.mapped = this.file.getChannel().map(this.mode, 0L, l);
        int n2 = this.mapped.limit();
        int n3 = this.mapped.capacity();
        if ((long)n2 < l || (long)n3 < l) {
            throw new IOException("Unable to map: length=" + n2 + " capacity=" + n3 + " length=" + l);
        }
        if (SysProperties.NIO_LOAD_MAPPED) {
            this.mapped.load();
        }
        this.pos = Math.min(n, (int)l);
    }

    private void checkFileSizeLimit(long l) throws IOException {
        if (l > Integer.MAX_VALUE) {
            throw new IOException("File over 2GB is not supported yet when using this file system");
        }
    }

    public void close() throws IOException {
        this.unMap();
        this.file.close();
        this.file = null;
    }

    public long getFilePointer() {
        return this.pos;
    }

    public String getName() {
        return this.name;
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public void readFully(byte[] byArray, int n, int n2) throws EOFException {
        try {
            this.mapped.position(this.pos);
            this.mapped.get(byArray, n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            EOFException eOFException = new EOFException("EOF");
            eOFException.initCause(illegalArgumentException);
            throw eOFException;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            EOFException eOFException = new EOFException("EOF");
            eOFException.initCause(bufferUnderflowException);
            throw eOFException;
        }
    }

    public void seek(long l) throws IOException {
        this.checkFileSizeLimit(l);
        this.pos = (int)l;
    }

    public void setFileLength(long l) throws IOException {
        this.checkFileSizeLimit(l);
        IOUtils.setLength(this.file, l);
        this.reMap();
    }

    public void sync() throws IOException {
        this.mapped.force();
        this.file.getFD().sync();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.mapped.capacity() < this.pos + n2) {
            this.setFileLength(this.pos + n2);
        }
        this.mapped.position(this.pos);
        this.mapped.put(byArray, n, n2);
    }
}

