/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.h2.api.DatabaseEventListener;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.dml.SetTypes;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.engine.Comment;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.DatabaseCloser;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Engine;
import org.h2.engine.MetaRecord;
import org.h2.engine.Mode;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.SchemaObjectBase;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.store.DataHandler;
import org.h2.store.FileLock;
import org.h2.store.FileStore;
import org.h2.store.InDoubtTransaction;
import org.h2.store.LobStorage;
import org.h2.store.PageStore;
import org.h2.store.WriterThread;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.MetaTable;
import org.h2.table.Table;
import org.h2.table.TableLinkConnection;
import org.h2.table.TableView;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.New;
import org.h2.util.SmallLRUCache;
import org.h2.util.SourceCompiler;
import org.h2.util.StringUtils;
import org.h2.util.TempFileDeleter;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database
implements DataHandler {
    private static int initialPowerOffCount;
    private static final String SYSTEM_USER_NAME = "DBA";
    private final boolean persistent;
    private final String databaseName;
    private final String databaseShortName;
    private final String databaseURL;
    private final String cipher;
    private final byte[] filePasswordHash;
    private final HashMap<String, Role> roles = New.hashMap();
    private final HashMap<String, User> users = New.hashMap();
    private final HashMap<String, Setting> settings = New.hashMap();
    private final HashMap<String, Schema> schemas = New.hashMap();
    private final HashMap<String, Right> rights = New.hashMap();
    private final HashMap<String, UserDataType> userDataTypes = New.hashMap();
    private final HashMap<String, UserAggregate> aggregates = New.hashMap();
    private final HashMap<String, Comment> comments = New.hashMap();
    private final Set<Session> userSessions = Collections.synchronizedSet(new HashSet());
    private Session exclusiveSession;
    private final BitSet objectIds = new BitSet();
    private final Object lobSyncObject = new Object();
    private Schema mainSchema;
    private Schema infoSchema;
    private int nextSessionId;
    private int nextTempTableId;
    private User systemUser;
    private Session systemSession;
    private Table meta;
    private Index metaIdIndex;
    private FileLock lock;
    private WriterThread writer;
    private boolean starting;
    private TraceSystem traceSystem;
    private int fileLockMethod;
    private Role publicRole;
    private long modificationDataId;
    private long modificationMetaId;
    private CompareMode compareMode;
    private String cluster = "''";
    private boolean readOnly;
    private boolean noDiskSpace;
    private int writeDelay = 500;
    private DatabaseEventListener eventListener;
    private int maxMemoryRows = 10000;
    private int maxMemoryUndo = SysProperties.DEFAULT_MAX_MEMORY_UNDO;
    private int lockMode = SysProperties.DEFAULT_LOCK_MODE;
    private int maxLengthInplaceLob;
    private int allowLiterals = 2;
    private int powerOffCount = initialPowerOffCount;
    private int closeDelay;
    private DatabaseCloser delayedCloser;
    private volatile boolean closing;
    private boolean ignoreCase;
    private boolean deleteFilesOnDisconnect;
    private String lobCompressionAlgorithm;
    private boolean optimizeReuseResults = true;
    private String cacheType;
    private String accessModeData;
    private boolean referentialIntegrity = true;
    private boolean multiVersion;
    private DatabaseCloser closeOnExit;
    private Mode mode = Mode.getInstance("REGULAR");
    private boolean multiThreaded;
    private int maxOperationMemory = SysProperties.DEFAULT_MAX_OPERATION_MEMORY;
    private SmallLRUCache<String, String[]> lobFileListCache = SmallLRUCache.newInstance(128);
    private boolean autoServerMode;
    private Server server;
    private HashMap<TableLinkConnection, TableLinkConnection> linkConnections;
    private TempFileDeleter tempFileDeleter = TempFileDeleter.getInstance();
    private PageStore pageStore;
    private Properties reconnectLastLock;
    private volatile long reconnectCheckNext;
    private volatile boolean reconnectChangePending;
    private volatile int checkpointAllowed;
    private volatile boolean checkpointRunning;
    private final Object reconnectSync = new Object();
    private int cacheSize;
    private boolean compactFully;
    private SourceCompiler compiler;
    private volatile boolean metaTablesInitialized;
    private boolean flushOnEachCommit;
    private LobStorage lobStorage;
    private int pageSize = SysProperties.PAGE_SIZE;

    public Database(ConnectionInfo connectionInfo, String string) {
        String string2 = connectionInfo.getName();
        this.compareMode = CompareMode.getInstance(null, 0);
        this.persistent = connectionInfo.isPersistent();
        this.filePasswordHash = connectionInfo.getFilePasswordHash();
        this.databaseName = string2;
        this.databaseShortName = this.parseDatabaseShortName();
        this.maxLengthInplaceLob = SysProperties.LOB_IN_DATABASE ? SysProperties.DEFAULT_MAX_LENGTH_INPLACE_LOB2 : SysProperties.DEFAULT_MAX_LENGTH_INPLACE_LOB;
        this.cipher = string;
        String string3 = connectionInfo.getProperty("FILE_LOCK", null);
        this.accessModeData = connectionInfo.getProperty("ACCESS_MODE_DATA", "rw").toLowerCase();
        this.autoServerMode = connectionInfo.getProperty("AUTO_SERVER", false);
        this.cacheSize = connectionInfo.getProperty("CACHE_SIZE", SysProperties.CACHE_SIZE_DEFAULT);
        this.pageSize = connectionInfo.getProperty("PAGE_SIZE", SysProperties.PAGE_SIZE);
        if ("r".equals(this.accessModeData)) {
            this.readOnly = true;
        }
        this.fileLockMethod = FileLock.getFileLockMethod(string3);
        this.databaseURL = connectionInfo.getURL();
        String string4 = connectionInfo.removeProperty("DATABASE_EVENT_LISTENER", null);
        if (string4 != null) {
            string4 = StringUtils.trim(string4, true, true, "'");
            this.setEventListenerClass(string4);
        }
        this.multiVersion = connectionInfo.getProperty("MVCC", false);
        boolean bl = connectionInfo.getProperty("DB_CLOSE_ON_EXIT", true);
        int n = connectionInfo.getIntProperty(10, 1);
        int n2 = connectionInfo.getIntProperty(9, 0);
        this.cacheType = StringUtils.toUpperEnglish(connectionInfo.removeProperty("CACHE_TYPE", SysProperties.CACHE_TYPE_DEFAULT));
        this.openDatabase(n, n2, bl);
    }

    private void openDatabase(int n, int n2, boolean bl) {
        try {
            this.open(n, n2);
            if (bl) {
                try {
                    this.closeOnExit = new DatabaseCloser(this, 0, true);
                    Runtime.getRuntime().addShutdownHook(this.closeOnExit);
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (SecurityException securityException) {}
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                throwable.fillInStackTrace();
            }
            if (this.traceSystem != null) {
                SQLException sQLException;
                if (throwable instanceof SQLException && (sQLException = (SQLException)throwable).getErrorCode() != 90020) {
                    this.traceSystem.getTrace("database").error("opening " + this.databaseName, throwable);
                }
                this.traceSystem.close();
            }
            this.closeOpenFilesAndUnlock(false);
            throw DbException.convert(throwable);
        }
    }

    public static void setInitialPowerOffCount(int n) {
        initialPowerOffCount = n;
    }

    public void setPowerOffCount(int n) {
        if (this.powerOffCount == -1) {
            return;
        }
        this.powerOffCount = n;
    }

    public boolean areEqual(Value value, Value value2) {
        return value.compareTo(value2, this.compareMode) == 0;
    }

    public int compare(Value value, Value value2) {
        return value.compareTo(value2, this.compareMode);
    }

    public int compareTypeSave(Value value, Value value2) {
        return value.compareTypeSave(value2, this.compareMode);
    }

    public long getModificationDataId() {
        return this.modificationDataId;
    }

    synchronized boolean reconnectModified(boolean bl) {
        if (this.readOnly || this.lock == null || this.fileLockMethod != 3) {
            return true;
        }
        try {
            Object object;
            if (bl == this.reconnectChangePending) {
                long l = System.currentTimeMillis();
                if (l > this.reconnectCheckNext) {
                    if (bl) {
                        String string = this.pageStore == null ? null : "" + this.pageStore.getWriteCountTotal();
                        this.lock.setProperty("logPos", string);
                        this.lock.save();
                    }
                    this.reconnectCheckNext = l + (long)SysProperties.RECONNECT_CHECK_DELAY;
                }
                return true;
            }
            Properties properties = this.lock.load();
            if (bl) {
                if (properties.getProperty("changePending") != null) {
                    return false;
                }
                this.getTrace().debug("wait before writing");
                Thread.sleep((int)((double)SysProperties.RECONNECT_CHECK_DELAY * 1.1));
                object = this.lock.load();
                if (!((Properties)object).equals(properties)) {
                    return false;
                }
            }
            object = this.pageStore == null ? null : "" + this.pageStore.getWriteCountTotal();
            this.lock.setProperty("logPos", (String)object);
            if (bl) {
                this.lock.setProperty("changePending", "true-" + Math.random());
            } else {
                this.lock.setProperty("changePending", null);
            }
            this.reconnectCheckNext = System.currentTimeMillis() + (long)(2 * SysProperties.RECONNECT_CHECK_DELAY);
            properties = this.lock.save();
            if (bl) {
                this.getTrace().debug("wait before writing again");
                Thread.sleep((int)((double)SysProperties.RECONNECT_CHECK_DELAY * 1.1));
                Properties properties2 = this.lock.load();
                if (!properties2.equals(properties)) {
                    return false;
                }
            } else {
                Thread.sleep(1L);
            }
            this.reconnectLastLock = properties;
            this.reconnectChangePending = bl;
            this.reconnectCheckNext = System.currentTimeMillis() + (long)SysProperties.RECONNECT_CHECK_DELAY;
            return true;
        }
        catch (Exception exception) {
            this.getTrace().error("pending:" + bl, exception);
            return false;
        }
    }

    public long getNextModificationDataId() {
        return ++this.modificationDataId;
    }

    public long getModificationMetaId() {
        return this.modificationMetaId;
    }

    public long getNextModificationMetaId() {
        ++this.modificationDataId;
        return this.modificationMetaId++;
    }

    public int getPowerOffCount() {
        return this.powerOffCount;
    }

    @Override
    public void checkPowerOff() {
        if (this.powerOffCount == 0) {
            return;
        }
        if (this.powerOffCount > 1) {
            --this.powerOffCount;
            return;
        }
        if (this.powerOffCount != -1) {
            try {
                this.powerOffCount = -1;
                this.stopWriter();
                if (this.pageStore != null) {
                    try {
                        this.pageStore.close();
                    }
                    catch (DbException dbException) {
                        // empty catch block
                    }
                    this.pageStore = null;
                }
                if (this.lock != null) {
                    this.stopServer();
                    if (this.fileLockMethod != 3) {
                        this.lock.unlock();
                    }
                    this.lock = null;
                }
                if (this.traceSystem != null) {
                    this.traceSystem.close();
                }
            }
            catch (DbException dbException) {
                TraceSystem.traceThrowable(dbException);
            }
        }
        Engine.getInstance().close(this.databaseName);
        throw DbException.get(90098);
    }

    public static boolean exists(String string) {
        return IOUtils.exists(string + ".h2.db");
    }

    public Trace getTrace(String string) {
        return this.traceSystem.getTrace(string);
    }

    @Override
    public FileStore openFile(String string, String string2, boolean bl) {
        if (bl && !IOUtils.exists(string)) {
            throw DbException.get(90124, string);
        }
        FileStore fileStore = FileStore.open(this, string, string2, this.cipher, this.filePasswordHash);
        try {
            fileStore.init();
        }
        catch (DbException dbException) {
            fileStore.closeSilently();
            throw dbException;
        }
        return fileStore;
    }

    public boolean validateFilePasswordHash(String string, byte[] byArray) {
        if (!StringUtils.equals(string, this.cipher)) {
            return false;
        }
        return Utils.compareSecure(byArray, this.filePasswordHash);
    }

    private String parseDatabaseShortName() {
        String string = this.databaseName;
        if (string.endsWith(":")) {
            string = null;
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/\\:,;");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        if (string == null || string.length() == 0) {
            string = "unnamed";
        }
        return SysProperties.DATABASE_TO_UPPER ? StringUtils.toUpperEnglish(string) : string;
    }

    private synchronized void open(int n, int n2) {
        IndexColumn[] indexColumnArray;
        boolean bl;
        Object object;
        Object object2;
        if (this.persistent) {
            object2 = this.databaseName + ".data.db";
            boolean bl2 = IOUtils.exists((String)object2);
            object = this.databaseName + ".h2.db";
            bl = IOUtils.exists((String)object);
            if (bl2 && !bl) {
                throw DbException.get(90048, "Old database: " + (String)object2 + " - please convert the database to a SQL script and re-create it.");
            }
            if (bl && IOUtils.isReadOnly((String)object)) {
                this.readOnly |= IOUtils.isReadOnly((String)object);
            }
            this.traceSystem = this.readOnly ? new TraceSystem(null) : new TraceSystem(this.databaseName + ".trace.db");
            this.traceSystem.setLevelFile(n);
            this.traceSystem.setLevelSystemOut(n2);
            this.traceSystem.getTrace("database").info("opening " + this.databaseName + " (build " + 139 + ")");
            if (this.autoServerMode && (this.readOnly || this.fileLockMethod == 0 || this.fileLockMethod == 3)) {
                throw DbException.getUnsupportedException("autoServerMode && (readOnly || fileLockMethod == NO || fileLockMethod == SERIALIZED)");
            }
            indexColumnArray = this.databaseName + ".lock.db";
            if (this.readOnly && IOUtils.exists((String)indexColumnArray)) {
                throw DbException.get(90020, "Lock file exists: " + (String)indexColumnArray);
            }
            if (!this.readOnly && this.fileLockMethod != 0) {
                this.lock = new FileLock(this.traceSystem, (String)indexColumnArray, 1000);
                this.lock.lock(this.fileLockMethod);
                if (this.autoServerMode) {
                    this.startServer(this.lock.getUniqueId());
                }
            }
            while (this.isReconnectNeeded() && !this.beforeWriting()) {
            }
            this.deleteOldTempFiles();
            this.starting = true;
            this.getPageStore();
            this.starting = false;
            this.reserveLobFileObjectIds();
            this.writer = WriterThread.create(this, this.writeDelay);
        } else {
            this.traceSystem = new TraceSystem(null);
        }
        this.systemUser = new User(this, 0, SYSTEM_USER_NAME, true);
        this.mainSchema = new Schema(this, 0, "PUBLIC", this.systemUser, true);
        this.infoSchema = new Schema(this, -1, "INFORMATION_SCHEMA", this.systemUser, true);
        this.schemas.put(this.mainSchema.getName(), this.mainSchema);
        this.schemas.put(this.infoSchema.getName(), this.infoSchema);
        this.publicRole = new Role(this, 0, "PUBLIC", true);
        this.roles.put("PUBLIC", this.publicRole);
        this.systemUser.setAdmin(true);
        this.systemSession = new Session(this, this.systemUser, ++this.nextSessionId);
        object2 = new CreateTableData();
        ArrayList<Column> arrayList = ((CreateTableData)object2).columns;
        object = new Column("ID", 4);
        ((Column)object).setNullable(false);
        arrayList.add((Column)object);
        arrayList.add(new Column("HEAD", 4));
        arrayList.add(new Column("TYPE", 4));
        arrayList.add(new Column("SQL", 13));
        bl = true;
        if (this.pageStore != null) {
            bl = this.pageStore.isNew();
        }
        ((CreateTableData)object2).tableName = "SYS";
        ((CreateTableData)object2).id = 0;
        ((CreateTableData)object2).temporary = false;
        ((CreateTableData)object2).persistData = this.persistent;
        ((CreateTableData)object2).persistIndexes = this.persistent;
        ((CreateTableData)object2).create = bl;
        ((CreateTableData)object2).isHidden = true;
        ((CreateTableData)object2).session = this.systemSession;
        this.meta = this.mainSchema.createTable((CreateTableData)object2);
        indexColumnArray = IndexColumn.wrap(new Column[]{object});
        this.metaIdIndex = this.meta.addIndex(this.systemSession, "SYS_ID", 0, indexColumnArray, IndexType.createPrimaryKey(false, false), true, null);
        this.objectIds.set(0);
        this.starting = true;
        Cursor cursor = this.metaIdIndex.find(this.systemSession, null, null);
        ArrayList<MetaRecord> arrayList2 = New.arrayList();
        while (cursor.next()) {
            MetaRecord metaRecord = new MetaRecord(cursor.get());
            this.objectIds.set(metaRecord.getId());
            arrayList2.add(metaRecord);
        }
        Collections.sort(arrayList2);
        for (MetaRecord metaRecord : arrayList2) {
            metaRecord.execute(this, this.systemSession, this.eventListener);
        }
        this.recompileInvalidViews(this.systemSession);
        this.starting = false;
        this.addDefaultSetting(this.systemSession, 6, null, 2000);
        this.addDefaultSetting(this.systemSession, 7, null, 0);
        this.addDefaultSetting(this.systemSession, 8, null, SysProperties.CACHE_SIZE_DEFAULT);
        this.addDefaultSetting(this.systemSession, 13, "''", 0);
        this.addDefaultSetting(this.systemSession, 14, null, 500);
        this.addDefaultSetting(this.systemSession, 34, null, 139);
        if (SysProperties.LOB_IN_DATABASE) {
            this.getLobStorage().init();
        }
        this.systemSession.commit(true);
        this.traceSystem.getTrace("database").info("opened " + this.databaseName);
        this.afterWriting();
    }

    private void startServer(String string) {
        try {
            this.server = Server.createTcpServer("-tcpPort", "0", "-tcpAllowOthers", "-tcpDaemon", "-key", string, this.databaseName);
            this.server.start();
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        String string2 = NetUtils.getLocalAddress() + ":" + this.server.getPort();
        this.lock.setProperty("server", string2);
        this.lock.save();
    }

    private void stopServer() {
        if (this.server != null) {
            Server server = this.server;
            this.server = null;
            server.stop();
        }
    }

    private void recompileInvalidViews(Session session) {
        TableView tableView;
        boolean bl;
        do {
            bl = false;
            for (Table table : this.getAllTablesAndViews(false)) {
                if (!(table instanceof TableView) || !(tableView = (TableView)table).isInvalid()) continue;
                try {
                    tableView.recompile(session);
                }
                catch (DbException dbException) {
                    // empty catch block
                }
                if (tableView.isInvalid()) continue;
                bl = true;
            }
        } while (bl);
        for (Table table : this.getAllTablesAndViews(false)) {
            if (!(table instanceof TableView) || (tableView = (TableView)table).isInvalid()) continue;
            try {
                tableView.recompile(this.systemSession);
            }
            catch (DbException dbException) {}
        }
    }

    private void addDefaultSetting(Session session, int n, String string, int n2) {
        if (this.readOnly) {
            return;
        }
        String string2 = SetTypes.getTypeName(n);
        if (this.settings.get(string2) == null) {
            Setting setting = new Setting(this, this.allocateObjectId(), string2);
            if (string == null) {
                setting.setIntValue(n2);
            } else {
                setting.setStringValue(string);
            }
            this.addDatabaseObject(session, setting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaTables() {
        if (this.metaTablesInitialized) {
            return;
        }
        Schema schema = this.infoSchema;
        synchronized (schema) {
            if (!this.metaTablesInitialized) {
                for (int i = 0; i < MetaTable.getMetaTableTypeCount(); ++i) {
                    MetaTable metaTable = new MetaTable(this.infoSchema, -1 - i, i);
                    this.infoSchema.add(metaTable);
                }
                this.metaTablesInitialized = true;
            }
        }
    }

    private synchronized void addMeta(Session session, DbObject dbObject) {
        int n = dbObject.getId();
        if (n > 0 && !this.starting && !dbObject.isTemporary()) {
            Row row = this.meta.getTemplateRow();
            MetaRecord metaRecord = new MetaRecord(dbObject);
            metaRecord.setRecord(row);
            this.objectIds.set(n);
            this.meta.lock(session, true, true);
            this.meta.addRow(session, row);
            if (this.isMultiVersion()) {
                session.log(this.meta, (short)0, row);
            }
        }
    }

    public synchronized void removeMeta(Session session, int n) {
        if (n > 0 && !this.starting) {
            SearchRow searchRow = this.meta.getTemplateSimpleRow(false);
            searchRow.setValue(0, ValueInt.get(n));
            boolean bl = this.meta.isLockedExclusivelyBy(session);
            this.meta.lock(session, true, true);
            Cursor cursor = this.metaIdIndex.find(session, searchRow, searchRow);
            if (cursor.next()) {
                Row row = cursor.get();
                this.meta.removeRow(session, row);
                if (this.isMultiVersion()) {
                    session.log(this.meta, (short)1, row);
                }
                this.objectIds.clear(n);
                if (SysProperties.CHECK) {
                    this.checkMetaFree(session, n);
                }
            } else if (!bl) {
                this.meta.unlock(session);
                session.unlock(this.meta);
            }
        }
    }

    private HashMap<String, DbObject> getMap(int n) {
        HashMap<String, DbObject> hashMap;
        switch (n) {
            case 2: {
                hashMap = this.users;
                break;
            }
            case 6: {
                hashMap = this.settings;
                break;
            }
            case 7: {
                hashMap = this.roles;
                break;
            }
            case 8: {
                hashMap = this.rights;
                break;
            }
            case 10: {
                hashMap = this.schemas;
                break;
            }
            case 12: {
                hashMap = this.userDataTypes;
                break;
            }
            case 13: {
                hashMap = this.comments;
                break;
            }
            case 14: {
                hashMap = this.aggregates;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n);
            }
        }
        return hashMap;
    }

    public synchronized void addSchemaObject(Session session, SchemaObject schemaObject) {
        int n = schemaObject.getId();
        if (n > 0 && !this.starting) {
            this.checkWritingAllowed();
        }
        schemaObject.getSchema().add(schemaObject);
        this.addMeta(session, schemaObject);
    }

    public synchronized void addDatabaseObject(Session session, DbObject dbObject) {
        Object object;
        int n = dbObject.getId();
        if (n > 0 && !this.starting) {
            this.checkWritingAllowed();
        }
        HashMap<String, DbObject> hashMap = this.getMap(dbObject.getType());
        if (dbObject.getType() == 2 && ((User)(object = (User)dbObject)).isAdmin() && this.systemUser.getName().equals(SYSTEM_USER_NAME)) {
            this.systemUser.rename(((DbObjectBase)object).getName());
        }
        object = dbObject.getName();
        if (SysProperties.CHECK && hashMap.get(object) != null) {
            DbException.throwInternalError("object already exists");
        }
        this.addMeta(session, dbObject);
        hashMap.put((String)object, dbObject);
    }

    public UserAggregate findAggregate(String string) {
        return this.aggregates.get(string);
    }

    public Comment findComment(DbObject dbObject) {
        if (dbObject.getType() == 13) {
            return null;
        }
        String string = Comment.getKey(dbObject);
        return this.comments.get(string);
    }

    public Role findRole(String string) {
        return this.roles.get(string);
    }

    public Schema findSchema(String string) {
        Schema schema = this.schemas.get(string);
        if (schema == this.infoSchema) {
            this.initMetaTables();
        }
        return schema;
    }

    public Setting findSetting(String string) {
        return this.settings.get(string);
    }

    public User findUser(String string) {
        return this.users.get(string);
    }

    public UserDataType findUserDataType(String string) {
        return this.userDataTypes.get(string);
    }

    public User getUser(String string) {
        User user = this.findUser(string);
        if (user == null) {
            throw DbException.get(90032, string);
        }
        return user;
    }

    public synchronized Session createSession(User user) {
        if (this.exclusiveSession != null) {
            throw DbException.get(90135);
        }
        Session session = new Session(this, user, ++this.nextSessionId);
        this.userSessions.add(session);
        this.traceSystem.getTrace("session").info("connecting #" + session.getId() + " to " + this.databaseName);
        if (this.delayedCloser != null) {
            this.delayedCloser.reset();
            this.delayedCloser = null;
        }
        return session;
    }

    public synchronized void removeSession(Session session) {
        if (session != null) {
            if (this.exclusiveSession == session) {
                this.exclusiveSession = null;
            }
            this.userSessions.remove(session);
            if (session != this.systemSession) {
                this.traceSystem.getTrace("session").info("disconnecting #" + session.getId());
            }
        }
        if (this.userSessions.size() == 0 && session != this.systemSession) {
            if (this.closeDelay == 0) {
                this.close(false);
            } else {
                if (this.closeDelay < 0) {
                    return;
                }
                this.delayedCloser = new DatabaseCloser(this, this.closeDelay * 1000, false);
                this.delayedCloser.setName("H2 Close Delay " + this.getShortName());
                this.delayedCloser.setDaemon(true);
                this.delayedCloser.start();
            }
        }
        if (session != this.systemSession && session != null) {
            this.traceSystem.getTrace("session").info("disconnected #" + session.getId());
        }
    }

    private synchronized void closeAllSessionsException(Session session) {
        Session[] sessionArray = new Session[this.userSessions.size()];
        this.userSessions.toArray(sessionArray);
        for (Session session2 : sessionArray) {
            if (session2 == session) continue;
            try {
                session2.rollback();
                session2.close();
            }
            catch (DbException dbException) {
                this.traceSystem.getTrace("session").error("disconnecting #" + session2.getId(), dbException);
            }
        }
    }

    synchronized void close(boolean bl) {
        Object object;
        if (this.closing) {
            return;
        }
        if (this.fileLockMethod == 3 && !this.reconnectChangePending) {
            try {
                this.closeOpenFilesAndUnlock(false);
            }
            catch (DbException dbException) {
                // empty catch block
            }
            this.traceSystem.close();
            Engine.getInstance().close(this.databaseName);
            return;
        }
        this.closing = true;
        this.stopServer();
        if (this.userSessions.size() > 0) {
            if (!bl) {
                return;
            }
            this.traceSystem.getTrace("database").info("closing " + this.databaseName + " from shutdown hook");
            this.closeAllSessionsException(null);
        }
        this.traceSystem.getTrace("database").info("closing " + this.databaseName);
        if (this.eventListener != null) {
            this.closing = false;
            object = this.eventListener;
            this.eventListener = null;
            object.closingDatabase();
            if (this.userSessions.size() > 0) {
                return;
            }
            this.closing = true;
        }
        try {
            if (this.systemSession != null) {
                SchemaObjectBase schemaObjectBase;
                if (this.powerOffCount != -1) {
                    for (Table object2 : this.getAllTablesAndViews(false)) {
                        if (object2.isGlobalTemporary()) {
                            object2.removeChildrenAndResources(this.systemSession);
                            continue;
                        }
                        object2.close(this.systemSession);
                    }
                    for (SchemaObject schemaObject : this.getAllSchemaObjects(3)) {
                        schemaObjectBase = (Sequence)schemaObject;
                        ((Sequence)schemaObjectBase).close();
                    }
                }
                for (SchemaObject schemaObject : this.getAllSchemaObjects(4)) {
                    schemaObjectBase = (TriggerObject)schemaObject;
                    try {
                        ((TriggerObject)schemaObjectBase).close();
                    }
                    catch (SQLException sQLException) {
                        this.traceSystem.getTrace("database").error("close", sQLException);
                    }
                }
                if (this.powerOffCount != -1) {
                    this.meta.close(this.systemSession);
                    this.systemSession.commit(true);
                }
            }
        }
        catch (DbException dbException) {
            this.traceSystem.getTrace("database").error("close", dbException);
        }
        if (this.persistent) {
            try {
                this.getLobStorage();
                this.lobStorage.removeAllForTable(-1);
            }
            catch (DbException dbException) {
                this.traceSystem.getTrace("database").error("close", dbException);
            }
        }
        this.tempFileDeleter.deleteAll();
        try {
            this.closeOpenFilesAndUnlock(true);
        }
        catch (DbException dbException) {
            this.traceSystem.getTrace("database").error("close", dbException);
        }
        this.traceSystem.getTrace("database").info("closed");
        this.traceSystem.close();
        if (this.closeOnExit != null) {
            this.closeOnExit.reset();
            try {
                Runtime.getRuntime().removeShutdownHook(this.closeOnExit);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.closeOnExit = null;
        }
        Engine.getInstance().close(this.databaseName);
        if (this.deleteFilesOnDisconnect && this.persistent) {
            this.deleteFilesOnDisconnect = false;
            try {
                object = IOUtils.getParent(this.databaseName);
                String string = IOUtils.getFileName(this.databaseName);
                DeleteDbFiles.execute((String)object, string, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stopWriter() {
        if (this.writer != null) {
            this.writer.stopThread();
            this.writer = null;
        }
    }

    private synchronized void closeOpenFilesAndUnlock(boolean bl) {
        this.stopWriter();
        if (this.pageStore != null && bl) {
            try {
                this.pageStore.checkpoint();
                if (!this.readOnly) {
                    this.pageStore.compact(this.compactFully);
                }
            }
            catch (DbException dbException) {
                if (dbException.getErrorCode() != 90098 && SysProperties.CHECK2) {
                    dbException.printStackTrace();
                }
                this.traceSystem.getTrace("database").error("close", dbException);
            }
            catch (Throwable throwable) {
                if (SysProperties.CHECK2) {
                    throwable.printStackTrace();
                }
                this.traceSystem.getTrace("database").error("close", throwable);
            }
        }
        this.reconnectModified(false);
        this.closeFiles();
        if (this.persistent && this.lock == null && this.fileLockMethod != 0) {
            return;
        }
        if (this.persistent) {
            this.deleteOldTempFiles();
        }
        if (this.systemSession != null) {
            this.systemSession.close();
            this.systemSession = null;
        }
        if (this.lock != null) {
            if (this.fileLockMethod == 3) {
                try {
                    Thread.sleep((int)((double)SysProperties.RECONNECT_CHECK_DELAY * 1.1));
                }
                catch (InterruptedException interruptedException) {
                    this.traceSystem.getTrace("database").error("close", interruptedException);
                }
            }
            this.lock.unlock();
            this.lock = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFiles() {
        try {
            Database database = this;
            synchronized (database) {
                if (this.pageStore != null) {
                    this.pageStore.close();
                    this.pageStore = null;
                }
            }
        }
        catch (DbException dbException) {
            this.traceSystem.getTrace("database").error("close", dbException);
        }
    }

    private void checkMetaFree(Session session, int n) {
        SearchRow searchRow = this.meta.getTemplateSimpleRow(false);
        searchRow.setValue(0, ValueInt.get(n));
        Cursor cursor = this.metaIdIndex.find(session, searchRow, searchRow);
        if (cursor.next()) {
            DbException.throwInternalError();
        }
    }

    public synchronized int allocateObjectId() {
        int n = this.objectIds.nextClearBit(0);
        this.objectIds.set(n);
        return n;
    }

    public ArrayList<UserAggregate> getAllAggregates() {
        return New.arrayList(this.aggregates.values());
    }

    public ArrayList<Comment> getAllComments() {
        return New.arrayList(this.comments.values());
    }

    public int getAllowLiterals() {
        if (this.starting) {
            return 2;
        }
        return this.allowLiterals;
    }

    public ArrayList<Right> getAllRights() {
        return New.arrayList(this.rights.values());
    }

    public ArrayList<Role> getAllRoles() {
        return New.arrayList(this.roles.values());
    }

    public ArrayList<SchemaObject> getAllSchemaObjects() {
        this.initMetaTables();
        ArrayList<SchemaObject> arrayList = New.arrayList();
        for (Schema schema : this.schemas.values()) {
            arrayList.addAll(schema.getAll());
        }
        return arrayList;
    }

    public ArrayList<SchemaObject> getAllSchemaObjects(int n) {
        if (n == 0) {
            this.initMetaTables();
        }
        ArrayList<SchemaObject> arrayList = New.arrayList();
        for (Schema schema : this.schemas.values()) {
            arrayList.addAll(schema.getAll(n));
        }
        return arrayList;
    }

    public ArrayList<Table> getAllTablesAndViews(boolean bl) {
        if (bl) {
            this.initMetaTables();
        }
        ArrayList<Table> arrayList = New.arrayList();
        for (Schema schema : this.schemas.values()) {
            arrayList.addAll(schema.getAllTablesAndViews());
        }
        return arrayList;
    }

    public ArrayList<Schema> getAllSchemas() {
        this.initMetaTables();
        return New.arrayList(this.schemas.values());
    }

    public ArrayList<Setting> getAllSettings() {
        return New.arrayList(this.settings.values());
    }

    public ArrayList<UserDataType> getAllUserDataTypes() {
        return New.arrayList(this.userDataTypes.values());
    }

    public ArrayList<User> getAllUsers() {
        return New.arrayList(this.users.values());
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public String getCluster() {
        return this.cluster;
    }

    public CompareMode getCompareMode() {
        return this.compareMode;
    }

    @Override
    public String getDatabasePath() {
        if (this.persistent) {
            return IOUtils.getAbsolutePath(this.databaseName);
        }
        return null;
    }

    public String getShortName() {
        return this.databaseShortName;
    }

    public String getName() {
        return this.databaseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] getSessions(boolean bl) {
        ArrayList<Session> arrayList;
        Object object = this.userSessions;
        synchronized (object) {
            arrayList = New.arrayList(this.userSessions);
        }
        object = this.systemSession;
        if (bl && object != null) {
            arrayList.add((Session)object);
        }
        Session[] sessionArray = new Session[arrayList.size()];
        arrayList.toArray(sessionArray);
        return sessionArray;
    }

    public synchronized void update(Session session, DbObject dbObject) {
        int n = dbObject.getId();
        this.removeMeta(session, n);
        this.addMeta(session, dbObject);
    }

    public synchronized void renameSchemaObject(Session session, SchemaObject schemaObject, String string) {
        this.checkWritingAllowed();
        schemaObject.getSchema().rename(schemaObject, string);
        this.updateWithChildren(session, schemaObject);
    }

    private synchronized void updateWithChildren(Session session, DbObject dbObject) {
        ArrayList<DbObject> arrayList = dbObject.getChildren();
        Comment comment = this.findComment(dbObject);
        if (comment != null) {
            DbException.throwInternalError();
        }
        this.update(session, dbObject);
        for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
            DbObject dbObject2 = arrayList.get(i);
            if (dbObject2.getCreateSQL() == null) continue;
            this.update(session, dbObject2);
        }
    }

    public synchronized void renameDatabaseObject(Session session, DbObject dbObject, String string) {
        this.checkWritingAllowed();
        int n = dbObject.getType();
        HashMap<String, DbObject> hashMap = this.getMap(n);
        if (SysProperties.CHECK) {
            if (!hashMap.containsKey(dbObject.getName())) {
                DbException.throwInternalError("not found: " + dbObject.getName());
            }
            if (dbObject.getName().equals(string) || hashMap.containsKey(string)) {
                DbException.throwInternalError("object already exists: " + string);
            }
        }
        dbObject.checkRename();
        int n2 = dbObject.getId();
        this.removeMeta(session, n2);
        hashMap.remove(dbObject.getName());
        dbObject.rename(string);
        hashMap.put(string, dbObject);
        this.updateWithChildren(session, dbObject);
    }

    public String createTempFile() {
        try {
            boolean bl = this.readOnly;
            String string = this.databaseName;
            if (!this.persistent) {
                string = "memFS:" + string;
            }
            return IOUtils.createTempFile(string, ".temp.db", true, bl);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.databaseName);
        }
    }

    private void reserveLobFileObjectIds() {
        String[] stringArray;
        String string = IOUtils.normalize(this.databaseName) + ".";
        String string2 = IOUtils.getParent(this.databaseName);
        for (String string3 : stringArray = IOUtils.listFiles(string2)) {
            if (!string3.endsWith(".lob.db") || !IOUtils.fileStartsWith(string3, string)) continue;
            string3 = string3.substring(string.length());
            int n = (string3 = string3.substring(0, string3.length() - ".lob.db".length())).indexOf(46);
            if (n < 0) continue;
            String string4 = string3.substring(n + 1);
            int n2 = Integer.parseInt(string4);
            this.objectIds.set(n2);
        }
    }

    private void deleteOldTempFiles() {
        String[] stringArray;
        String string = IOUtils.getParent(this.databaseName);
        String string2 = IOUtils.normalize(this.databaseName);
        for (String string3 : stringArray = IOUtils.listFiles(string)) {
            if (!string3.endsWith(".temp.db") || !IOUtils.fileStartsWith(string3, string2)) continue;
            IOUtils.tryDelete(string3);
        }
    }

    public Schema getSchema(String string) {
        Schema schema = this.findSchema(string);
        if (schema == null) {
            throw DbException.get(90079, string);
        }
        return schema;
    }

    public synchronized void removeDatabaseObject(Session session, DbObject dbObject) {
        Comment comment;
        this.checkWritingAllowed();
        String string = dbObject.getName();
        int n = dbObject.getType();
        HashMap<String, DbObject> hashMap = this.getMap(n);
        if (SysProperties.CHECK && !hashMap.containsKey(string)) {
            DbException.throwInternalError("not found: " + string);
        }
        if ((comment = this.findComment(dbObject)) != null) {
            this.removeDatabaseObject(session, comment);
        }
        int n2 = dbObject.getId();
        dbObject.removeChildrenAndResources(session);
        hashMap.remove(string);
        this.removeMeta(session, n2);
    }

    public Table getDependentTable(SchemaObject schemaObject, Table table) {
        switch (schemaObject.getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 13: {
                return null;
            }
        }
        HashSet<DbObject> hashSet = New.hashSet();
        for (Table table2 : this.getAllTablesAndViews(false)) {
            if (table == table2) continue;
            hashSet.clear();
            table2.addDependencies(hashSet);
            if (!hashSet.contains(schemaObject)) continue;
            return table2;
        }
        return null;
    }

    public synchronized void removeSchemaObject(Session session, SchemaObject schemaObject) {
        Table table;
        DbObject dbObject;
        int n = schemaObject.getType();
        if (n == 0) {
            dbObject = (Table)schemaObject;
            if (dbObject.isTemporary() && !dbObject.isGlobalTemporary()) {
                session.removeLocalTempTable((Table)dbObject);
                return;
            }
        } else if (n == 1) {
            dbObject = (Index)schemaObject;
            table = dbObject.getTable();
            if (table.isTemporary() && !table.isGlobalTemporary()) {
                session.removeLocalTempTableIndex((Index)dbObject);
                return;
            }
        } else if (n == 5 && (table = ((Constraint)(dbObject = (Constraint)schemaObject)).getTable()).isTemporary() && !table.isGlobalTemporary()) {
            session.removeLocalTempTableConstraint((Constraint)dbObject);
            return;
        }
        this.checkWritingAllowed();
        dbObject = this.findComment(schemaObject);
        if (dbObject != null) {
            this.removeDatabaseObject(session, dbObject);
        }
        schemaObject.getSchema().remove(schemaObject);
        int n2 = schemaObject.getId();
        if (!this.starting) {
            Table table2 = this.getDependentTable(schemaObject, null);
            if (table2 != null) {
                schemaObject.getSchema().add(schemaObject);
                throw DbException.get(90107, schemaObject.getSQL(), table2.getSQL());
            }
            schemaObject.removeChildrenAndResources(session);
        }
        this.removeMeta(session, n2);
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public TraceSystem getTraceSystem() {
        return this.traceSystem;
    }

    public synchronized void setCacheSize(int n) {
        if (this.starting) {
            int n2 = MathUtils.convertLongToInt(Utils.getMemoryMax()) / 2;
            n = Math.min(n, n2);
        }
        this.cacheSize = n;
        if (this.pageStore != null) {
            this.pageStore.getCache().setMaxSize(n);
        }
    }

    public synchronized void setMasterUser(User user) {
        this.addDatabaseObject(this.systemSession, user);
        this.systemSession.commit(true);
    }

    public Role getPublicRole() {
        return this.publicRole;
    }

    public synchronized String getTempTableName(Session session) {
        String string;
        while (this.mainSchema.findTableOrView(session, string = "TEMP_TABLE_" + session.getId() + "_" + this.nextTempTableId++) != null) {
        }
        return string;
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }

    public void setCluster(String string) {
        this.cluster = string;
    }

    @Override
    public void checkWritingAllowed() {
        if (this.readOnly) {
            throw DbException.get(90097);
        }
        if (this.noDiskSpace) {
            throw DbException.get(90100);
        }
        if (this.fileLockMethod == 3 && !this.reconnectChangePending) {
            throw DbException.get(90097);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setWriteDelay(int n) {
        this.writeDelay = n;
        if (this.writer != null) {
            this.writer.setWriteDelay(n);
            this.flushOnEachCommit = this.writeDelay < SysProperties.MIN_WRITE_DELAY;
        }
    }

    public boolean getFlushOnEachCommit() {
        return this.flushOnEachCommit;
    }

    public ArrayList<InDoubtTransaction> getInDoubtTransactions() {
        return this.pageStore == null ? null : this.pageStore.getInDoubtTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareCommit(Session session, String string) {
        if (this.readOnly) {
            return;
        }
        Database database = this;
        synchronized (database) {
            this.pageStore.prepareCommit(session, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Session session) {
        if (this.readOnly) {
            return;
        }
        Database database = this;
        synchronized (database) {
            if (this.pageStore != null) {
                this.pageStore.commit(session);
            }
            session.setAllCommitted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Database database = this;
        synchronized (database) {
            if (this.readOnly || this.pageStore == null) {
                return;
            }
            this.pageStore.flushLog();
        }
    }

    public void setEventListener(DatabaseEventListener databaseEventListener) {
        this.eventListener = databaseEventListener;
    }

    public void setEventListenerClass(String string) {
        if (string == null || string.length() == 0) {
            this.eventListener = null;
        } else {
            try {
                this.eventListener = (DatabaseEventListener)Utils.loadUserClass(string).newInstance();
                String string2 = this.databaseURL;
                if (this.cipher != null) {
                    string2 = string2 + ";CIPHER=" + this.cipher;
                }
                this.eventListener.init(string2);
            }
            catch (Throwable throwable) {
                throw DbException.get(90099, throwable, string, throwable.toString());
            }
        }
    }

    @Override
    public synchronized void freeUpDiskSpace() {
        if (this.eventListener != null) {
            this.eventListener.diskSpaceIsLow();
        }
    }

    public void setProgress(int n, String string, int n2, int n3) {
        if (this.eventListener != null) {
            try {
                this.eventListener.setProgress(n, string, n2, n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void exceptionThrown(SQLException sQLException, String string) {
        if (this.eventListener != null) {
            try {
                this.eventListener.exceptionThrown(sQLException, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        Database database = this;
        synchronized (database) {
            if (this.readOnly || this.pageStore == null) {
                return;
            }
            this.pageStore.sync();
        }
    }

    public int getMaxMemoryRows() {
        return this.maxMemoryRows;
    }

    public void setMaxMemoryRows(int n) {
        this.maxMemoryRows = n;
    }

    public void setMaxMemoryUndo(int n) {
        this.maxMemoryUndo = n;
    }

    public int getMaxMemoryUndo() {
        return this.maxMemoryUndo;
    }

    public void setLockMode(int n) {
        switch (n) {
            case 0: {
                if (!this.multiThreaded) break;
                throw DbException.get(90133, "LOCK_MODE=0 & MULTI_THREADED");
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw DbException.getInvalidValueException("lock mode", "" + n);
            }
        }
        this.lockMode = n;
    }

    public int getLockMode() {
        return this.lockMode;
    }

    public synchronized void setCloseDelay(int n) {
        this.closeDelay = n;
    }

    public Session getSystemSession() {
        return this.systemSession;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void setMaxLengthInplaceLob(int n) {
        this.maxLengthInplaceLob = n;
    }

    @Override
    public int getMaxLengthInplaceLob() {
        return this.persistent ? this.maxLengthInplaceLob : Integer.MAX_VALUE;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public boolean getIgnoreCase() {
        if (this.starting) {
            return false;
        }
        return this.ignoreCase;
    }

    public synchronized void setDeleteFilesOnDisconnect(boolean bl) {
        this.deleteFilesOnDisconnect = bl;
    }

    @Override
    public String getLobCompressionAlgorithm(int n) {
        return this.lobCompressionAlgorithm;
    }

    public void setLobCompressionAlgorithm(String string) {
        this.lobCompressionAlgorithm = string;
    }

    public synchronized void setMaxLogSize(long l) {
        if (this.pageStore != null) {
            this.pageStore.setMaxLogSize(l);
        }
    }

    public void setAllowLiterals(int n) {
        this.allowLiterals = n;
    }

    public boolean getOptimizeReuseResults() {
        return this.optimizeReuseResults;
    }

    public void setOptimizeReuseResults(boolean bl) {
        this.optimizeReuseResults = bl;
    }

    @Override
    public Object getLobSyncObject() {
        return this.lobSyncObject;
    }

    public int getSessionCount() {
        return this.userSessions.size();
    }

    public void setReferentialIntegrity(boolean bl) {
        this.referentialIntegrity = bl;
    }

    public boolean getReferentialIntegrity() {
        return this.referentialIntegrity;
    }

    public boolean isStarting() {
        return this.starting;
    }

    public boolean isMultiVersion() {
        return this.multiVersion;
    }

    public void opened() {
        if (this.eventListener != null) {
            this.eventListener.opened();
        }
        if (this.writer != null) {
            this.writer.startThread();
        }
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isMultiThreaded() {
        return this.multiThreaded;
    }

    public void setMultiThreaded(boolean bl) {
        if (bl && this.multiVersion && this.multiThreaded != bl) {
            throw DbException.get(90133, "MVCC & MULTI_THREADED");
        }
        this.multiThreaded = bl;
    }

    public void setMaxOperationMemory(int n) {
        this.maxOperationMemory = n;
    }

    public int getMaxOperationMemory() {
        return this.maxOperationMemory;
    }

    public Session getExclusiveSession() {
        return this.exclusiveSession;
    }

    public void setExclusiveSession(Session session, boolean bl) {
        this.exclusiveSession = session;
        if (bl) {
            this.closeAllSessionsException(session);
        }
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        return this.lobFileListCache;
    }

    public boolean isSysTableLocked() {
        return this.meta == null || this.meta.isLockedExclusively();
    }

    public TableLinkConnection getLinkConnection(String string, String string2, String string3, String string4) {
        if (this.linkConnections == null) {
            this.linkConnections = New.hashMap();
        }
        return TableLinkConnection.open(this.linkConnections, string, string2, string3, string4);
    }

    public String toString() {
        return this.databaseShortName + ":" + super.toString();
    }

    public void shutdownImmediately() {
        this.setPowerOffCount(1);
        try {
            this.checkPowerOff();
        }
        catch (DbException dbException) {
            // empty catch block
        }
        this.closeFiles();
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return this.tempFileDeleter;
    }

    public Trace getTrace() {
        return this.getTrace("database");
    }

    public PageStore getPageStore() {
        if (this.pageStore == null) {
            this.pageStore = new PageStore(this, this.databaseName + ".h2.db", this.accessModeData, this.cacheSize);
            if (this.pageSize != SysProperties.PAGE_SIZE) {
                this.pageStore.setPageSize(this.pageSize);
            }
            this.pageStore.open();
        }
        return this.pageStore;
    }

    public Table getFirstUserTable() {
        for (Table table : this.getAllTablesAndViews(false)) {
            if (table.getCreateSQL() == null || table.isHidden()) continue;
            return table;
        }
        return null;
    }

    public boolean isReconnectNeeded() {
        if (this.fileLockMethod != 3) {
            return false;
        }
        if (this.reconnectChangePending) {
            return false;
        }
        long l = System.currentTimeMillis();
        if (l < this.reconnectCheckNext) {
            return false;
        }
        this.reconnectCheckNext = l + (long)SysProperties.RECONNECT_CHECK_DELAY;
        if (this.lock == null) {
            this.lock = new FileLock(this.traceSystem, this.databaseName + ".lock.db", 1000);
        }
        try {
            Properties properties;
            Properties properties2 = properties = this.lock.load();
            while (true) {
                if (properties.equals(this.reconnectLastLock)) {
                    return false;
                }
                if (properties.getProperty("changePending", null) == null) break;
                if (System.currentTimeMillis() > l + (long)(SysProperties.RECONNECT_CHECK_DELAY * 10) && properties2.equals(properties)) {
                    this.lock.setProperty("changePending", null);
                    this.lock.save();
                    break;
                }
                this.getTrace().debug("delay (change pending)");
                Thread.sleep(SysProperties.RECONNECT_CHECK_DELAY);
                properties = this.lock.load();
            }
            this.reconnectLastLock = properties;
        }
        catch (Exception exception) {
            this.getTrace().error("readOnly:" + this.readOnly, exception);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpointIfRequired() {
        if (this.fileLockMethod != 3 || this.readOnly || !this.reconnectChangePending || this.closing) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l > this.reconnectCheckNext + (long)SysProperties.RECONNECT_CHECK_DELAY) {
            if (SysProperties.CHECK && this.checkpointAllowed < 0) {
                DbException.throwInternalError();
            }
            Object object = this.reconnectSync;
            synchronized (object) {
                if (this.checkpointAllowed > 0) {
                    return;
                }
                this.checkpointRunning = true;
            }
            object = this;
            synchronized (object) {
                this.getTrace().debug("checkpoint start");
                this.flushSequences();
                this.checkpoint();
                this.reconnectModified(false);
                this.getTrace().debug("checkpoint end");
            }
            object = this.reconnectSync;
            synchronized (object) {
                this.checkpointRunning = false;
            }
        }
    }

    public boolean isFileLockSerialized() {
        return this.fileLockMethod == 3;
    }

    private void flushSequences() {
        for (SchemaObject schemaObject : this.getAllSchemaObjects(3)) {
            Sequence sequence = (Sequence)schemaObject;
            sequence.flushWithoutMargin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() {
        if (this.persistent) {
            Database database = this;
            synchronized (database) {
                if (this.pageStore != null) {
                    this.pageStore.checkpoint();
                }
            }
        }
        this.getTempFileDeleter().deleteUnused();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beforeWriting() {
        if (this.fileLockMethod != 3) {
            return true;
        }
        while (this.checkpointRunning) {
            try {
                Thread.sleep(10 + (int)(Math.random() * 10.0));
            }
            catch (Exception exception) {}
        }
        Object object = this.reconnectSync;
        synchronized (object) {
            if (this.reconnectModified(true)) {
                ++this.checkpointAllowed;
                if (SysProperties.CHECK && this.checkpointAllowed > 20) {
                    throw DbException.throwInternalError();
                }
                return true;
            }
        }
        this.reconnectCheckNext = System.currentTimeMillis() - 1L;
        this.reconnectLastLock = null;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterWriting() {
        if (this.fileLockMethod != 3) {
            return;
        }
        Object object = this.reconnectSync;
        synchronized (object) {
            --this.checkpointAllowed;
        }
        if (SysProperties.CHECK && this.checkpointAllowed < 0) {
            throw DbException.throwInternalError();
        }
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void setCompactFully(boolean bl) {
        this.compactFully = bl;
    }

    public SourceCompiler getCompiler() {
        if (this.compiler == null) {
            this.compiler = new SourceCompiler();
        }
        return this.compiler;
    }

    @Override
    public LobStorage getLobStorage() {
        if (this.lobStorage == null) {
            this.lobStorage = new LobStorage(this);
        }
        return this.lobStorage;
    }

    @Override
    public Connection getLobConnection() {
        String string = "jdbc:default:connection";
        JdbcConnection jdbcConnection = new JdbcConnection(this.systemSession, this.systemUser.getName(), string);
        jdbcConnection.setTraceLevel(0);
        return jdbcConnection;
    }
}

