/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import org.h2.command.Parser;
import org.h2.command.dml.Select;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.index.Index;
import org.h2.index.IndexCondition;
import org.h2.index.IndexCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableFilter
implements ColumnResolver {
    private static final int BEFORE_FIRST = 0;
    private static final int FOUND = 1;
    private static final int AFTER_LAST = 2;
    private static final int NULL_ROW = 3;
    private final Table table;
    private final Select select;
    private String alias;
    private Session session;
    private Index index;
    private int scanCount;
    private boolean used;
    private final IndexCursor cursor;
    private final ArrayList<IndexCondition> indexConditions = New.arrayList();
    private Expression filterCondition;
    private Expression joinCondition;
    private SearchRow currentSearchRow;
    private Row current;
    private int state;
    private TableFilter join;
    private boolean outerJoin;
    private ArrayList<Column> naturalJoinColumns;
    private boolean foundOne;
    private Expression fullCondition;
    private final int hashCode;

    public TableFilter(Session session, Table table, String string, boolean bl, Select select) {
        this.session = session;
        this.table = table;
        this.alias = string;
        this.select = select;
        this.cursor = new IndexCursor();
        if (!bl) {
            session.getUser().checkRight(table, 1);
        }
        this.hashCode = session.nextObjectId();
    }

    @Override
    public Select getSelect() {
        return this.select;
    }

    public Table getTable() {
        return this.table;
    }

    public void lock(Session session, boolean bl, boolean bl2) {
        this.table.lock(session, bl, bl2);
        if (this.join != null) {
            this.join.lock(session, bl, bl2);
        }
    }

    public PlanItem getBestPlanItem(Session session, int n) {
        PlanItem planItem;
        if (this.indexConditions.size() == 0) {
            planItem = new PlanItem();
            planItem.setIndex(this.table.getScanIndex(session));
            planItem.cost = planItem.getIndex().getCost(session, null);
        } else {
            int n2 = this.table.getColumns().length;
            int[] nArray = new int[n2];
            for (IndexCondition indexCondition : this.indexConditions) {
                int n3;
                if (!indexCondition.isEvaluatable()) continue;
                if (indexCondition.isAlwaysFalse()) {
                    nArray = null;
                    break;
                }
                int n4 = n3 = indexCondition.getColumn().getColumnId();
                nArray[n4] = nArray[n4] | indexCondition.getMask(this.indexConditions);
            }
            planItem = this.table.getBestPlanItem(session, nArray);
            planItem.cost -= planItem.cost * (double)this.indexConditions.size() / 100.0 / (double)n;
        }
        if (this.join != null) {
            this.setEvaluatable(this.join);
            planItem.setJoinPlan(this.join.getBestPlanItem(session, n));
            planItem.cost += planItem.cost * planItem.getJoinPlan().cost;
        }
        return planItem;
    }

    private void setEvaluatable(TableFilter tableFilter) {
        do {
            Expression expression;
            if ((expression = tableFilter.getJoinCondition()) == null) continue;
            expression.setEvaluatable(this, true);
        } while ((tableFilter = tableFilter.getJoin()) != null);
    }

    public void setPlanItem(PlanItem planItem) {
        this.setIndex(planItem.getIndex());
        if (this.join != null && planItem.getJoinPlan() != null) {
            this.join.setPlanItem(planItem.getJoinPlan());
        }
    }

    public void prepare() {
        for (int i = 0; i < this.indexConditions.size(); ++i) {
            Column column;
            IndexCondition indexCondition = this.indexConditions.get(i);
            if (indexCondition.isAlwaysFalse() || this.index.getColumnIndex(column = indexCondition.getColumn()) >= 0) continue;
            this.indexConditions.remove(i);
            --i;
        }
        if (this.join != null) {
            if (SysProperties.CHECK && this.join == this) {
                DbException.throwInternalError("self join");
            }
            this.join.prepare();
        }
        if (this.filterCondition != null) {
            this.filterCondition = this.filterCondition.optimize(this.session);
        }
        if (this.joinCondition != null) {
            this.joinCondition = this.joinCondition.optimize(this.session);
        }
    }

    public void startQuery(Session session) {
        this.session = session;
        this.scanCount = 0;
        if (this.join != null) {
            this.join.startQuery(session);
        }
    }

    public void reset() {
        if (this.join != null) {
            this.join.reset();
        }
        this.state = 0;
        this.foundOne = false;
    }

    public boolean next() {
        if (this.state == 2) {
            return false;
        }
        if (this.state == 0) {
            this.cursor.find(this.session, this.indexConditions);
            if (!this.cursor.isAlwaysFalse() && this.join != null) {
                this.join.reset();
            }
        } else if (this.join != null && this.join.next()) {
            return true;
        }
        while (this.state != 3) {
            if (this.cursor.isAlwaysFalse()) {
                this.state = 2;
            } else {
                if ((++this.scanCount & 0xFFF) == 0) {
                    this.checkTimeout();
                }
                if (this.cursor.next()) {
                    this.currentSearchRow = this.cursor.getSearchRow();
                    this.current = null;
                    this.state = 1;
                } else {
                    this.state = 2;
                }
            }
            if (this.state == 2) {
                if (!this.outerJoin || this.foundOne) break;
                this.state = 3;
                this.current = this.table.getNullRow();
                this.currentSearchRow = this.current;
            }
            if (!this.isOk(this.filterCondition)) continue;
            boolean bl = this.isOk(this.joinCondition);
            if (this.state == 1) {
                if (!bl) continue;
                this.foundOne = true;
            }
            if (this.join != null) {
                this.join.reset();
                if (!this.join.next()) continue;
            }
            if (this.state != 3 && !bl) continue;
            return true;
        }
        this.state = 2;
        return false;
    }

    private void checkTimeout() {
        this.session.checkCanceled();
    }

    private boolean isOk(Expression expression) {
        if (expression == null) {
            return true;
        }
        return Boolean.TRUE.equals(expression.getBooleanValue(this.session));
    }

    public Row get() {
        if (this.current == null && this.currentSearchRow != null) {
            this.current = this.cursor.get();
        }
        return this.current;
    }

    public void set(Row row) {
        this.current = row;
        this.currentSearchRow = row;
    }

    @Override
    public String getTableAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.table.getName();
    }

    public void addIndexCondition(IndexCondition indexCondition) {
        this.indexConditions.add(indexCondition);
    }

    public void addFilterCondition(Expression expression, boolean bl) {
        if (bl) {
            this.joinCondition = this.joinCondition == null ? expression : new ConditionAndOr(0, this.joinCondition, expression);
        } else {
            this.filterCondition = this.filterCondition == null ? expression : new ConditionAndOr(0, this.filterCondition, expression);
        }
    }

    public void addJoin(TableFilter tableFilter, boolean bl, Expression expression) {
        if (expression != null) {
            expression.mapColumns(this, 0);
        }
        if (this.join == null) {
            this.join = tableFilter;
            tableFilter.outerJoin = bl;
            if (bl) {
                TableFilter tableFilter2 = tableFilter.join;
                while (tableFilter2 != null) {
                    tableFilter2.outerJoin = true;
                    tableFilter2 = tableFilter2.join;
                }
            }
            if (expression != null) {
                tableFilter.mapAndAddFilter(expression);
            }
        } else {
            this.join.addJoin(tableFilter, bl, expression);
        }
    }

    public void mapAndAddFilter(Expression expression) {
        expression.mapColumns(this, 0);
        this.addFilterCondition(expression, true);
        expression.createIndexConditions(this.session, this);
        if (this.join != null) {
            this.join.mapAndAddFilter(expression);
        }
    }

    public TableFilter getJoin() {
        return this.join;
    }

    public boolean isJoinOuter() {
        return this.outerJoin;
    }

    public String getPlanSQL(boolean bl) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            if (this.outerJoin) {
                stringBuilder.append("LEFT OUTER JOIN ");
            } else {
                stringBuilder.append("INNER JOIN ");
            }
        }
        stringBuilder.append(this.table.getSQL());
        if (this.alias != null) {
            stringBuilder.append(' ').append(Parser.quoteIdentifier(this.alias));
        }
        if (this.index != null) {
            stringBuilder.append(" /* ");
            object = new StatementBuilder();
            ((StatementBuilder)object).append(this.index.getPlanSQL());
            if (this.indexConditions.size() > 0) {
                ((StatementBuilder)object).append(": ");
                for (IndexCondition indexCondition : this.indexConditions) {
                    ((StatementBuilder)object).appendExceptFirst(" AND ");
                    ((StatementBuilder)object).append(indexCondition.getSQL());
                }
            }
            String string = StringUtils.quoteRemarkSQL(((StatementBuilder)object).toString());
            stringBuilder.append(string).append(" */");
        }
        if (bl) {
            stringBuilder.append(" ON ");
            if (this.joinCondition == null) {
                stringBuilder.append("1=1");
            } else {
                stringBuilder.append(StringUtils.unEnclose(this.joinCondition.getSQL()));
            }
        }
        if (this.filterCondition != null) {
            stringBuilder.append(" /* WHERE ");
            object = StringUtils.unEnclose(this.filterCondition.getSQL());
            object = StringUtils.quoteRemarkSQL((String)object);
            stringBuilder.append((String)object).append(" */");
        }
        if (this.scanCount > 0) {
            stringBuilder.append(" /* scanCount: ").append(this.scanCount).append(" */");
        }
        return stringBuilder.toString();
    }

    void removeUnusableIndexConditions() {
        for (int i = 0; i < this.indexConditions.size(); ++i) {
            IndexCondition indexCondition = this.indexConditions.get(i);
            if (indexCondition.isEvaluatable()) continue;
            this.indexConditions.remove(i--);
        }
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
        this.cursor.setIndex(index);
    }

    public void setUsed(boolean bl) {
        this.used = bl;
    }

    public boolean isUsed() {
        return this.used;
    }

    void setSession(Session session) {
        this.session = session;
    }

    public void removeJoin() {
        this.join = null;
    }

    public Expression getJoinCondition() {
        return this.joinCondition;
    }

    public void removeJoinCondition() {
        this.joinCondition = null;
    }

    public Expression getFilterCondition() {
        return this.filterCondition;
    }

    public void removeFilterCondition() {
        this.filterCondition = null;
    }

    public void setFullCondition(Expression expression) {
        this.fullCondition = expression;
        if (this.join != null) {
            this.join.setFullCondition(expression);
        }
    }

    void optimizeFullCondition(boolean bl) {
        if (this.fullCondition != null) {
            this.fullCondition.addFilterConditions(this, bl || this.outerJoin);
            if (this.join != null) {
                this.join.optimizeFullCondition(bl || this.outerJoin);
            }
        }
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        if (this.filterCondition != null) {
            this.filterCondition.setEvaluatable(tableFilter, bl);
        }
        if (this.joinCondition != null) {
            this.joinCondition.setEvaluatable(tableFilter, bl);
        }
        if (this.join != null) {
            this.join.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public String getSchemaName() {
        return this.table.getSchema().getName();
    }

    @Override
    public Column[] getColumns() {
        return this.table.getColumns();
    }

    @Override
    public Column[] getSystemColumns() {
        if (!this.session.getDatabase().getMode().systemColumns) {
            return null;
        }
        Column[] columnArray = new Column[3];
        columnArray[0] = new Column("oid", 4);
        columnArray[0].setTable(this.table, 0);
        columnArray[1] = new Column("ctid", 13);
        columnArray[1].setTable(this.table, 0);
        columnArray[2] = new Column("CTID", 13);
        columnArray[2].setTable(this.table, 0);
        return columnArray;
    }

    @Override
    public Value getValue(Column column) {
        if (this.currentSearchRow == null) {
            return null;
        }
        int n = column.getColumnId();
        if (this.current == null) {
            Value value = this.currentSearchRow.getValue(n);
            if (value != null) {
                return value;
            }
            this.current = this.cursor.get();
        }
        return this.current.getValue(n);
    }

    @Override
    public TableFilter getTableFilter() {
        return this;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    @Override
    public Expression optimize(ExpressionColumn expressionColumn, Column column) {
        return expressionColumn;
    }

    public String toString() {
        return this.alias != null ? this.alias : this.table.toString();
    }

    public void addNaturalJoinColumn(Column column) {
        if (this.naturalJoinColumns == null) {
            this.naturalJoinColumns = New.arrayList();
        }
        this.naturalJoinColumns.add(column);
    }

    public boolean isNaturalJoinColumn(Column column) {
        return this.naturalJoinColumns != null && this.naturalJoinColumns.indexOf(column) >= 0;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean hasInComparisons() {
        for (IndexCondition indexCondition : this.indexConditions) {
            int n = indexCondition.getCompareType();
            if (n != 10 && n != 9) continue;
            return true;
        }
        return false;
    }

    public void lockRow(ArrayList<Row> arrayList) {
        if (this.state == 1) {
            arrayList.add(this.get());
        }
    }

    public void lockRows(ArrayList<Row> arrayList) {
        for (Row row : arrayList) {
            this.table.removeRow(this.session, row);
            this.table.addRow(this.session, row);
        }
    }
}

