/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.List;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.table.TableView;
import org.h2.util.New;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlterTableAlterColumn
extends SchemaCommand {
    public static final int NOT_NULL = 0;
    public static final int NULL = 1;
    public static final int DEFAULT = 2;
    public static final int CHANGE_TYPE = 3;
    public static final int ADD = 4;
    public static final int DROP = 5;
    public static final int SELECTIVITY = 6;
    private Table table;
    private Column oldColumn;
    private Column newColumn;
    private int type;
    private Expression defaultExpression;
    private Expression newSelectivity;
    private String addBefore;

    public AlterTableAlterColumn(Session session, Schema schema) {
        super(session, schema);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setOldColumn(Column column) {
        this.oldColumn = column;
    }

    public void setAddBefore(String string) {
        this.addBefore = string;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkRight(this.table, 15);
        this.table.checkSupportAlter();
        this.table.lock(this.session, true, true);
        Sequence sequence = this.oldColumn == null ? null : this.oldColumn.getSequence();
        switch (this.type) {
            case 0: {
                if (!this.oldColumn.isNullable()) break;
                this.checkNoNullValues();
                this.oldColumn.setNullable(false);
                database.update(this.session, this.table);
                break;
            }
            case 1: {
                if (this.oldColumn.isNullable()) break;
                this.checkNullable();
                this.oldColumn.setNullable(true);
                database.update(this.session, this.table);
                break;
            }
            case 2: {
                this.oldColumn.setSequence(null);
                this.oldColumn.setDefaultExpression(this.session, this.defaultExpression);
                this.removeSequence(sequence);
                database.update(this.session, this.table);
                break;
            }
            case 3: {
                this.oldColumn.setSequence(null);
                this.oldColumn.setDefaultExpression(this.session, null);
                this.oldColumn.setConvertNullToDefault(false);
                if (this.oldColumn.isNullable() && !this.newColumn.isNullable()) {
                    this.checkNoNullValues();
                } else if (!this.oldColumn.isNullable() && this.newColumn.isNullable()) {
                    this.checkNullable();
                }
                this.convertAutoIncrementColumn(this.newColumn);
                this.copyData();
                break;
            }
            case 4: {
                this.convertAutoIncrementColumn(this.newColumn);
                this.copyData();
                break;
            }
            case 5: {
                if (this.table.getColumns().length == 1) {
                    throw DbException.get(90084, this.oldColumn.getSQL());
                }
                this.table.checkColumnIsNotReferenced(this.oldColumn);
                this.dropSingleColumnIndexes();
                this.copyData();
                break;
            }
            case 6: {
                int n = this.newSelectivity.optimize(this.session).getValue(this.session).getInt();
                this.oldColumn.setSelectivity(n);
                database.update(this.session, this.table);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return 0;
    }

    private void convertAutoIncrementColumn(Column column) {
        if (column.isAutoIncrement()) {
            if (column.isPrimaryKey()) {
                column.setOriginalSQL("IDENTITY");
            } else {
                int n = this.getObjectId();
                column.convertAutoIncrementToSequence(this.session, this.getSchema(), n, this.table.isTemporary());
            }
        }
    }

    private void removeSequence(Sequence sequence) {
        if (sequence != null) {
            this.table.removeSequence(this.session, sequence);
            sequence.setBelongsToTable(false);
            Database database = this.session.getDatabase();
            database.removeSchemaObject(this.session, sequence);
        }
    }

    private void copyData() {
        List<String> list;
        if (this.table.isTemporary()) {
            throw DbException.getUnsupportedException("TEMP TABLE");
        }
        Database database = this.session.getDatabase();
        String string = database.getTempTableName(this.session);
        Column[] columnArray = this.table.getColumns();
        ArrayList<Column> arrayList = New.arrayList();
        TableData tableData = this.cloneTableStructure(columnArray, database, string, arrayList);
        try {
            list = this.checkViews(this.table, tableData);
        }
        catch (DbException dbException) {
            this.execute("DROP TABLE " + tableData.getName(), true);
            throw DbException.get(90109, dbException, this.getSQL(), dbException.getMessage());
        }
        String string2 = this.table.getName();
        this.execute("DROP TABLE " + this.table.getSQL(), true);
        database.renameSchemaObject(this.session, tableData, string2);
        for (DbObject object : tableData.getChildren()) {
            String string3;
            if (object instanceof Sequence || (string3 = object.getName()) == null || object.getCreateSQL() == null || !string3.startsWith(string + "_")) continue;
            string3 = string3.substring(string.length() + 1);
            SchemaObject schemaObject = (SchemaObject)object;
            if (schemaObject instanceof Constraint) {
                if (schemaObject.getSchema().findConstraint(this.session, string3) != null) {
                    string3 = schemaObject.getSchema().getUniqueConstraintName(this.session, tableData);
                }
            } else if (schemaObject instanceof Index && schemaObject.getSchema().findIndex(this.session, string3) != null) {
                string3 = schemaObject.getSchema().getUniqueIndexName(this.session, tableData, string3);
            }
            database.renameSchemaObject(this.session, schemaObject, string3);
        }
        for (String string4 : list) {
            this.execute(string4, true);
        }
    }

    private TableData cloneTableStructure(Column[] columnArray, Database database, String string, ArrayList<Column> arrayList) {
        Object object;
        Object object2;
        for (Column object42 : columnArray) {
            arrayList.add(object42.getClone());
        }
        if (this.type == 5) {
            int n = this.oldColumn.getColumnId();
            arrayList.remove(n);
        } else if (this.type == 4) {
            int n = this.addBefore == null ? columnArray.length : this.table.getColumn(this.addBefore).getColumnId();
            arrayList.add(n, this.newColumn);
        } else if (this.type == 3) {
            int n = this.oldColumn.getColumnId();
            arrayList.remove(n);
            arrayList.add(n, this.newColumn);
        }
        int n = database.allocateObjectId();
        CreateTableData createTableData = new CreateTableData();
        createTableData.tableName = string;
        createTableData.id = n;
        createTableData.columns = arrayList;
        createTableData.temporary = this.table.isTemporary();
        createTableData.persistData = this.table.isPersistData();
        createTableData.persistIndexes = this.table.isPersistIndexes();
        createTableData.create = true;
        createTableData.session = this.session;
        TableData tableData = this.getSchema().createTable(createTableData);
        tableData.setComment(this.table.getComment());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(tableData.getCreateSQL());
        StringBuilder stringBuilder2 = new StringBuilder();
        for (Column column : arrayList) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(", ");
            }
            if (this.type == 4 && column == this.newColumn) {
                object2 = column.getDefaultExpression();
                stringBuilder2.append(object2 == null ? "NULL" : ((Expression)object2).getSQL());
                continue;
            }
            stringBuilder2.append(column.getSQL());
        }
        stringBuilder.append(" AS SELECT ");
        if (stringBuilder2.length() == 0) {
            stringBuilder.append('*');
        } else {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        stringBuilder.append(" FROM ").append(this.table.getSQL());
        String string2 = stringBuilder.toString();
        String string3 = tableData.getName();
        object2 = tableData.getSchema();
        tableData.removeChildrenAndResources(this.session);
        this.execute(string2, true);
        tableData = (TableData)((Schema)object2).getTableOrView(this.session, string3);
        ArrayList<Object> arrayList2 = New.arrayList();
        for (DbObject dbObject : this.table.getChildren()) {
            ConstraintReferential constraintReferential;
            if (dbObject instanceof Sequence || dbObject instanceof Index && (object = (Index)dbObject).getIndexType().getBelongsToConstraint() || (object = dbObject.getCreateSQL()) == null || dbObject instanceof TableView) continue;
            if (dbObject.getType() == 0) {
                DbException.throwInternalError();
            }
            String string4 = Parser.quoteIdentifier(string + "_" + dbObject.getName());
            String string5 = null;
            if (dbObject instanceof ConstraintReferential && (constraintReferential = (ConstraintReferential)dbObject).getTable() != this.table) {
                string5 = constraintReferential.getCreateSQLForCopy(constraintReferential.getTable(), tableData, string4, false);
            }
            if (string5 == null) {
                string5 = dbObject.getCreateSQLForCopy(tableData, string4);
            }
            if (string5 == null) continue;
            if (dbObject instanceof TriggerObject) {
                arrayList2.add(string5);
                continue;
            }
            this.execute(string5, true);
        }
        this.table.setModified();
        for (Column column : arrayList) {
            object = column.getSequence();
            if (object == null) continue;
            this.table.removeSequence(this.session, (Sequence)object);
            column.setSequence(null);
        }
        for (String string6 : arrayList2) {
            this.execute(string6, true);
        }
        return tableData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> checkViews(SchemaObject schemaObject, SchemaObject schemaObject2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = schemaObject.getName();
        String string2 = schemaObject2.getName();
        Database database = schemaObject.getDatabase();
        database.renameSchemaObject(this.session, schemaObject, database.getTempTableName(this.session));
        try {
            database.renameSchemaObject(this.session, schemaObject2, string);
            this.checkViewsAreValid(schemaObject, arrayList);
        }
        finally {
            try {
                database.renameSchemaObject(this.session, schemaObject2, string2);
            }
            finally {
                database.renameSchemaObject(this.session, schemaObject, string);
            }
        }
        return arrayList;
    }

    private void checkViewsAreValid(DbObject dbObject, List<String> list) {
        for (DbObject dbObject2 : dbObject.getChildren()) {
            if (!(dbObject2 instanceof TableView)) continue;
            String string = ((TableView)dbObject2).getQuery();
            this.session.prepare(string);
            list.add(dbObject2.getDropSQL());
            list.add(dbObject2.getCreateSQL());
            this.checkViewsAreValid(dbObject2, list);
        }
    }

    private void execute(String string, boolean bl) {
        Prepared prepared = this.session.prepare(string);
        prepared.update();
        if (bl) {
            this.session.commit(true);
        }
    }

    private void dropSingleColumnIndexes() {
        Database database = this.session.getDatabase();
        ArrayList<Index> arrayList = this.table.getIndexes();
        for (int i = 0; i < arrayList.size(); ++i) {
            Column[] columnArray;
            Index index = arrayList.get(i);
            if (index.getCreateSQL() == null) continue;
            boolean bl = false;
            for (Column column : columnArray = index.getColumns()) {
                if (column != this.oldColumn) continue;
                if (columnArray.length == 1) {
                    bl = true;
                    continue;
                }
                throw DbException.get(90075, index.getSQL());
            }
            if (!bl) continue;
            database.removeSchemaObject(this.session, index);
            arrayList = this.table.getIndexes();
            i = -1;
        }
    }

    private void checkNullable() {
        for (Index index : this.table.getIndexes()) {
            IndexType indexType;
            if (index.getColumnIndex(this.oldColumn) < 0 || !(indexType = index.getIndexType()).isPrimaryKey() && !indexType.isHash()) continue;
            throw DbException.get(90075, index.getSQL());
        }
    }

    private void checkNoNullValues() {
        String string = "SELECT COUNT(*) FROM " + this.table.getSQL() + " WHERE " + this.oldColumn.getSQL() + " IS NULL";
        Prepared prepared = this.session.prepare(string);
        ResultInterface resultInterface = prepared.query(0);
        resultInterface.next();
        if (resultInterface.currentRow()[0].getInt() > 0) {
            throw DbException.get(90081, this.oldColumn.getSQL());
        }
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setSelectivity(Expression expression) {
        this.newSelectivity = expression;
    }

    public void setDefaultExpression(Expression expression) {
        this.defaultExpression = expression;
    }

    public void setNewColumn(Column column) {
        this.newColumn = column;
    }
}

