/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;
import java.util.Map;
import org.h2.util.Cache;
import org.h2.util.CacheObject;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;

class CacheSecondLevel
implements Cache {
    private final Cache baseCache;
    private final String prefix;
    private final Map map;

    CacheSecondLevel(Cache cache, String string, Map map) {
        this.baseCache = cache;
        this.prefix = string;
        this.map = map;
    }

    public void clear() {
        this.map.clear();
        this.baseCache.clear();
    }

    public CacheObject find(int n) {
        CacheObject cacheObject = this.baseCache.find(n);
        if (cacheObject == null) {
            cacheObject = (CacheObject)this.map.get(ObjectUtils.getInteger(n));
        }
        return cacheObject;
    }

    public CacheObject get(int n) {
        CacheObject cacheObject = this.baseCache.get(n);
        if (cacheObject == null) {
            cacheObject = (CacheObject)this.map.get(ObjectUtils.getInteger(n));
        }
        return cacheObject;
    }

    public ObjectArray getAllChanged() {
        return this.baseCache.getAllChanged();
    }

    public int getMaxSize() {
        return this.baseCache.getMaxSize();
    }

    public int getSize() {
        return this.baseCache.getSize();
    }

    public String getTypeName() {
        return this.prefix + this.baseCache.getTypeName();
    }

    public void put(CacheObject cacheObject) throws SQLException {
        this.baseCache.put(cacheObject);
        Integer n = ObjectUtils.getInteger(cacheObject.getPos());
        this.map.put(n, cacheObject);
    }

    public void remove(int n) {
        this.baseCache.remove(n);
        this.map.remove(ObjectUtils.getInteger(n));
    }

    public void setMaxSize(int n) throws SQLException {
        this.baseCache.setMaxSize(n);
    }

    public CacheObject update(int n, CacheObject cacheObject) throws SQLException {
        CacheObject cacheObject2 = this.baseCache.update(n, cacheObject);
        this.map.put(ObjectUtils.getInteger(n), cacheObject);
        return cacheObject2;
    }
}

