/*
 * Decompiled with CFR 0.152.
 */
package org.h2.constraint;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.constraint.Constraint;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.StringUtils;

public class ConstraintUnique
extends Constraint {
    private Index index;
    private boolean indexOwner;
    private IndexColumn[] columns;
    private boolean primaryKey;

    public ConstraintUnique(Schema schema, int n, String string, Table table, boolean bl) {
        super(schema, n, string, table);
        this.primaryKey = bl;
    }

    public String getConstraintType() {
        return this.primaryKey ? "PRIMARY KEY" : "UNIQUE";
    }

    public String getCreateSQLForCopy(Table table, String string) {
        return this.getCreateSQLForCopy(table, string, true);
    }

    private String getCreateSQLForCopy(Table table, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER TABLE ");
        stringBuffer.append(table.getSQL());
        stringBuffer.append(" ADD CONSTRAINT ");
        stringBuffer.append(string);
        if (this.comment != null) {
            stringBuffer.append(" COMMENT ");
            stringBuffer.append(StringUtils.quoteStringSQL(this.comment));
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.getTypeName());
        stringBuffer.append('(');
        for (int i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(Parser.quoteIdentifier(this.columns[i].column.getName()));
        }
        stringBuffer.append(')');
        if (bl && this.indexOwner && table == this.table) {
            stringBuffer.append(" INDEX ");
            stringBuffer.append(this.index.getSQL());
        }
        return stringBuffer.toString();
    }

    private String getTypeName() {
        if (this.primaryKey) {
            return "PRIMARY KEY";
        }
        return "UNIQUE";
    }

    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(), false);
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public void setColumns(IndexColumn[] indexColumnArray) {
        this.columns = indexColumnArray;
    }

    public IndexColumn[] getColumns() {
        return this.columns;
    }

    public void setIndex(Index index, boolean bl) {
        this.index = index;
        this.indexOwner = bl;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        this.table.removeConstraint(this);
        if (this.indexOwner) {
            this.table.removeIndexOrTransferOwnership(session, this.index);
        }
        this.database.removeMeta(session, this.getId());
        this.index = null;
        this.columns = null;
        this.table = null;
        this.invalidate();
    }

    public void checkRow(Session session, Table table, Row row, Row row2) {
    }

    public boolean usesIndex(Index index) {
        return index == this.index;
    }

    public void setIndexOwner(Index index) {
        this.indexOwner = true;
    }

    public boolean containsColumn(Column column) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i].column != column) continue;
            return true;
        }
        return false;
    }

    public boolean isBefore() {
        return true;
    }

    public void checkExistingData(Session session) {
    }

    public Index getUniqueIndex() {
        return this.index;
    }

    public void rebuild() {
    }
}

