/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Prepared;
import org.h2.command.ddl.AlterTableAddConstraint;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.SchemaCommand;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;
import org.h2.value.DataType;

public class CreateTable
extends SchemaCommand {
    private String tableName;
    private ObjectArray constraintCommands = new ObjectArray();
    private ObjectArray columns = new ObjectArray();
    private IndexColumn[] pkColumns;
    private boolean ifNotExists;
    private boolean persistIndexes = true;
    private boolean persistData = true;
    private boolean temporary;
    private boolean globalTemporary;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;
    private Query asQuery;
    private String comment;
    private boolean clustered;

    public CreateTable(Session session, Schema schema) {
        super(session, schema);
    }

    public void setQuery(Query query) {
        this.asQuery = query;
    }

    public void setTemporary(boolean bl) {
        this.temporary = bl;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void addColumn(Column column) {
        if (this.columns == null) {
            this.columns = new ObjectArray();
        }
        this.columns.add(column);
    }

    public void addConstraintCommand(Prepared prepared) throws SQLException {
        if (prepared instanceof CreateIndex) {
            this.constraintCommands.add(prepared);
        } else {
            AlterTableAddConstraint alterTableAddConstraint = (AlterTableAddConstraint)prepared;
            boolean bl = alterTableAddConstraint.getType() == 3 ? this.setPrimaryKeyColumns(alterTableAddConstraint.getIndexColumns()) : false;
            if (!bl) {
                this.constraintCommands.add(prepared);
            }
        }
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update() throws SQLException {
        block24: {
            Object object;
            int n;
            this.session.commit(true);
            Database database = this.session.getDatabase();
            if (!database.isPersistent()) {
                this.persistIndexes = false;
            }
            if (this.getSchema().findTableOrView(this.session, this.tableName) != null) {
                if (this.ifNotExists) {
                    return 0;
                }
                throw Message.getSQLException(42101, this.tableName);
            }
            if (this.asQuery != null) {
                this.asQuery.prepare();
                if (this.columns.size() == 0) {
                    this.generateColumnsFromQuery();
                } else if (this.columns.size() != this.asQuery.getColumnCount()) {
                    throw Message.getSQLException(21002);
                }
            }
            if (this.pkColumns != null) {
                int n2 = this.pkColumns.length;
                for (n = 0; n < this.columns.size(); ++n) {
                    object = (Column)this.columns.get(n);
                    for (int i = 0; i < n2; ++i) {
                        if (!((Column)object).getName().equals(this.pkColumns[i].columnName)) continue;
                        ((Column)object).setNullable(false);
                    }
                }
            }
            ObjectArray objectArray = new ObjectArray();
            for (n = 0; n < this.columns.size(); ++n) {
                Sequence sequence;
                object = (Column)this.columns.get(n);
                if (((Column)object).getAutoIncrement()) {
                    int n3 = this.getObjectId(true, true);
                    ((Column)object).convertAutoIncrementToSequence(this.session, this.getSchema(), n3, this.temporary);
                }
                if ((sequence = ((Column)object).getSequence()) == null) continue;
                objectArray.add(sequence);
            }
            n = this.getObjectId(true, true);
            object = this.getSchema().createTable(this.tableName, n, this.columns, this.persistIndexes, this.persistData, this.clustered, this.headPos, this.session);
            ((DbObjectBase)object).setComment(this.comment);
            ((DbObjectBase)object).setTemporary(this.temporary);
            ((TableData)object).setGlobalTemporary(this.globalTemporary);
            if (this.temporary && !this.globalTemporary) {
                if (this.onCommitDrop) {
                    ((Table)object).setOnCommitDrop(true);
                }
                if (this.onCommitTruncate) {
                    ((Table)object).setOnCommitTruncate(true);
                }
                this.session.addLocalTempTable((Table)object);
            } else {
                database.addSchemaObject(this.session, (SchemaObject)object);
            }
            try {
                Object object2;
                int n4;
                for (n4 = 0; n4 < this.columns.size(); n4 += 1) {
                    object2 = (Column)this.columns.get(n4);
                    ((Column)object2).prepareExpression(this.session);
                }
                for (n4 = 0; n4 < objectArray.size(); n4 += 1) {
                    object2 = (Sequence)objectArray.get(n4);
                    ((Table)object).addSequence((Sequence)object2);
                }
                for (n4 = 0; n4 < this.constraintCommands.size(); n4 += 1) {
                    object2 = (Prepared)this.constraintCommands.get(n4);
                    ((Prepared)object2).update();
                }
                if (this.asQuery == null) break block24;
                n4 = this.session.getUndoLogEnabled() ? 1 : 0;
                try {
                    this.session.setUndoLogEnabled(false);
                    object2 = null;
                    object2 = new Insert(this.session);
                    ((Insert)object2).setQuery(this.asQuery);
                    ((Insert)object2).setTable((Table)object);
                    ((Insert)object2).prepare();
                    ((Insert)object2).update();
                }
                finally {
                    this.session.setUndoLogEnabled(n4 != 0);
                }
            }
            catch (SQLException sQLException) {
                database.checkPowerOff();
                database.removeSchemaObject(this.session, (SchemaObject)object);
                throw sQLException;
            }
        }
        return 0;
    }

    private void generateColumnsFromQuery() {
        int n = this.asQuery.getColumnCount();
        ObjectArray objectArray = this.asQuery.getExpressions();
        for (int i = 0; i < n; ++i) {
            int n2;
            Expression expression = (Expression)objectArray.get(i);
            int n3 = expression.getType();
            String string = expression.getAlias();
            long l = expression.getPrecision();
            int n4 = expression.getDisplaySize();
            DataType dataType = DataType.getDataType(n3);
            if (l > 0L && (dataType.defaultPrecision == 0L || dataType.defaultPrecision > l && dataType.defaultPrecision < 127L)) {
                l = dataType.defaultPrecision;
            }
            if ((n2 = expression.getScale()) > 0 && (dataType.defaultScale == 0 || dataType.defaultScale > n2)) {
                n2 = dataType.defaultScale;
            }
            Column column = new Column(string, n3, l, n2, n4);
            this.addColumn(column);
        }
    }

    private boolean setPrimaryKeyColumns(IndexColumn[] indexColumnArray) throws SQLException {
        if (this.pkColumns != null) {
            if (indexColumnArray.length != this.pkColumns.length) {
                throw Message.getSQLException(90017);
            }
            for (int i = 0; i < indexColumnArray.length; ++i) {
                if (indexColumnArray[i].columnName.equals(this.pkColumns[i].columnName)) continue;
                throw Message.getSQLException(90017);
            }
            return true;
        }
        this.pkColumns = indexColumnArray;
        return false;
    }

    public void setPersistIndexes(boolean bl) {
        this.persistIndexes = bl;
    }

    public void setGlobalTemporary(boolean bl) {
        this.globalTemporary = bl;
    }

    public void setOnCommitDrop() {
        this.onCommitDrop = true;
    }

    public void setOnCommitTruncate() {
        this.onCommitTruncate = true;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setClustered(boolean bl) {
        this.clustered = bl;
    }

    public void setPersistData(boolean bl) {
        this.persistData = bl;
    }
}

