/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcClob;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.util.ObjectUtils;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLob;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public class DataType {
    public static final int TYPE_BOOLEAN = 16;
    public static final int TYPE_DATALINK = 70;
    private static final ArrayList TYPES = new ArrayList();
    private static final HashMap TYPES_BY_NAME = new HashMap();
    private static final ArrayList TYPES_BY_VALUE_TYPE = new ArrayList();
    public int type;
    public String name;
    public int sqlType;
    public String jdbc;
    public int sqlTypePos;
    public int maxPrecision;
    public int minScale;
    public int maxScale;
    public boolean decimal;
    public String prefix;
    public String suffix;
    public String params;
    public boolean autoIncrement;
    public boolean caseSensitive;
    public boolean supportsPrecision;
    public boolean supportsScale;
    public long defaultPrecision;
    public int defaultScale;
    public int defaultDisplaySize;
    public boolean hidden;
    public int memory;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$sql$Array;
    static /* synthetic */ Class class$java$sql$ResultSet;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class array$Ljava$lang$Object;

    private static void add(int n, int n2, String string, DataType dataType, String[] stringArray, int n3) {
        for (int i = 0; i < stringArray.length; ++i) {
            DataType dataType2 = new DataType();
            dataType2.type = n;
            dataType2.sqlType = n2;
            dataType2.jdbc = string;
            dataType2.name = stringArray[i];
            dataType2.autoIncrement = dataType.autoIncrement;
            dataType2.decimal = dataType.decimal;
            dataType2.maxPrecision = dataType.maxPrecision;
            dataType2.maxScale = dataType.maxScale;
            dataType2.minScale = dataType.minScale;
            dataType2.params = dataType.params;
            dataType2.prefix = dataType.prefix;
            dataType2.suffix = dataType.suffix;
            dataType2.supportsPrecision = dataType.supportsPrecision;
            dataType2.supportsScale = dataType.supportsScale;
            dataType2.defaultPrecision = dataType.defaultPrecision;
            dataType2.defaultScale = dataType.defaultScale;
            dataType2.defaultDisplaySize = dataType.defaultDisplaySize;
            dataType2.caseSensitive = dataType.caseSensitive;
            dataType2.hidden = i > 0;
            dataType2.memory = n3;
            for (int j = 0; j < TYPES.size(); ++j) {
                DataType dataType3 = (DataType)TYPES.get(j);
                if (dataType3.sqlType != dataType2.sqlType) continue;
                ++dataType2.sqlTypePos;
            }
            TYPES_BY_NAME.put(dataType2.name, dataType2);
            if (TYPES_BY_VALUE_TYPE.get(n) == null) {
                TYPES_BY_VALUE_TYPE.set(n, dataType2);
            }
            TYPES.add(dataType2);
        }
    }

    private static DataType createDecimal(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        DataType dataType = new DataType();
        dataType.maxPrecision = n;
        dataType.defaultPrecision = n2;
        dataType.defaultScale = n3;
        dataType.defaultDisplaySize = n4;
        if (bl) {
            dataType.params = "PRECISION,SCALE";
            dataType.supportsPrecision = true;
            dataType.supportsScale = true;
        }
        dataType.decimal = true;
        dataType.autoIncrement = bl2;
        return dataType;
    }

    private static DataType createDate(int n, String string, int n2, int n3) {
        DataType dataType = new DataType();
        dataType.prefix = string + " '";
        dataType.suffix = "'";
        dataType.maxPrecision = n;
        dataType.supportsScale = n2 != 0;
        dataType.maxScale = n2;
        dataType.defaultPrecision = n;
        dataType.defaultScale = n2;
        dataType.defaultDisplaySize = n3;
        return dataType;
    }

    private static DataType createString(boolean bl) {
        DataType dataType = new DataType();
        dataType.prefix = "'";
        dataType.suffix = "'";
        dataType.params = "LENGTH";
        dataType.caseSensitive = bl;
        dataType.supportsPrecision = true;
        dataType.maxPrecision = Integer.MAX_VALUE;
        dataType.defaultPrecision = Integer.MAX_VALUE;
        dataType.defaultDisplaySize = Integer.MAX_VALUE;
        return dataType;
    }

    public static ArrayList getTypes() {
        return TYPES;
    }

    public static Value readValue(SessionInterface sessionInterface, ResultSet resultSet, int n, int n2) throws SQLException {
        Value value;
        switch (n2) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 12: {
                byte[] byArray = resultSet.getBytes(n);
                value = byArray == null ? ValueNull.INSTANCE : ValueBytes.getNoCopy(byArray);
                break;
            }
            case 20: {
                byte[] byArray = resultSet.getBytes(n);
                value = byArray == null ? ValueNull.INSTANCE : ValueUuid.get(byArray);
                break;
            }
            case 1: {
                boolean bl = resultSet.getBoolean(n);
                value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueBoolean.get(bl);
                break;
            }
            case 2: {
                byte by = resultSet.getByte(n);
                value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueByte.get(by);
                break;
            }
            case 10: {
                Date date = resultSet.getDate(n);
                value = date == null ? ValueNull.INSTANCE : ValueDate.get(date);
                break;
            }
            case 9: {
                Time time = resultSet.getTime(n);
                value = time == null ? ValueNull.INSTANCE : ValueTime.get(time);
                break;
            }
            case 11: {
                Timestamp timestamp = resultSet.getTimestamp(n);
                value = timestamp == null ? ValueNull.INSTANCE : ValueTimestamp.get(timestamp);
                break;
            }
            case 6: {
                BigDecimal bigDecimal = resultSet.getBigDecimal(n);
                value = bigDecimal == null ? ValueNull.INSTANCE : ValueDecimal.get(bigDecimal);
                break;
            }
            case 7: {
                double d = resultSet.getDouble(n);
                value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueDouble.get(d);
                break;
            }
            case 8: {
                float f = resultSet.getFloat(n);
                value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueFloat.get(f);
                break;
            }
            case 4: {
                int n3 = resultSet.getInt(n);
                value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueInt.get(n3);
                break;
            }
            case 5: {
                long l = resultSet.getLong(n);
                value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueLong.get(l);
                break;
            }
            case 3: {
                short s = resultSet.getShort(n);
                value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueShort.get(s);
                break;
            }
            case 14: {
                String string = resultSet.getString(n);
                value = string == null ? ValueNull.INSTANCE : ValueStringIgnoreCase.get(string);
                break;
            }
            case 21: {
                String string = resultSet.getString(n);
                value = string == null ? ValueNull.INSTANCE : ValueStringFixed.get(string);
                break;
            }
            case 13: {
                String string = resultSet.getString(n);
                value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
                break;
            }
            case 16: {
                if (sessionInterface == null) {
                    value = ValueLob.createSmallLob(16, StringUtils.utf8Encode(resultSet.getString(n)));
                    break;
                }
                Reader reader = resultSet.getCharacterStream(n);
                if (reader == null) {
                    value = ValueNull.INSTANCE;
                    break;
                }
                value = ValueLob.createClob(new BufferedReader(reader), -1L, sessionInterface.getDataHandler());
                break;
            }
            case 15: {
                if (sessionInterface == null) {
                    value = ValueLob.createSmallLob(15, resultSet.getBytes(n));
                    break;
                }
                InputStream inputStream = resultSet.getBinaryStream(n);
                value = inputStream == null ? ValueNull.INSTANCE : ValueLob.createBlob(inputStream, -1L, sessionInterface.getDataHandler());
                break;
            }
            case 19: {
                byte[] byArray = resultSet.getBytes(n);
                value = byArray == null ? ValueNull.INSTANCE : ValueJavaObject.getNoCopy(byArray);
                break;
            }
            case 17: {
                Array array = resultSet.getArray(n);
                if (array == null) {
                    return ValueNull.INSTANCE;
                }
                Object[] objectArray = (Object[])array.getArray();
                if (objectArray == null) {
                    return ValueNull.INSTANCE;
                }
                Value[] valueArray = new Value[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    valueArray[i] = DataType.convertToValue(sessionInterface, objectArray[i], 0);
                }
                value = ValueArray.get(valueArray);
                break;
            }
            default: {
                throw Message.throwInternalError("type=" + n2);
            }
        }
        return value;
    }

    public static String getTypeClassName(int n) {
        switch (n) {
            case 1: {
                return (class$java$lang$Boolean == null ? (class$java$lang$Boolean = DataType.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName();
            }
            case 2: {
                return (class$java$lang$Byte == null ? (class$java$lang$Byte = DataType.class$("java.lang.Byte")) : class$java$lang$Byte).getName();
            }
            case 3: {
                return (class$java$lang$Short == null ? (class$java$lang$Short = DataType.class$("java.lang.Short")) : class$java$lang$Short).getName();
            }
            case 4: {
                return (class$java$lang$Integer == null ? (class$java$lang$Integer = DataType.class$("java.lang.Integer")) : class$java$lang$Integer).getName();
            }
            case 5: {
                return (class$java$lang$Long == null ? (class$java$lang$Long = DataType.class$("java.lang.Long")) : class$java$lang$Long).getName();
            }
            case 6: {
                return (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DataType.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName();
            }
            case 9: {
                return (class$java$sql$Time == null ? (class$java$sql$Time = DataType.class$("java.sql.Time")) : class$java$sql$Time).getName();
            }
            case 10: {
                return (class$java$sql$Date == null ? (class$java$sql$Date = DataType.class$("java.sql.Date")) : class$java$sql$Date).getName();
            }
            case 11: {
                return (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DataType.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).getName();
            }
            case 12: 
            case 20: {
                return (array$B == null ? (array$B = DataType.class$("[B")) : array$B).getName();
            }
            case 13: 
            case 14: 
            case 21: {
                return (class$java$lang$String == null ? (class$java$lang$String = DataType.class$("java.lang.String")) : class$java$lang$String).getName();
            }
            case 15: {
                return (class$java$io$InputStream == null ? (class$java$io$InputStream = DataType.class$("java.io.InputStream")) : class$java$io$InputStream).getName();
            }
            case 16: {
                return (class$java$io$Reader == null ? (class$java$io$Reader = DataType.class$("java.io.Reader")) : class$java$io$Reader).getName();
            }
            case 7: {
                return (class$java$lang$Double == null ? (class$java$lang$Double = DataType.class$("java.lang.Double")) : class$java$lang$Double).getName();
            }
            case 8: {
                return (class$java$lang$Float == null ? (class$java$lang$Float = DataType.class$("java.lang.Float")) : class$java$lang$Float).getName();
            }
            case 0: {
                return null;
            }
            case 19: {
                return (class$java$lang$Object == null ? (class$java$lang$Object = DataType.class$("java.lang.Object")) : class$java$lang$Object).getName();
            }
            case -1: {
                return (class$java$lang$Object == null ? (class$java$lang$Object = DataType.class$("java.lang.Object")) : class$java$lang$Object).getName();
            }
            case 17: {
                return (class$java$sql$Array == null ? (class$java$sql$Array = DataType.class$("java.sql.Array")) : class$java$sql$Array).getName();
            }
            case 18: {
                return (class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = DataType.class$("java.sql.ResultSet")) : class$java$sql$ResultSet).getName();
            }
        }
        throw Message.throwInternalError("type=" + n);
    }

    public static DataType getDataType(int n) {
        DataType dataType = (DataType)TYPES_BY_VALUE_TYPE.get(n);
        if (dataType == null) {
            dataType = (DataType)TYPES_BY_VALUE_TYPE.get(0);
        }
        return dataType;
    }

    public static int convertTypeToSQLType(int n) {
        return DataType.getDataType((int)n).sqlType;
    }

    public static int convertSQLTypeToValueType(int n) throws SQLException {
        switch (n) {
            case 1: {
                return 21;
            }
            case -1: 
            case 12: {
                return 13;
            }
            case 2: 
            case 3: {
                return 6;
            }
            case -7: 
            case 16: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 3;
            }
            case -6: {
                return 2;
            }
            case -5: {
                return 5;
            }
            case 7: {
                return 8;
            }
            case 6: 
            case 8: {
                return 7;
            }
            case -4: 
            case -3: 
            case -2: {
                return 12;
            }
            case 1111: 
            case 2000: {
                return 19;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 9;
            }
            case 93: {
                return 11;
            }
            case 2004: {
                return 15;
            }
            case 2005: {
                return 16;
            }
            case 0: {
                return 0;
            }
            case 2003: {
                return 17;
            }
        }
        throw Message.getSQLException(50004, "" + n);
    }

    public static int getTypeFromClass(Class clazz) throws SQLException {
        if (clazz == null) {
            return 0;
        }
        if ((class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = DataType.class$("java.sql.ResultSet")) : class$java$sql$ResultSet).isAssignableFrom(clazz)) {
            return 18;
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = DataType.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
            return 13;
        }
        if ((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DataType.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).isAssignableFrom(clazz)) {
            return 6;
        }
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = DataType.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return 1;
        }
        if ((class$java$lang$Byte == null ? (class$java$lang$Byte = DataType.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz)) {
            return 2;
        }
        if ((class$java$lang$Short == null ? (class$java$lang$Short = DataType.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz)) {
            return 3;
        }
        if ((class$java$lang$Integer == null ? (class$java$lang$Integer = DataType.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return 4;
        }
        if ((class$java$lang$Character == null ? (class$java$lang$Character = DataType.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz)) {
            throw Message.getSQLException(90021, "char (not supported)");
        }
        if ((class$java$lang$Long == null ? (class$java$lang$Long = DataType.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return 5;
        }
        if ((class$java$lang$Float == null ? (class$java$lang$Float = DataType.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            return 8;
        }
        if ((class$java$lang$Double == null ? (class$java$lang$Double = DataType.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            return 7;
        }
        if ((array$B == null ? (array$B = DataType.class$("[B")) : array$B).isAssignableFrom(clazz)) {
            return 12;
        }
        if ((class$java$sql$Date == null ? (class$java$sql$Date = DataType.class$("java.sql.Date")) : class$java$sql$Date).isAssignableFrom(clazz)) {
            return 10;
        }
        if ((class$java$sql$Time == null ? (class$java$sql$Time = DataType.class$("java.sql.Time")) : class$java$sql$Time).isAssignableFrom(clazz)) {
            return 9;
        }
        if ((class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DataType.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).isAssignableFrom(clazz)) {
            return 11;
        }
        if ((class$java$util$Date == null ? (class$java$util$Date = DataType.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(clazz)) {
            return 11;
        }
        if ((class$java$io$Reader == null ? (class$java$io$Reader = DataType.class$("java.io.Reader")) : class$java$io$Reader).isAssignableFrom(clazz)) {
            return 16;
        }
        if ((class$java$sql$Clob == null ? (class$java$sql$Clob = DataType.class$("java.sql.Clob")) : class$java$sql$Clob).isAssignableFrom(clazz)) {
            return 16;
        }
        if ((class$java$io$InputStream == null ? (class$java$io$InputStream = DataType.class$("java.io.InputStream")) : class$java$io$InputStream).isAssignableFrom(clazz)) {
            return 15;
        }
        if ((class$java$sql$Blob == null ? (class$java$sql$Blob = DataType.class$("java.sql.Blob")) : class$java$sql$Blob).isAssignableFrom(clazz)) {
            return 15;
        }
        if ((array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = DataType.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object).isAssignableFrom(clazz)) {
            return 17;
        }
        if (Void.TYPE == clazz) {
            return 0;
        }
        return 19;
    }

    public static Value convertToValue(SessionInterface sessionInterface, Object object, int n) throws SQLException {
        if (object == null) {
            return ValueNull.INSTANCE;
        }
        if (n == 19) {
            return ValueJavaObject.getNoCopy(ObjectUtils.serialize(object));
        }
        if (object instanceof String) {
            return ValueString.get((String)object);
        }
        if (object instanceof BigDecimal) {
            return ValueDecimal.get((BigDecimal)object);
        }
        if (object instanceof Boolean) {
            return ValueBoolean.get((Boolean)object);
        }
        if (object instanceof Byte) {
            return ValueByte.get((Byte)object);
        }
        if (object instanceof Short) {
            return ValueShort.get((Short)object);
        }
        if (object instanceof Integer) {
            return ValueInt.get((Integer)object);
        }
        if (object instanceof Long) {
            return ValueLong.get((Long)object);
        }
        if (object instanceof Float) {
            return ValueFloat.get(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return ValueDouble.get((Double)object);
        }
        if (object instanceof byte[]) {
            return ValueBytes.get((byte[])object);
        }
        if (object instanceof Date) {
            return ValueDate.get((Date)object);
        }
        if (object instanceof Time) {
            return ValueTime.get((Time)object);
        }
        if (object instanceof Timestamp) {
            return ValueTimestamp.get((Timestamp)object);
        }
        if (object instanceof java.util.Date) {
            return ValueTimestamp.get(new Timestamp(((java.util.Date)object).getTime()));
        }
        if (object instanceof Reader) {
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            return ValueLob.createClob(bufferedReader, -1L, sessionInterface.getDataHandler());
        }
        if (object instanceof Clob) {
            BufferedReader bufferedReader = new BufferedReader(((Clob)object).getCharacterStream());
            return ValueLob.createClob(bufferedReader, -1L, sessionInterface.getDataHandler());
        }
        if (object instanceof InputStream) {
            return ValueLob.createBlob((InputStream)object, -1L, sessionInterface.getDataHandler());
        }
        if (object instanceof Blob) {
            return ValueLob.createBlob(((Blob)object).getBinaryStream(), -1L, sessionInterface.getDataHandler());
        }
        if (object instanceof ResultSet) {
            return ValueResultSet.get((ResultSet)object);
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n2 = objectArray.length;
            Value[] valueArray = new Value[n2];
            for (int i = 0; i < n2; ++i) {
                valueArray[i] = DataType.convertToValue(sessionInterface, objectArray[i], n);
            }
            return ValueArray.get(valueArray);
        }
        return ValueJavaObject.getNoCopy(ObjectUtils.serialize(object));
    }

    public static DataType getTypeByName(String string) {
        return (DataType)TYPES_BY_NAME.get(string);
    }

    public static boolean isLargeObject(int n) {
        return n == 15 || n == 16;
    }

    public static boolean supportsAdd(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static int getAddProofType(int n) {
        switch (n) {
            case 2: {
                return 5;
            }
            case 8: {
                return 7;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 3: {
                return 5;
            }
        }
        return n;
    }

    public static Object getDefaultForPrimitiveType(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Byte.TYPE) {
            return ObjectUtils.getByte((byte)0);
        }
        if (clazz == Character.TYPE) {
            return ObjectUtils.getCharacter('\u0000');
        }
        if (clazz == Short.TYPE) {
            return ObjectUtils.getShort((short)0);
        }
        if (clazz == Integer.TYPE) {
            return ObjectUtils.getInteger(0);
        }
        if (clazz == Long.TYPE) {
            return ObjectUtils.getLong(0L);
        }
        if (clazz == Float.TYPE) {
            return ObjectUtils.getFloat(0.0f);
        }
        if (clazz == Double.TYPE) {
            return ObjectUtils.getDouble(0.0);
        }
        throw Message.throwInternalError("primitive=" + clazz.toString());
    }

    public static Object convertTo(SessionInterface sessionInterface, JdbcConnection jdbcConnection, Value value, Class clazz) throws SQLException {
        if (clazz == (class$java$sql$Blob == null ? (class$java$sql$Blob = DataType.class$("java.sql.Blob")) : class$java$sql$Blob)) {
            return new JdbcBlob(jdbcConnection, value, 0);
        }
        if (clazz == (class$java$sql$Clob == null ? (class$java$sql$Clob = DataType.class$("java.sql.Clob")) : class$java$sql$Clob)) {
            return new JdbcClob(jdbcConnection, value, 0);
        }
        throw Message.getUnsupportedException(clazz.getName());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        for (int i = 0; i < 22; ++i) {
            TYPES_BY_VALUE_TYPE.add(null);
        }
        DataType.add(0, 0, "Null", new DataType(), new String[]{"NULL"}, 1);
        DataType.add(13, 12, "String", DataType.createString(true), new String[]{"VARCHAR", "VARCHAR2", "NVARCHAR", "NVARCHAR2", "VARCHAR_CASESENSITIVE", "CHARACTER VARYING", "TID"}, 4);
        DataType.add(13, -1, "String", DataType.createString(true), new String[]{"LONGVARCHAR"}, 4);
        DataType.add(21, 1, "String", DataType.createString(true), new String[]{"CHAR", "CHARACTER", "NCHAR"}, 4);
        DataType.add(14, 12, "String", DataType.createString(false), new String[]{"VARCHAR_IGNORECASE"}, 4);
        DataType.add(1, 16, "Boolean", DataType.createDecimal(1, 1, 0, 5, false, false), new String[]{"BOOLEAN", "BIT", "BOOL"}, 1);
        DataType.add(2, -6, "Byte", DataType.createDecimal(3, 3, 0, 4, false, false), new String[]{"TINYINT"}, 1);
        DataType.add(3, 5, "Short", DataType.createDecimal(5, 5, 0, 6, false, false), new String[]{"SMALLINT", "YEAR", "INT2"}, 5);
        DataType.add(4, 4, "Int", DataType.createDecimal(10, 10, 0, 11, false, false), new String[]{"INTEGER", "INT", "MEDIUMINT", "INT4", "SIGNED"}, 5);
        DataType.add(5, -5, "Long", DataType.createDecimal(19, 19, 0, 20, false, false), new String[]{"BIGINT", "INT8"}, 5);
        DataType.add(5, -5, "Long", DataType.createDecimal(19, 19, 0, 20, false, true), new String[]{"IDENTITY", "SERIAL"}, 5);
        DataType.add(6, 3, "BigDecimal", DataType.createDecimal(Integer.MAX_VALUE, 65535, Short.MAX_VALUE, 65535, true, false), new String[]{"DECIMAL", "DEC"}, 17);
        DataType.add(6, 2, "BigDecimal", DataType.createDecimal(Integer.MAX_VALUE, 65535, Short.MAX_VALUE, 65535, true, false), new String[]{"NUMERIC", "NUMBER"}, 17);
        DataType.add(8, 7, "Float", DataType.createDecimal(7, 7, 0, 15, false, false), new String[]{"REAL", "FLOAT4"}, 5);
        DataType.add(7, 8, "Double", DataType.createDecimal(17, 17, 0, 24, false, false), new String[]{"DOUBLE", "DOUBLE PRECISION"}, 4);
        DataType.add(7, 6, "Double", DataType.createDecimal(17, 17, 0, 24, false, false), new String[]{"FLOAT", "FLOAT8"}, 4);
        DataType.add(9, 92, "Time", DataType.createDate(6, "TIME", 0, 8), new String[]{"TIME"}, 10);
        DataType.add(10, 91, "Date", DataType.createDate(8, "DATE", 0, 10), new String[]{"DATE"}, 10);
        DataType.add(11, 93, "Timestamp", DataType.createDate(23, "TIMESTAMP", 10, 23), new String[]{"TIMESTAMP", "DATETIME", "SMALLDATETIME"}, 12);
        DataType.add(12, -3, "Bytes", DataType.createString(false), new String[]{"VARBINARY"}, 8);
        DataType.add(12, -2, "Bytes", DataType.createString(false), new String[]{"BINARY", "RAW", "BYTEA", "LONG RAW"}, 8);
        DataType.add(12, -4, "Bytes", DataType.createString(false), new String[]{"LONGVARBINARY"}, 8);
        DataType.add(20, -2, "Bytes", DataType.createString(false), new String[]{"UUID"}, 8);
        DataType.add(19, 1111, "Object", DataType.createString(false), new String[]{"OTHER", "OBJECT", "JAVA_OBJECT"}, 8);
        DataType.add(15, 2004, "Bytes", DataType.createString(false), new String[]{"BLOB", "TINYBLOB", "MEDIUMBLOB", "LONGBLOB", "IMAGE", "OID"}, 10);
        DataType.add(16, 2005, "String", DataType.createString(true), new String[]{"CLOB", "TINYTEXT", "TEXT", "MEDIUMTEXT", "LONGTEXT", "NTEXT", "NCLOB"}, 10);
        DataType dataType = new DataType();
        dataType.prefix = "(";
        dataType.suffix = "')";
        DataType.add(17, 2003, "Array", dataType, new String[]{"ARRAY"}, 10);
        dataType = new DataType();
        DataType.add(18, 0, "ResultSet", dataType, new String[]{"RESULT_SET"}, 20);
        for (int i = 0; i < TYPES_BY_VALUE_TYPE.size(); ++i) {
            DataType dataType2 = (DataType)TYPES_BY_VALUE_TYPE.get(i);
            if (dataType2 == null) {
                Message.throwInternalError("unmapped type " + i);
            }
            Value.getOrder(i);
        }
    }
}

