/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.PageData;
import org.h2.index.PageDataLeaf;
import org.h2.index.PageDataLeafOverflow;
import org.h2.index.PageDataNode;
import org.h2.index.RowIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.DataPage;
import org.h2.store.PageStore;
import org.h2.store.Record;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;
import org.h2.value.Value;
import org.h2.value.ValueLob;

public class PageScanIndex
extends BaseIndex
implements RowIndex {
    private PageStore store;
    private TableData tableData;
    private final int headPos;
    private int lastKey;
    private long rowCount;

    public PageScanIndex(TableData tableData, int n, IndexColumn[] indexColumnArray, IndexType indexType, int n2) throws SQLException {
        this.initBaseIndex(tableData, n, tableData.getName() + "_TABLE_SCAN", indexColumnArray, indexType);
        this.trace.setLevel(3);
        if (this.database.isMultiVersion()) {
            // empty if block
        }
        this.tableData = tableData;
        this.store = this.database.getPageStore();
        if (!this.database.isPersistent()) {
            this.headPos = 0;
            return;
        }
        if (n2 == -1) {
            this.headPos = n2 = this.store.allocatePage();
            this.store.addMeta(this);
            PageDataLeaf pageDataLeaf = new PageDataLeaf(this, n2, 0, this.store.createDataPage());
            this.store.updateRecord(pageDataLeaf, true, pageDataLeaf.data);
        } else {
            this.headPos = n2;
            PageData pageData = this.getPage(n2);
            this.lastKey = pageData.getLastKey();
            this.rowCount = pageData.getRowCount();
            this.store.updateRecord(pageData, false, null);
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("opened " + this.getName() + " rows:" + this.rowCount);
        }
        tableData.setRowCount(this.rowCount);
    }

    public int getHeadPos() {
        return this.headPos;
    }

    public void add(Session session, Row row) throws SQLException {
        PageData pageData;
        int n;
        if (row.getPos() == 0) {
            row.setPos(++this.lastKey);
        } else {
            this.lastKey = Math.max(this.lastKey, row.getPos() + 1);
        }
        if (this.trace.isDebugEnabled()) {
            if (this.table.getId() == -1) {
                System.out.println("pause");
            }
            this.trace.debug("add table:" + this.table.getId() + " " + row);
        }
        if (this.tableData.getContainsLargeObject()) {
            for (int i = 0; i < row.getColumnCount(); ++i) {
                Value value = row.getValue(i);
                Value value2 = value.link(this.database, this.getId());
                if (value2.isLinked()) {
                    session.unlinkAtCommitStop(value2);
                }
                if (value == value2) continue;
                row.setValue(i, value2);
            }
        }
        while ((n = (pageData = this.getPage(this.headPos)).addRow(row)) != 0) {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("split " + n);
            }
            int n2 = pageData.getKey(n - 1);
            PageData pageData2 = pageData;
            PageData pageData3 = pageData.split(n);
            int n3 = pageData.getPageId();
            int n4 = this.store.allocatePage();
            pageData2.setPageId(n4);
            pageData2.setParentPageId(this.headPos);
            pageData3.setParentPageId(this.headPos);
            PageDataNode pageDataNode = new PageDataNode(this, n3, 0, this.store.createDataPage());
            pageDataNode.init(pageData2, n2, pageData3);
            this.store.updateRecord(pageData2, true, pageData2.data);
            this.store.updateRecord(pageData3, true, pageData3.data);
            this.store.updateRecord(pageDataNode, true, null);
            pageData = pageDataNode;
        }
        ++this.rowCount;
        this.store.logAddOrRemoveRow(session, this.tableData.getId(), row, true);
    }

    PageData getPage(int n) throws SQLException {
        PageData pageData;
        Record record = this.store.getRecord(n);
        if (record != null) {
            if (record instanceof PageDataLeafOverflow) {
                System.out.println("stop");
            }
            return (PageData)record;
        }
        DataPage dataPage = this.store.readPage(n);
        dataPage.reset();
        int n2 = dataPage.readInt();
        int n3 = dataPage.readByte() & 0xFF;
        switch (n3 & 0xFFFFFFEF) {
            case 1: {
                pageData = new PageDataLeaf(this, n, n2, dataPage);
                break;
            }
            case 2: {
                pageData = new PageDataNode(this, n, n2, dataPage);
                break;
            }
            case 0: {
                PageDataLeaf pageDataLeaf = new PageDataLeaf(this, n, n2, dataPage);
                return pageDataLeaf;
            }
            default: {
                throw Message.getSQLException(90030, "page=" + n + " type=" + n3);
            }
        }
        pageData.read();
        return pageData;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        PageData pageData = this.getPage(this.headPos);
        return pageData.find();
    }

    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        throw Message.getUnsupportedException("PAGE");
    }

    public double getCost(Session session, int[] nArray) throws SQLException {
        long l = 10L * (this.tableData.getRowCountApproximation() + 1000L);
        return l;
    }

    public boolean needRebuild() {
        return false;
    }

    public void remove(Session session, Row row) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove " + row.getPos());
            if (this.table.getId() == -1) {
                System.out.println("pause");
            }
        }
        if (this.tableData.getContainsLargeObject()) {
            for (int i = 0; i < row.getColumnCount(); ++i) {
                Value value = row.getValue(i);
                if (!value.isLinked()) continue;
                session.unlinkAtCommit((ValueLob)value);
            }
        }
        if (this.rowCount == 1L) {
            this.removeAllRows();
        } else {
            int n = row.getPos();
            PageData pageData = this.getPage(this.headPos);
            pageData.remove(n);
            --this.rowCount;
        }
        this.store.logAddOrRemoveRow(session, this.tableData.getId(), row, false);
    }

    public void remove(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove");
        }
        this.store.removeMeta(this);
    }

    public void truncate(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("truncate");
        }
        this.removeAllRows();
        if (this.tableData.getContainsLargeObject() && this.tableData.isPersistData()) {
            ValueLob.removeAllForTable(this.database, this.table.getId());
        }
        this.tableData.setRowCount(0L);
    }

    private void removeAllRows() throws SQLException {
        this.store.removeRecord(this.headPos);
        PageDataLeaf pageDataLeaf = new PageDataLeaf(this, this.headPos, 0, this.store.createDataPage());
        this.store.updateRecord(pageDataLeaf, true, null);
        this.rowCount = 0L;
        this.lastKey = 0;
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException("PAGE");
    }

    public Row getRow(Session session, int n) throws SQLException {
        PageData pageData = this.getPage(this.headPos);
        return pageData.getRow(session, n);
    }

    PageStore getPageStore() {
        return this.store;
    }

    Row readRow(DataPage dataPage) throws SQLException {
        return this.tableData.readRow(dataPage);
    }

    public long getRowCountApproximation() {
        return this.rowCount;
    }

    public long getRowCount(Session session) {
        return this.rowCount;
    }

    public String getCreateSQL() {
        return null;
    }

    public int getColumnIndex(Column column) {
        return -1;
    }

    public void close(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("close");
        }
    }
}

