/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import org.h2.constant.SysProperties;
import org.h2.util.MathUtils;
import org.h2.util.StringCache;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueStringBase;

public class ValueStringIgnoreCase
extends ValueStringBase {
    private static final ValueStringIgnoreCase EMPTY = new ValueStringIgnoreCase("");
    private int hash;

    protected ValueStringIgnoreCase(String string) {
        super(string);
    }

    public int getType() {
        return 14;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueStringIgnoreCase valueStringIgnoreCase = (ValueStringIgnoreCase)value;
        return compareMode.compareString(this.value, valueStringIgnoreCase.value, true);
    }

    public boolean equals(Object object) {
        return object instanceof ValueStringBase && this.value.equalsIgnoreCase(((ValueStringBase)object).value);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.value.toUpperCase().hashCode();
        }
        return this.hash;
    }

    public String getSQL() {
        return "CAST(" + StringUtils.quoteStringSQL(this.value) + " AS VARCHAR_IGNORECASE)";
    }

    public static ValueStringIgnoreCase get(String string) {
        if (string.length() == 0) {
            return EMPTY;
        }
        ValueStringIgnoreCase valueStringIgnoreCase = new ValueStringIgnoreCase(StringCache.get(string));
        if (string.length() > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return valueStringIgnoreCase;
        }
        ValueStringIgnoreCase valueStringIgnoreCase2 = (ValueStringIgnoreCase)Value.cache(valueStringIgnoreCase);
        if (valueStringIgnoreCase2.value.equals(string)) {
            return valueStringIgnoreCase2;
        }
        return valueStringIgnoreCase;
    }

    public Value convertPrecision(long l) {
        if (l == 0L || (long)this.value.length() <= l) {
            return this;
        }
        int n = MathUtils.convertLongToInt(l);
        return ValueStringIgnoreCase.get(this.value.substring(0, n));
    }
}

